/*
 * Decompiled with CFR 0.152.
 */
package com.github.felfert.sslutils;

import java.math.BigInteger;

public final class SimpleDERReader {
    private static final int CONSTRUCTED = 32;
    private byte[] buffer;
    private int pos;
    private int count;

    public SimpleDERReader(byte[] b) {
        this.resetInput(b);
    }

    public SimpleDERReader(byte[] b, int off, int len) {
        this.resetInput(b, off, len);
    }

    public void resetInput(byte[] b) {
        this.resetInput(b, 0, b.length);
    }

    public void resetInput(byte[] b, int off, int len) {
        this.buffer = (byte[])b.clone();
        this.pos = off;
        this.count = len;
    }

    private byte readByte() {
        if (this.count <= 0) {
            throw new IllegalArgumentException("DER byte array: out of data");
        }
        --this.count;
        return this.buffer[this.pos++];
    }

    private byte[] readBytes(int len) {
        if (len > this.count) {
            throw new IllegalArgumentException("DER byte array: out of data");
        }
        byte[] b = new byte[len];
        System.arraycopy(this.buffer, this.pos, b, 0, len);
        this.pos += len;
        this.count -= len;
        return b;
    }

    public int available() {
        return this.count;
    }

    private int readLength() {
        int len = this.readByte() & 0xFF;
        if ((len & 0x80) == 0) {
            return len;
        }
        int remain = len & 0x7F;
        if (remain == 0) {
            return -1;
        }
        len = 0;
        while (remain > 0) {
            len <<= 8;
            len |= this.readByte() & 0xFF;
            --remain;
        }
        return len;
    }

    public int ignoreNextObject() {
        int type = this.readByte() & 0xFF;
        int len = this.readLength();
        if (len < 0 || len > this.available()) {
            throw new IllegalArgumentException("Illegal len in DER object (" + len + ")");
        }
        this.readBytes(len);
        return type;
    }

    public BigInteger readInt() {
        int type = this.readByte() & 0xFF;
        if (type != 2) {
            throw new IllegalArgumentException("Expected DER Integer, but found type " + type);
        }
        int len = this.readLength();
        if (len < 0 || len > this.available()) {
            throw new IllegalArgumentException("Illegal len in DER object (" + len + ")");
        }
        byte[] b = this.readBytes(len);
        return new BigInteger(b);
    }

    public int readConstructedType() {
        int type = this.readByte() & 0xFF;
        if ((type & 0x20) != 32) {
            throw new IllegalArgumentException("Expected constructed type, but was " + type);
        }
        return type & 0x1F;
    }

    public SimpleDERReader readConstructed() {
        int len = this.readLength();
        if (len < 0 || len > this.available()) {
            throw new IllegalArgumentException("Illegal len in DER object (" + len + ")");
        }
        SimpleDERReader cr = new SimpleDERReader(this.buffer, this.pos, len);
        this.pos += len;
        this.count -= len;
        return cr;
    }

    public byte[] readSequenceAsByteArray() {
        int type = this.readByte() & 0xFF;
        if (type != 48) {
            throw new IllegalArgumentException("Expected DER Sequence, but found type " + type);
        }
        int len = this.readLength();
        if (len < 0 || len > this.available()) {
            throw new IllegalArgumentException("Illegal len in DER object (" + len + ")");
        }
        return this.readBytes(len);
    }

    public String readOid() {
        int type = this.readByte() & 0xFF;
        if (type != 6) {
            throw new IllegalArgumentException("Expected DER OID, but found type " + type);
        }
        int len = this.readLength();
        if (len < 1 || len > this.available()) {
            throw new IllegalArgumentException("Illegal len in DER object (" + len + ")");
        }
        byte[] b = this.readBytes(len);
        long value = 0L;
        StringBuilder sb = new StringBuilder(64);
        switch (b[0] / 40) {
            case 0: {
                sb.append('0');
                break;
            }
            case 1: {
                sb.append('1');
                b[0] = (byte)(b[0] - 40);
                break;
            }
            default: {
                sb.append('2');
                b[0] = (byte)(b[0] - 80);
            }
        }
        for (int i = 0; i < len; ++i) {
            value = value << 7 + b[i] & 0x7FL;
            if ((b[i] & 0x80) != 0) continue;
            sb.append('.');
            sb.append(value);
            value = 0L;
        }
        return sb.toString();
    }

    public byte[] readOctetString() {
        int type = this.readByte() & 0xFF;
        if (type != 4 && type != 3) {
            throw new IllegalArgumentException("Expected DER Octetstring, but found type " + type);
        }
        int len = this.readLength();
        if (len < 0 || len > this.available()) {
            throw new IllegalArgumentException("Illegal len in DER object (" + len + ")");
        }
        return this.readBytes(len);
    }
}

