/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.spring.starter.wxjava.miniapp.config.storage;

import cn.binarywang.wx.miniapp.config.impl.WxMaDefaultConfigImpl;
import com.binarywang.spring.starter.wxjava.miniapp.properties.WxMaProperties;
import me.chanjar.weixin.common.util.http.apache.ApacheHttpClientBuilder;
import me.chanjar.weixin.common.util.http.apache.DefaultApacheHttpClientBuilder;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractWxMaConfigStorageConfiguration {
    protected WxMaDefaultConfigImpl config(WxMaDefaultConfigImpl config, WxMaProperties properties) {
        int retrySleepMillis;
        ApacheHttpClientBuilder clientBuilder;
        WxMaProperties.ConfigStorage storage = properties.getConfigStorage();
        config.setAppid(StringUtils.trimToNull((String)properties.getAppid()));
        config.setSecret(StringUtils.trimToNull((String)properties.getSecret()));
        config.setToken(StringUtils.trimToNull((String)properties.getToken()));
        config.setAesKey(StringUtils.trimToNull((String)properties.getAesKey()));
        config.setMsgDataFormat(StringUtils.trimToNull((String)properties.getMsgDataFormat()));
        config.useStableAccessToken(properties.isUseStableAccessToken());
        config.setApiHostUrl(StringUtils.trimToNull((String)properties.getApiHostUrl()));
        config.setAccessTokenUrl(StringUtils.trimToNull((String)properties.getAccessTokenUrl()));
        WxMaProperties.ConfigStorage configStorageProperties = properties.getConfigStorage();
        config.setHttpProxyHost(configStorageProperties.getHttpProxyHost());
        config.setHttpProxyUsername(configStorageProperties.getHttpProxyUsername());
        config.setHttpProxyPassword(configStorageProperties.getHttpProxyPassword());
        if (configStorageProperties.getHttpProxyPort() != null) {
            config.setHttpProxyPort(configStorageProperties.getHttpProxyPort().intValue());
        }
        if ((clientBuilder = config.getApacheHttpClientBuilder()) == null) {
            clientBuilder = DefaultApacheHttpClientBuilder.get();
        }
        if (clientBuilder instanceof DefaultApacheHttpClientBuilder) {
            DefaultApacheHttpClientBuilder defaultBuilder = (DefaultApacheHttpClientBuilder)clientBuilder;
            defaultBuilder.setConnectionTimeout(storage.getConnectionTimeout());
            defaultBuilder.setSoTimeout(storage.getSoTimeout());
            defaultBuilder.setConnectionRequestTimeout(storage.getConnectionRequestTimeout());
            config.setApacheHttpClientBuilder((ApacheHttpClientBuilder)defaultBuilder);
        }
        int maxRetryTimes = configStorageProperties.getMaxRetryTimes();
        if (configStorageProperties.getMaxRetryTimes() < 0) {
            maxRetryTimes = 0;
        }
        if ((retrySleepMillis = configStorageProperties.getRetrySleepMillis()) < 0) {
            retrySleepMillis = 1000;
        }
        config.setRetrySleepMillis(retrySleepMillis);
        config.setMaxRetryTimes(maxRetryTimes);
        return config;
    }
}

