/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.open.executor;

import java.io.File;
import java.io.IOException;
import jodd.http.HttpConnectionProvider;
import jodd.http.ProxyInfo;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.ResponseHandler;
import me.chanjar.weixin.common.util.http.okhttp.OkHttpProxyInfo;
import me.chanjar.weixin.open.bean.ma.WxMaQrcodeParam;
import me.chanjar.weixin.open.executor.MaQrCodeApacheHttpRequestExecutor;
import me.chanjar.weixin.open.executor.MaQrCodeHttpComponentsRequestExecutor;
import me.chanjar.weixin.open.executor.MaQrCodeJoddHttpRequestExecutor;
import me.chanjar.weixin.open.executor.MaQrCodeOkhttpRequestExecutor;
import okhttp3.OkHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.http.HttpHost;

public abstract class MaQrCodeRequestExecutor<H, P>
implements RequestExecutor<File, WxMaQrcodeParam> {
    protected RequestHttp<H, P> requestHttp;

    public MaQrCodeRequestExecutor(RequestHttp<H, P> requestHttp) {
        this.requestHttp = requestHttp;
    }

    public void execute(String uri, WxMaQrcodeParam data, ResponseHandler<File> handler, WxType wxType) throws WxErrorException, IOException {
        handler.handle(this.execute(uri, data, wxType));
    }

    public static RequestExecutor<File, WxMaQrcodeParam> create(RequestHttp<?, ?> requestHttp) {
        switch (requestHttp.getRequestType()) {
            case APACHE_HTTP: {
                return new MaQrCodeApacheHttpRequestExecutor((RequestHttp<org.apache.http.impl.client.CloseableHttpClient, HttpHost>)requestHttp);
            }
            case JODD_HTTP: {
                return new MaQrCodeJoddHttpRequestExecutor((RequestHttp<HttpConnectionProvider, ProxyInfo>)requestHttp);
            }
            case OK_HTTP: {
                return new MaQrCodeOkhttpRequestExecutor((RequestHttp<OkHttpClient, OkHttpProxyInfo>)requestHttp);
            }
            case HTTP_COMPONENTS: {
                return new MaQrCodeHttpComponentsRequestExecutor((RequestHttp<CloseableHttpClient, org.apache.hc.core5.http.HttpHost>)requestHttp);
            }
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684http\u6267\u884c\u5668\u7c7b\u578b\uff1a" + requestHttp.getRequestType());
    }
}

