/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.open.executor;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import jodd.http.HttpConnectionProvider;
import jodd.http.HttpRequest;
import jodd.http.HttpResponse;
import jodd.http.ProxyInfo;
import jodd.http.upload.Uploadable;
import me.chanjar.weixin.common.bean.CommonUploadData;
import me.chanjar.weixin.common.bean.CommonUploadParam;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.open.bean.CommonUploadMultiParam;
import me.chanjar.weixin.open.executor.CommonUploadMultiRequestExecutor;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.content.StringBody;
import org.springframework.util.CollectionUtils;

public class CommonUploadMultiRequestExecutorJoddHttpImpl
extends CommonUploadMultiRequestExecutor<HttpConnectionProvider, ProxyInfo> {
    public CommonUploadMultiRequestExecutorJoddHttpImpl(RequestHttp<HttpConnectionProvider, ProxyInfo> requestHttp) {
        super(requestHttp);
    }

    public String execute(String uri, CommonUploadMultiParam param, WxType wxType) throws WxErrorException, IOException {
        CommonUploadParam uploadParam;
        HttpRequest request = HttpRequest.post((String)uri);
        if (this.requestHttp.getRequestHttpProxy() != null) {
            ((HttpConnectionProvider)this.requestHttp.getRequestHttpClient()).useProxy((ProxyInfo)this.requestHttp.getRequestHttpProxy());
        }
        request.withConnectionProvider((HttpConnectionProvider)this.requestHttp.getRequestHttpClient());
        List<CommonUploadMultiParam.NormalParam> normalParams = param.getNormalParams();
        if (!CollectionUtils.isEmpty(normalParams)) {
            for (CommonUploadMultiParam.NormalParam normalParam : normalParams) {
                request.form(normalParam.getName(), (Object)new StringBody(normalParam.getValue(), ContentType.MULTIPART_FORM_DATA.withCharset(StandardCharsets.UTF_8)));
            }
        }
        if ((uploadParam = param.getUploadParam()) != null) {
            request.form(uploadParam.getName(), (Object)new CommonUploadParamToUploadableAdapter(uploadParam.getData()));
        }
        HttpResponse response = request.send();
        response.charset(StandardCharsets.UTF_8.name());
        String responseContent = response.bodyText();
        if (responseContent.isEmpty()) {
            throw new WxErrorException(String.format("\u4e0a\u4f20\u5931\u8d25\uff0c\u670d\u52a1\u5668\u54cd\u5e94\u7a7a url:%s param:%s", uri, param));
        }
        WxError error = WxError.fromJson((String)responseContent, (WxType)wxType);
        if (error.getErrorCode() != 0) {
            throw new WxErrorException(error);
        }
        return responseContent;
    }

    public static class CommonUploadParamToUploadableAdapter
    implements Uploadable<CommonUploadData> {
        private CommonUploadData content;

        public byte[] getBytes() {
            return this.content.readAllBytes();
        }

        public String getFileName() {
            return this.content.getFileName();
        }

        public String getMimeType() {
            return null;
        }

        public int getSize() {
            return (int)this.content.getLength();
        }

        public InputStream openInputStream() {
            return this.content.getInputStream();
        }

        public CommonUploadData getContent() {
            return this.content;
        }

        public CommonUploadParamToUploadableAdapter(CommonUploadData content) {
            this.content = content;
        }
    }
}

