/*
 * Decompiled with CFR 0.152.
 */
package com.getui.push.v2.sdk.core.handler.impl;

import com.getui.push.v2.sdk.GtApiConfiguration;
import com.getui.push.v2.sdk.common.ApiException;
import com.getui.push.v2.sdk.common.Monitor;
import com.getui.push.v2.sdk.core.factory.GtApiProxyFactory;
import com.getui.push.v2.sdk.core.handler.GtInterceptor;
import com.getui.push.v2.sdk.core.manager.HostManager;
import com.getui.push.v2.sdk.core.status.ServiceState;
import com.getui.push.v2.sdk.core.status.StateWrapper;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGtInterceptor
implements GtInterceptor {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private static final ThreadLocal<Long> START_TIME = new ThreadLocal();
    private final ConcurrentMap<String, StateWrapper> stateWrapperMap = new ConcurrentHashMap<String, StateWrapper>();
    private final AtomicInteger failNum = new AtomicInteger(0);
    private final HostManager hostManager;
    private final BlockingQueue<StateWrapper> reportDataQueue;
    private final GtApiConfiguration configuration;
    final Lock switchLock = new ReentrantLock();

    public DefaultGtInterceptor(HostManager hostManager, BlockingQueue<StateWrapper> reportDataQueue, GtApiConfiguration configuration) {
        this.hostManager = hostManager;
        this.reportDataQueue = reportDataQueue;
        this.configuration = configuration;
        if (configuration.isOpenAnalyseStableDomainSwitch()) {
            Monitor.init(configuration.getCheckMaxFailedNumInterval());
        }
    }

    @Override
    public void pre(GtApiProxyFactory.ApiParam apiParam, Map<String, Object> header, String body) {
        START_TIME.set(System.currentTimeMillis());
    }

    @Override
    public void post(GtApiProxyFactory.ApiParam apiParam, Map<String, Object> header, String body, String result) {
        this.log.debug("success. param: {}, result: {}.", (Object)apiParam, (Object)result);
        this.failNum.set(0);
    }

    @Override
    public void handleException(String host, GtApiProxyFactory.ApiParam apiParam, Map<String, Object> header, String body, ApiException e) {
        int num;
        this.log.error("http error. param: {}, body: {}.", new Object[]{apiParam, body, e});
        if (this.configuration.isOpenCheckHealthDataSwitch()) {
            ServiceState serviceState = this.get(this.hostManager.getUsing()).get(apiParam.getUri());
            serviceState.incrFailedTimes();
        }
        if ((num = this.failNum.incrementAndGet()) > this.configuration.getContinuousFailedNum()) {
            this.resetAndSwitchHost(host, "continuous", num);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterCompletion(String host, GtApiProxyFactory.ApiParam apiParam, Map<String, Object> header, String body, String result) {
        try {
            long failedTotal;
            if (this.configuration.isOpenCheckHealthDataSwitch()) {
                long cost = System.currentTimeMillis() - START_TIME.get();
                ServiceState serviceState = this.get(host).get(apiParam.getUri());
                serviceState.addCallTime(cost);
                serviceState.incrCallTimes();
            }
            if ((failedTotal = (long)Monitor.get(host)) > (long)this.configuration.getMaxFailedNum()) {
                this.resetAndSwitchHost(host, "total", failedTotal);
            }
        }
        finally {
            START_TIME.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetAndSwitchHost(String host, String reason, long failedNum) {
        boolean locked = this.switchLock.tryLock();
        if (!locked) {
            return;
        }
        try {
            Monitor.reset(host);
            this.failNum.set(0);
            if (this.configuration.isOpenCheckHealthDataSwitch()) {
                this.reportDataQueue.offer(this.getAndRemove(host));
            }
            if (this.configuration.isOpenAnalyseStableDomainSwitch()) {
                this.log.debug("The number of failures has reached the threshold, will switch host. reason:{}, failedNum:{}", (Object)reason, (Object)failedNum);
                this.hostManager.switchHost(host);
            }
        }
        finally {
            this.switchLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StateWrapper get(String host) {
        StateWrapper stateWrapper = (StateWrapper)this.stateWrapperMap.get(host);
        if (stateWrapper != null) {
            return stateWrapper;
        }
        ConcurrentMap<String, StateWrapper> concurrentMap = this.stateWrapperMap;
        synchronized (concurrentMap) {
            stateWrapper = (StateWrapper)this.stateWrapperMap.get(host);
            if (stateWrapper != null) {
                return stateWrapper;
            }
            stateWrapper = new StateWrapper(host);
            this.stateWrapperMap.put(host, stateWrapper);
            return stateWrapper;
        }
    }

    public StateWrapper getAndRemove(String host) {
        return (StateWrapper)this.stateWrapperMap.remove(host);
    }
}

