/*
 * Decompiled with CFR 0.152.
 */
package com.getui.push.v2.sdk.core.domain;

import com.getui.push.v2.sdk.common.util.Utils;
import com.getui.push.v2.sdk.core.domain.DomainListBO;
import com.getui.push.v2.sdk.core.domain.IDomainCheck;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DomainCheck {
    private IDomainCheck check;
    private final int checkSize;

    public DomainCheck(IDomainCheck check) {
        this(check, 20);
    }

    public DomainCheck(IDomainCheck check, int checkSize) {
        this.check = check;
        this.checkSize = checkSize;
    }

    public List<String> sort(List<DomainListBO> list) {
        Map<String, Integer> domainTOGapMap = this.initGap(list);
        List<String> domainList = this.getALlDomain(list);
        Map<String, Integer> map = this.doCheck(domainList, domainTOGapMap);
        return this.doSort(map);
    }

    private List<String> getALlDomain(List<DomainListBO> list) {
        ArrayList<String> domainList = new ArrayList<String>();
        for (DomainListBO domainListBO : list) {
            if (!Utils.isNotEmpty(domainListBO.getDomainList())) continue;
            domainList.addAll(domainListBO.getDomainList());
        }
        return domainList;
    }

    private Map<String, Integer> doCheck(List<String> domainList, Map<String, Integer> domainToGapMap) {
        HashMap<String, Integer> detectMap = new HashMap<String, Integer>(domainList.size(), 1.0f);
        for (int i = 0; i < this.checkSize; ++i) {
            for (String string : domainList) {
                if (detectMap.get(string) == null) {
                    detectMap.put(string, 0);
                }
                boolean rst = false;
                try {
                    rst = this.check.check(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!rst) continue;
                detectMap.put(string, (Integer)detectMap.get(string) + 1);
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        boolean allBad = true;
        for (Map.Entry entry : detectMap.entrySet()) {
            if ((Integer)entry.getValue() != 0) {
                allBad = false;
            }
            String key = (String)entry.getKey();
            int score = (Integer)entry.getValue() * 100 / this.checkSize + domainToGapMap.get(key);
            detectMap.put(key, score);
        }
        if (allBad) {
            return Collections.emptyMap();
        }
        return detectMap;
    }

    private List<String> doSort(Map<String, Integer> detectMap) {
        ArrayList<String> result = new ArrayList<String>();
        if (detectMap == null || detectMap.size() == 0) {
            return null;
        }
        String domain = null;
        Integer max = 0;
        while (detectMap.size() != 0) {
            for (Map.Entry<String, Integer> entry : detectMap.entrySet()) {
                if (entry.getValue() < max) continue;
                max = entry.getValue();
                domain = entry.getKey();
            }
            max = 0;
            result.add(domain);
            detectMap.remove(domain);
        }
        return result;
    }

    private Map<String, Integer> initGap(List<DomainListBO> list) {
        HashMap<String, Integer> map = new HashMap<String, Integer>(list.size(), 1.0f);
        int gap = 0;
        for (int i = list.size() - 1; i >= 0; --i) {
            if (i != list.size() - 1) {
                gap += list.get(i).getPriorityGap().intValue();
            }
            for (String t : list.get(i).getDomainList()) {
                map.put(t, gap);
            }
        }
        return map;
    }
}

