/*
 * Decompiled with CFR 0.152.
 */
package com.getui.push.v2.sdk.core;

import com.getui.push.v2.sdk.IJson;
import com.getui.push.v2.sdk.dto.res.statistic.StatisticDTO;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.text.NumberFormat;
import java.util.List;
import java.util.Map;

public class DefaultJson
implements IJson {
    private static final Gson GSON = DefaultJson.createGson();

    public static Gson createGson() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES);
        gsonBuilder.registerTypeAdapter(StatisticDTO.class, (Object)new JsonDeserializer<StatisticDTO>(){

            public StatisticDTO deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                StatisticDTO statisticDTO = new StatisticDTO();
                JsonObject jo = json.getAsJsonObject();
                for (Map.Entry mx : jo.entrySet()) {
                    String key = (String)mx.getKey();
                    JsonElement v = (JsonElement)mx.getValue();
                    if (v.isJsonArray()) {
                        statisticDTO.put(key, context.deserialize(v, List.class));
                        continue;
                    }
                    if (v.isJsonPrimitive()) {
                        Object value = v.getAsString();
                        try {
                            Number numValue = NumberFormat.getInstance().parse((String)value);
                            if (numValue != null && numValue.toString().equals(value)) {
                                value = numValue instanceof Long && (Long)numValue <= Integer.MAX_VALUE && (Long)numValue >= Integer.MIN_VALUE ? (Number)Integer.valueOf((String)value) : (Number)numValue;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        statisticDTO.put(key, value);
                        continue;
                    }
                    if (!v.isJsonObject()) continue;
                    statisticDTO.put(key, context.deserialize(v, Map.class));
                }
                return statisticDTO;
            }
        });
        return gsonBuilder.create();
    }

    @Override
    public String toJson(Object obj) {
        if (obj == null) {
            return null;
        }
        return GSON.toJson(obj);
    }

    @Override
    public <T> T fromJson(String jsonString, Type type) {
        return (T)GSON.fromJson(jsonString, type);
    }

    @Override
    public <T> T fromJson(String jsonString, Class<T> tClass) {
        return (T)GSON.fromJson(jsonString, tClass);
    }
}

