/*
 * Decompiled with CFR 0.152.
 */
package com.getui.push.v2.sdk.core.manager;

import com.getui.push.v2.sdk.GtApiConfiguration;
import com.getui.push.v2.sdk.common.http.HttpManager;
import com.getui.push.v2.sdk.common.util.Utils;
import com.getui.push.v2.sdk.core.Configs;
import com.getui.push.v2.sdk.core.domain.DomainCheck;
import com.getui.push.v2.sdk.core.domain.DomainListBO;
import com.getui.push.v2.sdk.core.domain.IDomainCheck;
import com.getui.push.v2.sdk.core.domain.RasDomainBO;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final HttpManager httpManager;
    private final GtApiConfiguration configuration;
    private String using;
    private final Lock switchUsingLock = new ReentrantLock();
    private RasDomainBO rasDomain;
    private final Object setRasDomainLock = new Object();
    private List<String> sortedDomains;
    private BlockingQueue<String> sortedHostQueue;
    private final AtomicInteger switchIncr = new AtomicInteger(0);
    private final AtomicInteger switchTotal = new AtomicInteger(0);

    public HostManager(GtApiConfiguration configuration, HttpManager httpManager) {
        this.configuration = configuration;
        this.using = configuration.getDomain();
        this.httpManager = httpManager;
    }

    public String getUsing() {
        return this.using;
    }

    public void handleDomain(RasDomainBO domainBO) {
        if (domainBO == null || Utils.isEmpty(domainBO.getHostList())) {
            return;
        }
        if (this.setRasDomainBO(domainBO)) {
            if (!Utils.isEmpty(this.sortedDomains)) {
                this.sortedDomains.clear();
            }
            this.resetHostQueue();
            this.switchTo(domainBO.getHostList().get(0).getDomainList().get(0));
        }
    }

    public void switchTo(String willUse) {
        if (Utils.isNotEmpty(willUse) && willUse.equals(this.using)) {
            return;
        }
        this.logger.debug("switch host. old: {}, new: {}.", (Object)this.using, (Object)willUse);
        this.switchIncr.incrementAndGet();
        this.switchTotal.incrementAndGet();
        this.using = willUse;
    }

    public void switchHost() {
        if (Utils.isEmpty(this.sortedHostQueue)) {
            this.resetHostQueue();
        }
        if (!this.switchUsingLock.tryLock()) {
            return;
        }
        try {
            String host = (String)this.sortedHostQueue.poll();
            if (Utils.isNotEmpty(host)) {
                this.switchTo(host);
            } else {
                this.logger.debug("switchHost. hostQueue.poll() return null. host: {}.", (Object)host);
                this.switchTo(this.configuration.getDomain());
            }
        }
        finally {
            this.switchUsingLock.unlock();
        }
    }

    private synchronized void resetHostQueue() {
        if (Utils.isNotEmpty(this.sortedHostQueue)) {
            return;
        }
        this.resetHostQueueHard();
    }

    private void resetHostQueueHard() {
        RasDomainBO rasDomain = this.rasDomain;
        LinkedBlockingDeque<String> queue = new LinkedBlockingDeque<String>();
        if (Utils.isEmpty(this.sortedDomains)) {
            if (rasDomain != null && Utils.isNotEmpty(rasDomain.getHostList())) {
                for (DomainListBO domainListBO : rasDomain.getHostList()) {
                    if (!Utils.isNotEmpty(domainListBO.getDomainList())) continue;
                    queue.addAll(domainListBO.getDomainList());
                }
            }
        } else {
            queue.addAll(this.sortedDomains);
        }
        if (Utils.isNotEmpty(this.configuration.getDomain())) {
            queue.add(this.configuration.getDomain());
        }
        if (Utils.isNotEmpty(Configs.URLS)) {
            queue.addAll(Configs.URLS);
        }
        this.sortedHostQueue = queue;
    }

    public RasDomainBO getRasDomain() {
        return this.rasDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setRasDomainBO(RasDomainBO rasDomainBO) {
        if (rasDomainBO == null || Utils.isEmpty(rasDomainBO.getHostList()) || Utils.isEmpty(rasDomainBO.getDomainHash())) {
            return false;
        }
        if (this.rasDomain != null && rasDomainBO.getDomainHash().equalsIgnoreCase(this.rasDomain.getDomainHash())) {
            return false;
        }
        Object object = this.setRasDomainLock;
        synchronized (object) {
            if (this.rasDomain != null && rasDomainBO.getDomainHash().equalsIgnoreCase(this.rasDomain.getDomainHash())) {
                return false;
            }
            this.rasDomain = rasDomainBO;
            return true;
        }
    }

    public BlockingQueue<String> getSortedHostQueue() {
        return this.sortedHostQueue;
    }

    public void setSortedHostQueue(BlockingQueue<String> sortedHostQueue) {
        this.sortedHostQueue = sortedHostQueue;
    }

    public String domainHash() {
        return this.rasDomain == null ? null : this.rasDomain.getDomainHash();
    }

    public void analyseStableDomain() {
        if (this.rasDomain == null || Utils.isEmpty(this.rasDomain.getHostList())) {
            this.logger.debug("Analysing stopped because the hostList is empty.");
            return;
        }
        List<String> sortedHost = new DomainCheck(new IDomainCheck(){

            @Override
            public boolean check(final String url) {
                FutureTask task = new FutureTask(new Callable(){

                    public Object call() throws Exception {
                        HostManager.this.httpManager.syncHttps(url + "/v2/check", "head", null, null, null);
                        return true;
                    }
                });
                new Thread(task).start();
                try {
                    return (Boolean)task.get(1L, TimeUnit.SECONDS);
                }
                catch (TimeoutException e) {
                    task.cancel(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
        }).sort(this.rasDomain.getHostList());
        if (Utils.isNotEmpty(sortedHost)) {
            this.sortedDomains = sortedHost;
        }
        this.logger.debug("analyseStableDomain finished. result: {}.", sortedHost);
        this.resetHostQueueHard();
        this.switchHost();
    }

    public int getSwitchIncrNum() {
        return this.switchIncr.getAndSet(0);
    }

    public int getSwitchTotalNum() {
        return this.switchTotal.get();
    }
}

