/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import com.ceilfors.enforcer.rules.EnforcerRuleUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugins.enforcer.AbstractStandardEnforcerRule;
import org.apache.maven.project.MavenProject;

public class MatchArtifactIdAndBaseDir
extends AbstractStandardEnforcerRule {
    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        String artifactId;
        MavenProject mavenProject = EnforcerRuleUtils.getMavenProject(helper);
        String baseDir = mavenProject.getBasedir().getName();
        String difference = StringUtils.difference((String)baseDir, (String)(artifactId = mavenProject.getArtifactId()));
        if (!difference.isEmpty()) {
            String template = "Artifact id: [%s] is not the same with base dir: [%s]. Difference is started at: [%s]";
            throw new EnforcerRuleException(String.format(template, artifactId, baseDir, difference));
        }
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule enforcerRule) {
        return false;
    }

    public String getCacheId() {
        return "0";
    }
}

