/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractFloatCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.ArraySizingStrategy;
import com.carrotsearch.hppc.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppc.FloatContainer;
import com.carrotsearch.hppc.FloatDeque;
import com.carrotsearch.hppc.Internals;
import com.carrotsearch.hppc.cursors.FloatCursor;
import com.carrotsearch.hppc.predicates.FloatPredicate;
import com.carrotsearch.hppc.procedures.FloatProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class FloatArrayDeque
extends AbstractFloatCollection
implements FloatDeque,
Cloneable {
    public static final int DEFAULT_CAPACITY = 5;
    public float[] buffer;
    public int head;
    public int tail;
    protected final ArraySizingStrategy resizer;

    public FloatArrayDeque() {
        this(5);
    }

    public FloatArrayDeque(int initialCapacity) {
        this(initialCapacity, new BoundedProportionalArraySizingStrategy());
    }

    public FloatArrayDeque(int initialCapacity, ArraySizingStrategy resizer) {
        assert (initialCapacity >= 0) : "initialCapacity must be >= 0: " + initialCapacity;
        assert (resizer != null);
        this.resizer = resizer;
        initialCapacity = resizer.round(initialCapacity);
        this.buffer = new float[initialCapacity];
    }

    public FloatArrayDeque(FloatContainer container) {
        this(container.size());
        this.addLast(container);
    }

    @Override
    public void addFirst(float e1) {
        int h = FloatArrayDeque.oneLeft(this.head, this.buffer.length);
        if (h == this.tail) {
            this.ensureBufferSpace(1);
            h = FloatArrayDeque.oneLeft(this.head, this.buffer.length);
        }
        this.head = h;
        this.buffer[this.head] = e1;
    }

    public void addFirst(float ... elements) {
        this.ensureBufferSpace(elements.length);
        for (int i = 0; i < elements.length; ++i) {
            this.addFirst(elements[i]);
        }
    }

    public int addFirst(FloatContainer container) {
        int size = container.size();
        this.ensureBufferSpace(size);
        for (FloatCursor cursor : container) {
            this.addFirst(cursor.value);
        }
        return size;
    }

    public int addFirst(Iterable<? extends FloatCursor> iterable) {
        int size = 0;
        for (FloatCursor floatCursor : iterable) {
            this.addFirst(floatCursor.value);
            ++size;
        }
        return size;
    }

    @Override
    public void addLast(float e1) {
        int t = FloatArrayDeque.oneRight(this.tail, this.buffer.length);
        if (this.head == t) {
            this.ensureBufferSpace(1);
            t = FloatArrayDeque.oneRight(this.tail, this.buffer.length);
        }
        this.buffer[this.tail] = e1;
        this.tail = t;
    }

    public void addLast(float ... elements) {
        this.ensureBufferSpace(1);
        for (int i = 0; i < elements.length; ++i) {
            this.addLast(elements[i]);
        }
    }

    public int addLast(FloatContainer container) {
        int size = container.size();
        this.ensureBufferSpace(size);
        for (FloatCursor cursor : container) {
            this.addLast(cursor.value);
        }
        return size;
    }

    public int addLast(Iterable<? extends FloatCursor> iterable) {
        int size = 0;
        for (FloatCursor floatCursor : iterable) {
            this.addLast(floatCursor.value);
            ++size;
        }
        return size;
    }

    @Override
    public float removeFirst() {
        assert (this.size() > 0) : "The deque is empty.";
        float result = this.buffer[this.head];
        this.buffer[this.head] = 0.0f;
        this.head = FloatArrayDeque.oneRight(this.head, this.buffer.length);
        return result;
    }

    @Override
    public float removeLast() {
        assert (this.size() > 0) : "The deque is empty.";
        this.tail = FloatArrayDeque.oneLeft(this.tail, this.buffer.length);
        float result = this.buffer[this.tail];
        this.buffer[this.tail] = 0.0f;
        return result;
    }

    @Override
    public float getFirst() {
        assert (this.size() > 0) : "The deque is empty.";
        return this.buffer[this.head];
    }

    @Override
    public float getLast() {
        assert (this.size() > 0) : "The deque is empty.";
        return this.buffer[FloatArrayDeque.oneLeft(this.tail, this.buffer.length)];
    }

    @Override
    public int removeFirstOccurrence(float e1) {
        int index = this.bufferIndexOf(e1);
        if (index >= 0) {
            this.removeAtBufferIndex(index);
        }
        return index;
    }

    public int bufferIndexOf(float e1) {
        int last = this.tail;
        int bufLen = this.buffer.length;
        int i = this.head;
        while (i != last) {
            if (Float.floatToIntBits(e1) == Float.floatToIntBits(this.buffer[i])) {
                return i;
            }
            i = FloatArrayDeque.oneRight(i, bufLen);
        }
        return -1;
    }

    @Override
    public int removeLastOccurrence(float e1) {
        int index = this.lastBufferIndexOf(e1);
        if (index >= 0) {
            this.removeAtBufferIndex(index);
        }
        return index;
    }

    public int lastBufferIndexOf(float e1) {
        int bufLen = this.buffer.length;
        int last = FloatArrayDeque.oneLeft(this.head, bufLen);
        int i = FloatArrayDeque.oneLeft(this.tail, bufLen);
        while (i != last) {
            if (Float.floatToIntBits(e1) == Float.floatToIntBits(this.buffer[i])) {
                return i;
            }
            i = FloatArrayDeque.oneLeft(i, bufLen);
        }
        return -1;
    }

    @Override
    public int removeAllOccurrences(float e1) {
        int to;
        int removed = 0;
        int last = this.tail;
        int bufLen = this.buffer.length;
        int from = to = this.head;
        while (from != last) {
            if (Float.floatToIntBits(e1) == Float.floatToIntBits(this.buffer[from])) {
                this.buffer[from] = 0.0f;
                ++removed;
            } else {
                if (to != from) {
                    this.buffer[to] = this.buffer[from];
                    this.buffer[from] = 0.0f;
                }
                to = FloatArrayDeque.oneRight(to, bufLen);
            }
            from = FloatArrayDeque.oneRight(from, bufLen);
        }
        this.tail = to;
        return removed;
    }

    public void removeAtBufferIndex(int index) {
        int rightChunk;
        assert (this.head > this.tail ? index >= this.head || index < this.tail : index >= this.head && index < this.tail) : "Index out of range (head=" + this.head + ", tail=" + this.tail + ", index=" + index + ").";
        float[] b = this.buffer;
        int bufLen = b.length;
        int lastIndex = bufLen - 1;
        int head = this.head;
        int tail = this.tail;
        int leftChunk = Math.abs(index - head) % bufLen;
        if (leftChunk < (rightChunk = Math.abs(tail - index) % bufLen)) {
            if (index >= head) {
                System.arraycopy(b, head, b, head + 1, leftChunk);
            } else {
                System.arraycopy(b, 0, b, 1, index);
                b[0] = b[lastIndex];
                System.arraycopy(b, head, b, head + 1, lastIndex - head);
            }
            b[head] = 0.0f;
            this.head = FloatArrayDeque.oneRight(head, bufLen);
        } else {
            if (index < tail) {
                System.arraycopy(b, index + 1, b, index, rightChunk);
            } else {
                System.arraycopy(b, index + 1, b, index, lastIndex - index);
                b[lastIndex] = b[0];
                System.arraycopy(b, 1, b, 0, tail);
            }
            b[tail] = 0.0f;
            this.tail = FloatArrayDeque.oneLeft(tail, bufLen);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        if (this.head <= this.tail) {
            return this.tail - this.head;
        }
        return this.tail - this.head + this.buffer.length;
    }

    @Override
    public void clear() {
        if (this.head < this.tail) {
            Arrays.fill(this.buffer, this.head, this.tail, 0.0f);
        } else {
            Arrays.fill(this.buffer, 0, this.tail, 0.0f);
            Arrays.fill(this.buffer, this.head, this.buffer.length, 0.0f);
        }
        this.tail = 0;
        this.head = 0;
    }

    public void release() {
        this.tail = 0;
        this.head = 0;
        this.buffer = new float[this.resizer.round(5)];
    }

    protected void ensureBufferSpace(int expectedAdditions) {
        int bufferLen = this.buffer == null ? 0 : this.buffer.length;
        int elementsCount = this.size();
        if (elementsCount >= bufferLen - expectedAdditions - 1) {
            int newSize = this.resizer.grow(bufferLen, elementsCount, expectedAdditions + 1);
            assert (newSize >= elementsCount + expectedAdditions + 1) : "Resizer failed to return sensible new size: " + newSize + " <= " + (elementsCount + expectedAdditions);
            float[] newBuffer = new float[newSize];
            if (bufferLen > 0) {
                this.toArray(newBuffer);
                this.tail = elementsCount;
                this.head = 0;
            }
            this.buffer = newBuffer;
        }
    }

    @Override
    public float[] toArray() {
        int size = this.size();
        return this.toArray(new float[size]);
    }

    public float[] toArray(float[] target) {
        assert (target.length >= this.size()) : "Target array must be >= " + this.size();
        if (this.head < this.tail) {
            System.arraycopy(this.buffer, this.head, target, 0, this.size());
        } else if (this.head > this.tail) {
            int rightCount = this.buffer.length - this.head;
            System.arraycopy(this.buffer, this.head, target, 0, rightCount);
            System.arraycopy(this.buffer, 0, target, rightCount, this.tail);
        }
        return target;
    }

    public FloatArrayDeque clone() {
        try {
            FloatArrayDeque cloned = (FloatArrayDeque)super.clone();
            cloned.buffer = (float[])this.buffer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    protected static int oneLeft(int index, int modulus) {
        if (index >= 1) {
            return index - 1;
        }
        return modulus - 1;
    }

    protected static int oneRight(int index, int modulus) {
        if (index + 1 == modulus) {
            return 0;
        }
        return index + 1;
    }

    @Override
    public Iterator<FloatCursor> iterator() {
        return new ValueIterator();
    }

    @Override
    public Iterator<FloatCursor> descendingIterator() {
        return new DescendingValueIterator();
    }

    @Override
    public <T extends FloatProcedure> T forEach(T procedure) {
        this.forEach(procedure, this.head, this.tail);
        return procedure;
    }

    private void forEach(FloatProcedure procedure, int fromIndex, int toIndex) {
        float[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex) {
            procedure.apply(buffer[i]);
            i = FloatArrayDeque.oneRight(i, buffer.length);
        }
    }

    @Override
    public <T extends FloatPredicate> T forEach(T predicate) {
        int fromIndex = this.head;
        int toIndex = this.tail;
        float[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex && predicate.apply(buffer[i])) {
            i = FloatArrayDeque.oneRight(i, buffer.length);
        }
        return predicate;
    }

    @Override
    public <T extends FloatProcedure> T descendingForEach(T procedure) {
        this.descendingForEach(procedure, this.head, this.tail);
        return procedure;
    }

    private void descendingForEach(FloatProcedure procedure, int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        float[] buffer = this.buffer;
        int i = toIndex;
        do {
            i = FloatArrayDeque.oneLeft(i, buffer.length);
            procedure.apply(buffer[i]);
        } while (i != fromIndex);
    }

    @Override
    public <T extends FloatPredicate> T descendingForEach(T predicate) {
        this.descendingForEach(predicate, this.head, this.tail);
        return predicate;
    }

    private void descendingForEach(FloatPredicate predicate, int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        float[] buffer = this.buffer;
        int i = toIndex;
        while (predicate.apply(buffer[i = FloatArrayDeque.oneLeft(i, buffer.length)]) && i != fromIndex) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(FloatPredicate predicate) {
        int to;
        int removed = 0;
        int last = this.tail;
        int bufLen = this.buffer.length;
        int from = to = this.head;
        try {
            from = to = this.head;
            while (from != last) {
                if (predicate.apply(this.buffer[from])) {
                    this.buffer[from] = 0.0f;
                    ++removed;
                } else {
                    if (to != from) {
                        this.buffer[to] = this.buffer[from];
                        this.buffer[from] = 0.0f;
                    }
                    to = FloatArrayDeque.oneRight(to, bufLen);
                }
                from = FloatArrayDeque.oneRight(from, bufLen);
            }
        }
        finally {
            while (from != last) {
                if (to != from) {
                    this.buffer[to] = this.buffer[from];
                    this.buffer[from] = 0.0f;
                }
                to = FloatArrayDeque.oneRight(to, bufLen);
                from = FloatArrayDeque.oneRight(from, bufLen);
            }
            this.tail = to;
        }
        return removed;
    }

    @Override
    public boolean contains(float e) {
        int fromIndex = this.head;
        int toIndex = this.tail;
        float[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex) {
            if (Float.floatToIntBits(e) == Float.floatToIntBits(buffer[i])) {
                return true;
            }
            i = FloatArrayDeque.oneRight(i, buffer.length);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int h = 1;
        int fromIndex = this.head;
        int toIndex = this.tail;
        float[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex) {
            h = 31 * h + Internals.rehash(this.buffer[i]);
            i = FloatArrayDeque.oneRight(i, buffer.length);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        FloatDeque other;
        if (obj != null && obj instanceof FloatDeque && (other = (FloatDeque)obj).size() == this.size()) {
            int fromIndex = this.head;
            float[] buffer = this.buffer;
            int i = fromIndex;
            for (FloatCursor c : other) {
                if (Float.floatToIntBits(c.value) != Float.floatToIntBits(buffer[i])) {
                    return false;
                }
                i = FloatArrayDeque.oneRight(i, buffer.length);
            }
            return true;
        }
        return false;
    }

    public static FloatArrayDeque newInstance() {
        return new FloatArrayDeque();
    }

    public static FloatArrayDeque newInstanceWithCapacity(int initialCapacity) {
        return new FloatArrayDeque(initialCapacity);
    }

    public static FloatArrayDeque from(float ... elements) {
        FloatArrayDeque coll = new FloatArrayDeque(elements.length);
        coll.addLast(elements);
        return coll;
    }

    public static FloatArrayDeque from(FloatArrayDeque container) {
        return new FloatArrayDeque(container);
    }

    private final class DescendingValueIterator
    extends AbstractIterator<FloatCursor> {
        private final FloatCursor cursor = new FloatCursor();
        private int remaining;

        public DescendingValueIterator() {
            this.cursor.index = FloatArrayDeque.this.tail;
            this.remaining = FloatArrayDeque.this.size();
        }

        @Override
        protected FloatCursor fetch() {
            if (this.remaining == 0) {
                return (FloatCursor)this.done();
            }
            --this.remaining;
            this.cursor.index = FloatArrayDeque.oneLeft(this.cursor.index, FloatArrayDeque.this.buffer.length);
            this.cursor.value = FloatArrayDeque.this.buffer[this.cursor.index];
            return this.cursor;
        }
    }

    private final class ValueIterator
    extends AbstractIterator<FloatCursor> {
        private final FloatCursor cursor = new FloatCursor();
        private int remaining;

        public ValueIterator() {
            this.cursor.index = FloatArrayDeque.oneLeft(FloatArrayDeque.this.head, FloatArrayDeque.this.buffer.length);
            this.remaining = FloatArrayDeque.this.size();
        }

        @Override
        protected FloatCursor fetch() {
            if (this.remaining == 0) {
                return (FloatCursor)this.done();
            }
            --this.remaining;
            this.cursor.index = FloatArrayDeque.oneRight(this.cursor.index, FloatArrayDeque.this.buffer.length);
            this.cursor.value = FloatArrayDeque.this.buffer[this.cursor.index];
            return this.cursor;
        }
    }
}

