/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.template;

import bboss.org.apache.velocity.VelocityContext;
import bboss.org.apache.velocity.context.Context;
import bboss.org.apache.velocity.runtime.resource.Resource;
import com.frameworkset.util.ColumnEditorInf;
import com.frameworkset.util.ColumnToFieldEditor;
import com.frameworkset.util.ColumnType;
import com.frameworkset.util.DaemonThread;
import com.frameworkset.util.ResourceInitial;
import com.frameworkset.util.VariableHandler;
import com.frameworkset.velocity.BBossVelocityUtil;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.ElasticSearchHelper;
import org.frameworkset.elasticsearch.ElasticsearchParseException;
import org.frameworkset.elasticsearch.serial.CharEscapeUtil;
import org.frameworkset.elasticsearch.serial.SerialUtil;
import org.frameworkset.elasticsearch.template.ESInfo;
import org.frameworkset.elasticsearch.template.ESSOAFileApplicationContext;
import org.frameworkset.elasticsearch.template.ESTemplate;
import org.frameworkset.elasticsearch.template.ESTemplateCache;
import org.frameworkset.soa.BBossStringWriter;
import org.frameworkset.spi.BaseApplicationContext;
import org.frameworkset.spi.assemble.Pro;
import org.frameworkset.util.ClassUtil;
import org.frameworkset.util.annotations.DateFormateMeta;
import org.frameworkset.util.annotations.wraper.ColumnWraper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESUtil {
    protected BaseApplicationContext templatecontext;
    private static Logger log = LoggerFactory.getLogger(ESUtil.class);
    protected static Map<String, ESUtil> esutils = new HashMap<String, ESUtil>();
    protected static long refresh_interval = 5000L;
    protected ESTemplateCache templateCache = new ESTemplateCache();
    protected Map<String, ESInfo> esInfos;
    protected Map<String, ESRef> esrefs;
    protected boolean hasrefs;
    protected String templateFile;
    protected String realTemplateFile;
    private static DaemonThread damon = null;
    private static Object lock;

    public VariableHandler.URLStruction getTempateStruction(ESInfo esInfo, String template) {
        return this.templateCache.getTemplateStruction(esInfo, template);
    }

    public VelocityContext buildVelocityContext(Object bean) {
        VelocityContext context_ = new VelocityContext();
        ClassUtil.ClassInfo beanInfo = ClassUtil.getClassInfo(bean.getClass());
        String name = null;
        DateFormateMeta dataformat = null;
        Object value = null;
        List attributes = beanInfo.getPropertyDescriptors();
        for (int i = 0; attributes != null && i < attributes.size(); ++i) {
            ClassUtil.PropertieDescription property = (ClassUtil.PropertieDescription)attributes.get(i);
            ColumnWraper column = property.getColumn();
            if (column != null && (column.ignoreCUDbind() || column.ignorebind())) continue;
            try {
                if (property.canread()) {
                    try {
                        value = property.getValue(bean);
                    }
                    catch (InvocationTargetException e1) {
                        log.error("\u83b7\u53d6\u5c5e\u6027[" + beanInfo.getClazz().getName() + "." + property.getName() + "]\u503c\u5931\u8d25\uff1a", e1.getTargetException());
                    }
                    catch (Exception e1) {
                        log.error("\u83b7\u53d6\u5c5e\u6027[" + beanInfo.getClazz().getName() + "." + property.getName() + "]\u503c\u5931\u8d25\uff1a", (Throwable)e1);
                    }
                    name = property.getName();
                    if (column != null) {
                        ColumnEditorInf editor = column.editor();
                        if (editor == null || editor instanceof ColumnToFieldEditor) {
                            dataformat = column.getDateFormateMeta();
                        } else {
                            Object cv = editor.toColumnValue(column, value);
                            if (cv == null) {
                                throw new ElasticSearchException("\u8f6c\u6362\u5c5e\u6027[" + beanInfo.getClazz().getName() + "." + property.getName() + "]\u503c\u5931\u8d25\uff1a\u503c\u4e3anull\u65f6\uff0c\u8f6c\u6362\u5668\u5fc5\u987b\u8fd4\u56deColumnType\u7c7b\u578b\u7684\u5bf9\u8c61,\u7528\u6765\u6307\u793a\u8868\u5b57\u6bb5\u5bf9\u5e94\u7684java\u7c7b\u578b\u3002");
                            }
                            if (!(cv instanceof ColumnType)) {
                                value = cv;
                            }
                        }
                    }
                    context_.put(name, value);
                }
                name = null;
                value = null;
                dataformat = null;
                continue;
            }
            catch (SecurityException e) {
                throw new ElasticSearchException(e);
            }
            catch (IllegalArgumentException e) {
                throw new ElasticSearchException(e);
            }
            catch (Exception e) {
                throw new ElasticSearchException(e);
            }
        }
        return context_;
    }

    public VelocityContext buildVelocityContext(Map data) {
        VelocityContext context_ = new VelocityContext();
        Iterator it = data.entrySet().iterator();
        Object temp = null;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            temp = entry.getValue();
            context_.put((String)entry.getKey(), temp);
        }
        return context_;
    }

    public VelocityContext buildVelocityContext() {
        VelocityContext context_ = new VelocityContext();
        return context_;
    }

    public static String getDate(Date date) {
        return ESUtil.getDate(date, (DateFormateMeta)null);
    }

    public static String getDate(Date date, DateFormateMeta dateFormateMeta) {
        Object format = null;
        DateFormat f = null;
        if (dateFormateMeta == null) {
            dateFormateMeta = SerialUtil.getDateFormateMeta();
        }
        f = dateFormateMeta.toDateFormat();
        try {
            String _date = f.format(date);
            return _date;
        }
        catch (Exception e) {
            throw new ElasticSearchException(e);
        }
    }

    public static String getDate(Date date, DateFormat f) {
        try {
            String _date = f.format(date);
            return _date;
        }
        catch (Exception e) {
            throw new ElasticSearchException(e);
        }
    }

    public void handleVaribleValue(StringBuilder builder, ESTemplateCache.TempateVariable variable, String value, boolean escape) {
        int escapeCount = variable.getEscapeCount();
        if (variable.isQuoted()) {
            if (escapeCount <= 1) {
                builder.append("\"");
            } else {
                for (int i = 0; i < escapeCount - 1; ++i) {
                    builder.append("\\");
                }
                builder.append("\"");
            }
        }
        if (variable.getLpad() != null || variable.getRpad() != null) {
            StringBuilder innerValue = new StringBuilder();
            if (variable.getLpad() != null) {
                innerValue.append(variable.getLpad());
            }
            innerValue.append(value);
            if (variable.getRpad() != null) {
                innerValue.append(variable.getRpad());
            }
            if (!escape) {
                builder.append(innerValue.toString());
            } else if (escapeCount <= 1) {
                CharEscapeUtil charEscapeUtil = new CharEscapeUtil((Writer)new BBossStringWriter(builder));
                charEscapeUtil.writeString(innerValue.toString(), true);
            } else {
                String innerValueString = innerValue.toString();
                innerValue.setLength(0);
                for (int i = 0; i < escapeCount; ++i) {
                    CharEscapeUtil charEscapeUtil = new CharEscapeUtil((Writer)new BBossStringWriter(innerValue));
                    charEscapeUtil.writeString(innerValueString, true);
                    innerValueString = innerValue.toString();
                    innerValue.setLength(0);
                }
                builder.append(innerValueString);
            }
        } else if (!escape) {
            builder.append(value);
        } else if (escapeCount <= 1) {
            CharEscapeUtil charEscapeUtil = new CharEscapeUtil((Writer)new BBossStringWriter(builder));
            charEscapeUtil.writeString(value, true);
        } else {
            StringBuilder innerValue = new StringBuilder();
            for (int i = 0; i < escapeCount; ++i) {
                CharEscapeUtil charEscapeUtil = new CharEscapeUtil((Writer)new BBossStringWriter(innerValue));
                charEscapeUtil.writeString(value, true);
                value = innerValue.toString();
                innerValue.setLength(0);
            }
            builder.append(value);
        }
        if (variable.isQuoted()) {
            if (escapeCount <= 1) {
                builder.append("\"");
            } else {
                for (int i = 0; i < escapeCount - 1; ++i) {
                    builder.append("\\");
                }
                builder.append("\"");
            }
        }
    }

    public void getVariableValue(StringBuilder builder, ESTemplateCache.TempateVariable variable, Object bean, List<ClassUtil.PropertieDescription> attributes, ClassUtil.ClassInfo beanInfo, String template) {
        String name = null;
        DateFormateMeta dataformat = variable.getDateFormateMeta();
        Boolean escape = variable.getEscape();
        Object value = null;
        Class<?> type = null;
        for (int i = 0; attributes != null && i < attributes.size(); ++i) {
            ColumnWraper column;
            ClassUtil.PropertieDescription property = attributes.get(i);
            if (!property.getName().equals(variable.getVariableName()) || (column = property.getColumn()) != null && (column.ignoreCUDbind() || column.ignorebind())) continue;
            type = property.getPropertyType();
            try {
                if (property.canread()) {
                    String value_;
                    try {
                        value = property.getValue(bean);
                    }
                    catch (InvocationTargetException e1) {
                        log.error("\u83b7\u53d6\u5c5e\u6027[" + beanInfo.getClazz().getName() + ("." + property.getName()) + "]\u503c\u5931\u8d25\uff1a\u8bf7\u68c0\u67e5\u6a21\u677f\u5b9a\u4e49" + "[" + template + "]@" + this.templatecontext.getConfigfile(), e1.getTargetException());
                    }
                    catch (Exception e1) {
                        log.error("\u83b7\u53d6\u5c5e\u6027[" + beanInfo.getClazz().getName() + ("." + property.getName()) + "]\u503c\u5931\u8d25\uff1a\u8bf7\u68c0\u67e5\u6a21\u677f\u5b9a\u4e49" + "[" + template + "]@" + this.templatecontext.getConfigfile(), (Throwable)e1);
                    }
                    name = property.getName();
                    if (column != null) {
                        ColumnEditorInf editor;
                        if (escape == null) {
                            escape = column.isEscape();
                        }
                        if ((editor = column.editor()) == null || editor instanceof ColumnToFieldEditor) {
                            if (dataformat == null) {
                                dataformat = column.getDateFormateMeta();
                            }
                        } else {
                            Object cv = editor.toColumnValue(column, value);
                            if (cv == null) {
                                throw new ElasticSearchException("\u8f6c\u6362\u5c5e\u6027[" + beanInfo.getClazz().getName() + "." + property.getName() + "]\u503c\u5931\u8d25\uff1a\u503c\u4e3anull\u65f6\uff0c\u8f6c\u6362\u5668\u5fc5\u987b\u8fd4\u56deColumnType\u7c7b\u578b\u7684\u5bf9\u8c61,\u7528\u6765\u6307\u793a\u8868\u5b57\u6bb5\u5bf9\u5e94\u7684java\u7c7b\u578b\u3002\u8bf7\u68c0\u67e5\u6a21\u677f\u5b9a\u4e49" + "[" + template + "]@" + this.templatecontext.getConfigfile());
                            }
                            if (!(cv instanceof ColumnType)) {
                                value = cv;
                                type = value.getClass();
                            } else {
                                type = ((ColumnType)cv).getType();
                            }
                        }
                    }
                    if (value == null) {
                        builder.append("null");
                    } else if (value instanceof Date) {
                        value_ = ESUtil.getDate((Date)value, dataformat);
                        this.handleVaribleValue(builder, variable, value_, false);
                    } else if ((value = VariableHandler.evaluateVariableValue((VariableHandler.Variable)variable, (Object)value)) == null) {
                        builder.append("null");
                    } else if (value instanceof String) {
                        if (escape == null) {
                            this.handleVaribleValue(builder, variable, (String)value, true);
                        } else {
                            this.handleVaribleValue(builder, variable, (String)value, escape);
                        }
                    } else if (value instanceof Date) {
                        value_ = ESUtil.getDate((Date)value, dataformat);
                        this.handleVaribleValue(builder, variable, value_, false);
                    } else {
                        this.handleObject(variable, builder, value);
                    }
                }
                name = null;
                value = null;
                dataformat = null;
                return;
            }
            catch (SecurityException e) {
                throw new ElasticSearchException("\u8f6c\u6362\u5c5e\u6027\u503c\u5931\u8d25\uff1a\u8bf7\u68c0\u67e5\u6a21\u677f\u5b9a\u4e49" + "[" + template + "]@" + this.templatecontext.getConfigfile(), e);
            }
            catch (IllegalArgumentException e) {
                throw new ElasticSearchException("\u8f6c\u6362\u5c5e\u6027\u503c\u5931\u8d25\uff1a\u8bf7\u68c0\u67e5\u6a21\u677f\u5b9a\u4e49" + "[" + template + "]@" + this.templatecontext.getConfigfile(), e);
            }
            catch (Exception e) {
                throw new ElasticSearchException(e);
            }
        }
        throw new ElasticsearchParseException(beanInfo.getClazz().getName() + "\u6ca1\u6709\u4e3aelasticsearch\u6a21\u677f[" + template + "]@" + this.templatecontext.getConfigfile() + "\u6307\u5b9a\u53d8\u91cf\u503c[" + variable.getVariableName() + "]");
    }

    public void evalStruction(StringBuilder builder, VariableHandler.URLStruction templateStruction, Object bean, String template) {
        List tokens = templateStruction.getTokens();
        List variables = templateStruction.getVariables();
        ClassUtil.ClassInfo beanInfo = ClassUtil.getClassInfo(bean.getClass());
        List attributes = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < tokens.size(); ++i) {
            builder.append((String)tokens.get(i));
            if (i >= variables.size()) continue;
            ESTemplateCache.TempateVariable variable = (ESTemplateCache.TempateVariable)((Object)variables.get(i));
            this.getVariableValue(builder, variable, bean, attributes, beanInfo, template);
        }
    }

    public void evalStruction(StringBuilder builder, VariableHandler.URLStruction templateStruction, Map bean, String template) {
        List tokens = templateStruction.getTokens();
        List variables = templateStruction.getVariables();
        for (int i = 0; i < tokens.size(); ++i) {
            String value_;
            builder.append((String)tokens.get(i));
            if (i >= variables.size()) continue;
            ESTemplateCache.TempateVariable variable = (ESTemplateCache.TempateVariable)((Object)variables.get(i));
            Boolean escape = variable.getEscape();
            Object data = bean.get(variable.getVariableName());
            if (data == null) {
                if (bean.containsKey(variable.getVariableName())) {
                    builder.append("null");
                    continue;
                }
                throw new ElasticsearchParseException("\u6ca1\u6709\u4e3aelasticsearch\u6a21\u677f[" + template + "]@" + this.templatecontext.getConfigfile() + "\u6307\u5b9a\u53d8\u91cf\u503c[" + variable.getVariableName() + "]");
            }
            Object value = data;
            if (value instanceof Date) {
                value_ = ESUtil.getDate((Date)value, variable.getDateFormateMeta());
                this.handleVaribleValue(builder, variable, value_, false);
                continue;
            }
            if ((value = VariableHandler.evaluateVariableValue((VariableHandler.Variable)variable, value)) == null) {
                builder.append("null");
                continue;
            }
            if (value instanceof Date) {
                value_ = ESUtil.getDate((Date)value, variable.getDateFormateMeta());
                this.handleVaribleValue(builder, variable, value_, false);
                continue;
            }
            if (value instanceof String) {
                if (escape == null) {
                    this.handleVaribleValue(builder, variable, (String)value, true);
                    continue;
                }
                this.handleVaribleValue(builder, variable, (String)value, escape);
                continue;
            }
            this.handleObject(variable, builder, value);
        }
    }

    private void handleObject(ESTemplateCache.TempateVariable variable, StringBuilder builder, Object value) {
        if (variable.getSerialJson() == null || !variable.getSerialJson().booleanValue()) {
            if (variable.getLpad() != null) {
                builder.append(variable.getLpad());
            }
            builder.append(value.toString());
            if (variable.getRpad() != null) {
                builder.append(variable.getRpad());
            }
        } else {
            int escapeCount = variable.getEscapeCount();
            if (escapeCount <= 1) {
                builder.append(SerialUtil.object2json(value));
            } else {
                String _value = SerialUtil.object2json(value);
                StringBuilder innerValue = new StringBuilder();
                for (int i = 0; i < escapeCount - 1; ++i) {
                    CharEscapeUtil charEscapeUtil = new CharEscapeUtil((Writer)new BBossStringWriter(innerValue));
                    charEscapeUtil.writeString(_value, true);
                    _value = innerValue.toString();
                    innerValue.setLength(0);
                }
                builder.append(_value);
            }
        }
    }

    public Map<String, ESRef> getESRefers() {
        return this.esrefs;
    }

    private void trimValues() {
        if (this.templatecontext == null) {
            return;
        }
        this.esInfos = null;
        this.esrefs = null;
        this.esInfos = new HashMap<String, ESInfo>();
        this.esrefs = new HashMap<String, ESRef>();
        Set keys = this.templatecontext.getPropertyKeys();
        if (keys != null && keys.size() > 0) {
            for (String key : keys) {
                Pro pro = this.templatecontext.getProBean(key);
                String templateFile = (String)pro.getExtendAttribute("templateFile");
                if (templateFile == null) {
                    String value;
                    Object o = pro.getObject();
                    if (!(o instanceof String) || (value = (String)o) == null) continue;
                    boolean istpl = pro.getBooleanExtendAttribute("istpl", true);
                    boolean multiparser = pro.getBooleanExtendAttribute("multiparser", istpl);
                    ESTemplate sqltpl = null;
                    value = value.trim();
                    ESInfo sqlinfo = new ESInfo(key, value, istpl, multiparser, pro);
                    sqlinfo.setEsUtil(this);
                    if (istpl) {
                        sqltpl = new ESTemplate(sqlinfo);
                        sqlinfo.setEstpl(sqltpl);
                        BBossVelocityUtil.initTemplate((Resource)sqltpl);
                        try {
                            sqltpl.process();
                        }
                        catch (Exception e) {
                            log.error(sqlinfo.getTemplate(), (Throwable)e);
                        }
                    }
                    this.esInfos.put(key, sqlinfo);
                    continue;
                }
                String templateName = (String)pro.getExtendAttribute("templateName");
                if (templateName == null) {
                    log.warn(this.templatecontext.getConfigfile() + "\u4e2dname=" + key + "\u7684es template\u88ab\u914d\u7f6e\u4e3a\u5bf9" + templateFile + "\u4e2d\u7684templatename\u5f15\u7528\uff0c\u4f46\u662f\u6ca1\u6709\u901a\u8fc7templateName\u8bbe\u7f6e\u8981\u5f15\u7528\u7684es template\u8bed\u53e5!");
                    continue;
                }
                this.esrefs.put(key, new ESRef(templateName, templateFile, key));
                this.hasrefs = true;
            }
        }
    }

    public boolean hasrefs() {
        return this.hasrefs;
    }

    void _destroy() {
        if (this.esInfos != null) {
            this.esInfos.clear();
            this.esInfos = null;
        }
        if (this.esrefs != null) {
            this.esrefs.clear();
            this.esrefs = null;
        }
        this.templateCache.clear();
        if (this.templatecontext != null) {
            this.templatecontext.destroy(true);
        }
    }

    void reinit() {
        if (this.esInfos != null) {
            this.esInfos.clear();
            this.esInfos = null;
        }
        if (this.esrefs != null) {
            this.esrefs.clear();
            this.esrefs = null;
        }
        this.templateCache.clear();
        String file = this.templatecontext.getConfigfile();
        this.templatecontext.destroy(true);
        this.templatecontext = new ESSOAFileApplicationContext(file);
        this.trimValues();
    }

    public static void stopmonitor() {
        try {
            if (damon != null) {
                damon.stopped();
                damon = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getTemplateFile() {
        return this.templatecontext.getConfigfile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkESUtil(String sqlfile, ESUtil sqlutil) {
        refresh_interval = ElasticSearchHelper.getDslfileRefreshInterval();
        if (refresh_interval > 0L) {
            if (damon == null) {
                Object object = lock;
                synchronized (object) {
                    if (damon == null) {
                        damon = new DaemonThread(refresh_interval, "ElasticSearch files Refresh Worker");
                        damon.start();
                    }
                }
            }
            damon.addFile(sqlfile, (ResourceInitial)new ResourceTempateRefresh(sqlutil));
        } else {
            log.debug("ElasticSearch files Refresh Interval:" + refresh_interval + ",ignore hotload dsl file[" + sqlfile + "]");
        }
    }

    private ESUtil(String templatefile) {
        this.templateFile = templatefile;
        this.templatecontext = new ESSOAFileApplicationContext(templatefile);
        this.realTemplateFile = this.templatecontext.getConfigfile();
        this.trimValues();
        ESUtil.checkESUtil(templatefile, this);
    }

    public ESUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ESUtil getInstance(String templateFile) {
        ESUtil sqlUtil = esutils.get(templateFile);
        if (sqlUtil != null) {
            return sqlUtil;
        }
        Map<String, ESUtil> map = esutils;
        synchronized (map) {
            sqlUtil = esutils.get(templateFile);
            if (sqlUtil != null) {
                return sqlUtil;
            }
            sqlUtil = new ESUtil(templateFile);
            esutils.put(templateFile, sqlUtil);
        }
        return sqlUtil;
    }

    static void destory() {
        if (esutils != null) {
            for (Map.Entry<String, ESUtil> entry : esutils.entrySet()) {
                entry.getValue()._destroy();
            }
            esutils.clear();
            esutils = null;
        }
    }

    private ESInfo getReferESInfo(String templateName) {
        ESRef ref = this.esrefs.get(templateName);
        if (ref != null) {
            return ref.getESInfo();
        }
        return null;
    }

    public ESInfo getESInfo(String templateName) {
        ESInfo sql = null;
        if (this.hasrefs && (sql = this.getReferESInfo(templateName)) != null) {
            return sql;
        }
        sql = this.esInfos.get(templateName);
        return sql;
    }

    public String getPlainTemplate(String templateName) {
        ESInfo sql = null;
        if (this.hasrefs && (sql = this.getReferESInfo(templateName)) != null) {
            return sql.getTemplate();
        }
        sql = this.esInfos.get(templateName);
        if (sql != null) {
            return sql.getTemplate();
        }
        return null;
    }

    private String getReferTemplate(String templateName) {
        ESRef ref = this.esrefs.get(templateName);
        if (ref != null) {
            return ref.getTemplate();
        }
        return null;
    }

    public String getTemplate(String templateName) {
        String sql;
        if (this.hasrefs && (sql = this.getReferTemplate(templateName)) != null) {
            return sql;
        }
        ESInfo esInfo = this.esInfos.get(templateName);
        return esInfo != null ? esInfo.getTemplate() : null;
    }

    private String getReferTemplate(String templateName, Map variablevalues) {
        ESRef ref = this.esrefs.get(templateName);
        if (ref != null) {
            return ref.getTemplate(variablevalues);
        }
        return null;
    }

    public String getTemplate(String templateName, Map variablevalues) {
        String sql;
        if (this.hasrefs && (sql = this.getReferTemplate(templateName, variablevalues)) != null) {
            return sql;
        }
        String newsql = null;
        ESInfo sql2 = this.esInfos.get(templateName);
        if (sql2 != null) {
            newsql = ESUtil._getTemplate(sql2, variablevalues);
        }
        return newsql;
    }

    public static String _getTemplate(ESInfo sqlinfo, Map variablevalues) {
        String sql = null;
        VelocityContext vcontext = null;
        if (sqlinfo.isTpl()) {
            sqlinfo.getEstpl().process();
            if (sqlinfo.isTpl()) {
                vcontext = BBossVelocityUtil.buildVelocityContext((Map)variablevalues);
                StringWriter sw = new StringWriter();
                sqlinfo.getEstpl().merge((Context)vcontext, sw);
                sql = sw.toString();
            } else {
                sql = sqlinfo.getTemplate();
            }
        } else {
            sql = sqlinfo.getTemplate();
        }
        return sql;
    }

    public String evaluateSQL(String name, String sql, Map variablevalues) {
        if (sql != null && variablevalues != null && variablevalues.size() > 0) {
            sql = BBossVelocityUtil.evaluate((Map)variablevalues, (String)(this.templatecontext.getConfigfile() + "|" + name), (String)sql);
        }
        return sql;
    }

    public String[] getPropertyKeys() {
        Set keys = this.templatecontext.getPropertyKeys();
        if (keys == null) {
            return new String[0];
        }
        String[] rets = new String[keys.size()];
        Iterator its = keys.iterator();
        int i = 0;
        while (its.hasNext()) {
            rets[i] = (String)its.next();
            ++i;
        }
        return rets;
    }

    public BaseApplicationContext getTemplateContext() {
        return this.templatecontext;
    }

    public long getRefresh_interval() {
        return refresh_interval;
    }

    public static List<String> getTemplateFiles() {
        Iterator<String> it = esutils.keySet().iterator();
        ArrayList<String> files = new ArrayList<String>();
        while (it.hasNext()) {
            files.add(it.next());
        }
        return files;
    }

    public boolean fromConfig() {
        return this.templatecontext != null;
    }

    public String getRealTemplateFile() {
        return this.realTemplateFile;
    }

    static {
        BaseApplicationContext.addShutdownHook((Runnable)new Runnable(){

            @Override
            public void run() {
                ESUtil.stopmonitor();
                ESUtil.destory();
            }
        });
        lock = new Object();
    }

    static class ResourceTempateRefresh
    implements ResourceInitial {
        private ESUtil sqlutil;

        public ResourceTempateRefresh(ESUtil sqlutil) {
            this.sqlutil = sqlutil;
        }

        public void reinit() {
            this.sqlutil.reinit();
        }
    }

    public static class ESRef {
        private ESUtil esutil;
        private String esname;
        private String templatefile;
        private String name;

        public ESRef(String esname, String templatefile, String name) {
            this.esname = esname;
            this.templatefile = templatefile;
            this.name = name;
        }

        public String getESname() {
            return this.esname;
        }

        public String getTemplatefile() {
            return this.templatefile;
        }

        public String getName() {
            return this.name;
        }

        public ESInfo getESInfo() {
            if (this.esutil == null) {
                this.init();
            }
            return this.esutil.getESInfo(this.esname);
        }

        private synchronized void init() {
            if (this.esutil == null) {
                this.esutil = ESUtil.getInstance(this.templatefile);
            }
        }

        public String getTemplate() {
            if (this.esutil == null) {
                this.init();
            }
            return this.esutil.getTemplate(this.esname);
        }

        public String getTemplate(Map variablevalues) {
            if (this.esutil == null) {
                this.init();
            }
            return this.esutil.getTemplate(this.esname, variablevalues);
        }
    }
}

