/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import java.util.Map;
import org.apache.http.client.ResponseHandler;
import org.frameworkset.elasticsearch.client.ElasticSearchClient;
import org.frameworkset.elasticsearch.handler.ESStringResponseHandler;
import org.frameworkset.spi.remote.http.HttpRequestUtil;

public class RestSeachExecutor {
    private Map<String, String> headers;
    private String httpPool;
    private ElasticSearchClient elasticSearchClient;

    public RestSeachExecutor(Map<String, String> headers, String httpPool, ElasticSearchClient elasticSearchClient) {
        this.headers = headers;
        this.httpPool = httpPool;
        this.elasticSearchClient = elasticSearchClient;
    }

    public String execute(String url, String entity, ESStringResponseHandler responseHandler) throws Exception {
        String response = (String)HttpRequestUtil.sendJsonBody((String)this.httpPool, (String)entity, (String)url, this.headers, (ResponseHandler)responseHandler);
        return response;
    }

    public <T> T executeHttp(String url, String entity, String action, ResponseHandler<T> responseHandler) throws Exception {
        return this._executeHttp(url, entity, action, responseHandler);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> T _executeHttp(String url, String entity, String action, ResponseHandler<T> responseHandler) throws Exception {
        Object response = null;
        if (entity == null) {
            if (action == null) {
                response = HttpRequestUtil.httpPostforString((String)this.httpPool, (String)url, null, this.headers, responseHandler);
                return (T)response;
            } else if (action == "post") {
                response = HttpRequestUtil.httpPostforString((String)this.httpPool, (String)url, null, this.headers, responseHandler);
                return (T)response;
            } else if (action == "put") {
                response = HttpRequestUtil.httpPutforString((String)this.httpPool, (String)url, null, this.headers, responseHandler);
                return (T)response;
            } else if (action == "get") {
                response = HttpRequestUtil.httpGetforString((String)this.httpPool, (String)url, this.headers, responseHandler);
                return (T)response;
            } else if (action == "delete") {
                response = HttpRequestUtil.httpDelete((String)this.httpPool, (String)url, null, this.headers, responseHandler);
                return (T)response;
            } else {
                if (action != "head") throw new IllegalArgumentException("not support http action:" + action);
                response = HttpRequestUtil.httpHead((String)this.httpPool, (String)url, null, this.headers, responseHandler);
            }
            return (T)response;
        } else if (action == "post") {
            response = HttpRequestUtil.sendJsonBody((String)this.httpPool, (String)entity, (String)url, this.headers, responseHandler);
            return (T)response;
        } else if (action == "put") {
            response = HttpRequestUtil.putJson((String)this.httpPool, (String)entity, (String)url, this.headers, responseHandler);
            return (T)response;
        } else {
            if (action != "delete") throw new IllegalArgumentException("not support http action:" + action);
            response = HttpRequestUtil.httpDelete((String)this.httpPool, (String)url, (String)entity, null, this.headers, responseHandler);
        }
        return (T)response;
    }

    public <T> T discoverHost(String url, String entity, String action, ResponseHandler<T> responseHandler) throws Exception {
        return this._executeHttp(url, entity, action, responseHandler);
    }

    public String executeSimpleRequest(String url, String entity, ESStringResponseHandler responseHandler) throws Exception {
        String response = null;
        response = entity == null ? (String)HttpRequestUtil.httpPostforString((String)this.httpPool, (String)url, null, this.headers, (ResponseHandler)responseHandler) : (String)HttpRequestUtil.sendJsonBody((String)this.httpPool, (String)entity, (String)url, this.headers, (ResponseHandler)responseHandler);
        return response;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> T executeRequest(String url, String entity, String action, ResponseHandler<T> responseHandler) throws Exception {
        Object response = null;
        if (entity == null) {
            if (action == null) {
                response = HttpRequestUtil.httpPostforString((String)this.httpPool, (String)url, null, this.headers, responseHandler);
                return (T)response;
            } else if (action == "post") {
                response = HttpRequestUtil.httpPostforString((String)this.httpPool, (String)url, null, this.headers, responseHandler);
                return (T)response;
            } else if (action == "put") {
                response = HttpRequestUtil.httpPutforString((String)this.httpPool, (String)url, null, this.headers, responseHandler);
                return (T)response;
            } else if (action == "get") {
                response = HttpRequestUtil.httpGetforString((String)this.httpPool, (String)url, this.headers, responseHandler);
                return (T)response;
            } else if (action == "delete") {
                response = HttpRequestUtil.httpDelete((String)this.httpPool, (String)url, null, this.headers, responseHandler);
                return (T)response;
            } else {
                if (action != "head") throw new IllegalArgumentException("not support http action:" + action);
                response = HttpRequestUtil.httpHead((String)this.httpPool, (String)url, null, this.headers, responseHandler);
            }
            return (T)response;
        } else if (action == "post") {
            response = HttpRequestUtil.sendJsonBody((String)this.httpPool, (String)entity, (String)url, this.headers, responseHandler);
            return (T)response;
        } else if (action == "put") {
            response = HttpRequestUtil.putJson((String)this.httpPool, (String)entity, (String)url, this.headers, responseHandler);
            return (T)response;
        } else {
            if (action != "delete") throw new IllegalArgumentException("not support http action:" + action);
            response = HttpRequestUtil.httpDelete((String)this.httpPool, (String)url, (String)entity, null, this.headers, responseHandler);
        }
        return (T)response;
    }

    public String getClusterVersionInfo() {
        return this.elasticSearchClient.getClusterVersionInfo();
    }
}

