/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import com.frameworkset.util.SimpleStringUtil;
import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.util.EntityUtils;
import org.frameworkset.elasticsearch.ElasticSearch;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.IndexNameBuilder;
import org.frameworkset.elasticsearch.client.ClientUtil;
import org.frameworkset.elasticsearch.client.ConfigRestClientUtil;
import org.frameworkset.elasticsearch.client.ESAddress;
import org.frameworkset.elasticsearch.client.ElasticSearchClient;
import org.frameworkset.elasticsearch.client.HealthCheck;
import org.frameworkset.elasticsearch.client.HostDiscover;
import org.frameworkset.elasticsearch.client.NoServerElasticSearchException;
import org.frameworkset.elasticsearch.client.RestClientUtil;
import org.frameworkset.elasticsearch.client.RestSeachExecutor;
import org.frameworkset.elasticsearch.client.RoundRobinList;
import org.frameworkset.elasticsearch.handler.BaseExceptionResponseHandler;
import org.frameworkset.elasticsearch.handler.ESStringResponseHandler;
import org.frameworkset.util.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchRestClient
implements ElasticSearchClient {
    public static final String INDEX_OPERATION_NAME = "index";
    public static final String INDEX_PARAM = "_index";
    public static final String TYPE_PARAM = "_type";
    public static final String TTL_PARAM = "_ttl";
    public static final String BULK_ENDPOINT = "_bulk";
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchRestClient.class);
    protected final RoundRobinList serversList;
    protected Properties extendElasticsearchPropes;
    protected String httpPool;
    protected String elasticUser;
    protected String elasticPassword;
    protected long healthCheckInterval = -1L;
    protected RestSeachExecutor restSeachExecutor;
    protected Map<String, String> headers = new HashMap<String, String>();
    protected boolean showTemplate = false;
    protected List<ESAddress> addressList;
    protected FastDateFormat fastDateFormat = FastDateFormat.getInstance((String)"yyyy.MM.dd", (TimeZone)TimeZone.getTimeZone("Etc/UTC"));
    protected String dateFormat = "yyyy.MM.dd";
    protected TimeZone timeZone = TimeZone.getTimeZone("Etc/UTC");
    protected boolean discoverHost = false;
    protected ElasticSearch elasticSearch;
    protected HealthCheck healthCheck = null;
    private Map clusterInfo;
    private String clusterVersionInfo;
    private String clusterVarcharInfo;
    private Map<String, ESAddress> addressMap = new HashMap<String, ESAddress>();

    public ElasticSearch getElasticSearch() {
        return this.elasticSearch;
    }

    public Map<String, ESAddress> getAddressMap() {
        return this.addressMap;
    }

    public ElasticSearchRestClient(ElasticSearch elasticSearch, String[] hostNames, String elasticUser, String elasticPassword, Properties extendElasticsearchPropes) {
        this.extendElasticsearchPropes = extendElasticsearchPropes;
        this.elasticSearch = elasticSearch;
        this.addressList = new ArrayList<ESAddress>();
        for (String host : hostNames) {
            ESAddress esAddress = new ESAddress(host);
            this.addressList.add(esAddress);
            this.addressMap.put(esAddress.getAddress(), esAddress);
        }
        this.serversList = new RoundRobinList(this.addressList);
        this.elasticUser = elasticUser;
        this.elasticPassword = elasticPassword;
    }

    public boolean containAddress(ESAddress address) {
        return this.addressMap.containsKey(address.getAddress());
    }

    public void handleRemoved(List<HttpHost> hosts) {
        boolean hasHosts = true;
        if (hosts == null || hosts.size() == 0) {
            hasHosts = false;
        }
        for (Map.Entry<String, ESAddress> esAddressEntry : this.addressMap.entrySet()) {
            String host = esAddressEntry.getKey();
            ESAddress address = esAddressEntry.getValue();
            if (hasHosts) {
                boolean exist = false;
                for (HttpHost httpHost : hosts) {
                    if (!httpHost.toString().equals(host)) continue;
                    exist = true;
                    break;
                }
                if (exist) continue;
                address.setStatus(2);
                if (!logger.isInfoEnabled()) continue;
                logger.info("ElasticSearch Node[" + address.toString() + "] is down.");
                continue;
            }
            address.setStatus(2);
            if (!logger.isInfoEnabled()) continue;
            logger.info("ElasticSearch Node[" + address.toString() + "] is down.");
        }
    }

    public void addAddresses(List<ESAddress> address) {
        this.serversList.addAddresses(address);
        if (this.healthCheck != null) {
            this.healthCheck.checkNewAddresses(address);
        }
        for (ESAddress host : address) {
            this.addressMap.put(host.getAddress(), host);
        }
        if (logger.isInfoEnabled()) {
            StringBuilder info = new StringBuilder();
            info.append("All Live ElasticSearch Server:");
            Iterator<Map.Entry<String, ESAddress>> iterator = this.addressMap.entrySet().iterator();
            boolean firsted = true;
            while (iterator.hasNext()) {
                Map.Entry<String, ESAddress> esAddressEntry = iterator.next();
                String host = esAddressEntry.getKey();
                if (firsted) {
                    info.append(host);
                    firsted = false;
                    continue;
                }
                info.append(",").append(host);
            }
            logger.info(info.toString());
        }
    }

    private void initVersionInfo() {
        this.getElasticSearch().getRestClientUtil().discover("/", "get", new ResponseHandler<Void>(){

            public Void handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                int status = response.getStatusLine().getStatusCode();
                if (status >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    ElasticSearchRestClient.this.clusterVarcharInfo = entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
                    if (logger.isInfoEnabled()) {
                        logger.info("Elasticsearch Server Info:\n" + ElasticSearchRestClient.this.clusterVarcharInfo);
                    }
                    ElasticSearchRestClient.this.clusterInfo = (Map)SimpleStringUtil.json2Object((String)ElasticSearchRestClient.this.clusterVarcharInfo, Map.class);
                    Object version = ElasticSearchRestClient.this.clusterInfo.get("version");
                    if (version instanceof Map) {
                        ElasticSearchRestClient.this.clusterVersionInfo = "clusterName:" + ElasticSearchRestClient.this.clusterInfo.get("cluster_name") + ",version:" + ((Map)version).get("number");
                    } else {
                        ElasticSearchRestClient.this.clusterVersionInfo = "clusterName:" + ElasticSearchRestClient.this.clusterInfo.get("cluster_name") + ",version:" + version;
                    }
                }
                return null;
            }
        });
    }

    @Override
    public void init() {
        if (this.elasticUser != null && !this.elasticUser.equals("")) {
            this.headers.put("Authorization", ElasticSearchRestClient.getHeader(this.elasticUser, this.elasticPassword));
        }
        this.restSeachExecutor = new RestSeachExecutor(this.headers, this.httpPool, this);
        this.initVersionInfo();
        if (this.healthCheckInterval > 0L) {
            logger.info("Start Elasticsearch healthCheck thread,you can set elasticsearch.healthCheckInterval=-1 in " + this.elasticSearch.getConfigContainerInfo() + " to disable healthCheck thread.");
            this.healthCheck = new HealthCheck(this.addressList, this.healthCheckInterval, this.headers);
            this.healthCheck.run();
        } else {
            logger.info("Elasticsearch healthCheck disable,you can set elasticsearch.healthCheckInterval=3000 in " + this.elasticSearch.getConfigContainerInfo() + " to enabled healthCheck thread.");
        }
        if (this.discoverHost) {
            logger.info("Start elastic discoverHost thread,to distabled set elasticsearch.discoverHost=false in " + this.elasticSearch.getConfigContainerInfo() + ".");
            HostDiscover hostDiscover = new HostDiscover(this);
            hostDiscover.start();
        } else {
            logger.info("Discover Elasticsearch Host is disabled,to enabled set elasticsearch.discoverHost=true  in " + this.elasticSearch.getConfigContainerInfo() + ".");
        }
    }

    public static String getHeader(String user, String password) {
        String auth = user + ":" + password;
        byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes(Charset.forName("US-ASCII")));
        return "Basic " + new String(encodedAuth);
    }

    @Override
    public void configure(Properties elasticsearchPropes) {
        String dateFormatString = elasticsearchPropes.getProperty("elasticsearch.dateFormat");
        String timeZoneString = elasticsearchPropes.getProperty("elasticsearch.timeZone");
        String showTemplate_ = elasticsearchPropes.getProperty("elasticsearch.showTemplate");
        String httpPool = elasticsearchPropes.getProperty("elasticsearch.httpPool");
        if (httpPool == null || httpPool.equals("")) {
            httpPool = "default";
        }
        if (showTemplate_ != null && showTemplate_.equals("true")) {
            this.showTemplate = true;
        }
        if (SimpleStringUtil.isEmpty((String)dateFormatString)) {
            dateFormatString = "yyyy.MM.dd";
        }
        if (SimpleStringUtil.isEmpty((String)timeZoneString)) {
            timeZoneString = "";
        }
        this.dateFormat = dateFormatString;
        this.timeZone = TimeZone.getTimeZone(timeZoneString);
        this.fastDateFormat = FastDateFormat.getInstance((String)dateFormatString, (TimeZone)TimeZone.getTimeZone(timeZoneString));
        String healthCheckInterval_ = elasticsearchPropes.getProperty("elasticsearch.healthCheckInterval");
        if (healthCheckInterval_ == null) {
            this.healthCheckInterval = 3000L;
        } else {
            try {
                this.healthCheckInterval = Long.parseLong(healthCheckInterval_);
            }
            catch (Exception e) {
                logger.error("Parse Long healthCheckInterval parameter failed:" + healthCheckInterval_, (Throwable)e);
            }
        }
        String discoverHost_ = elasticsearchPropes.getProperty("elasticsearch.discoverHost");
        if (discoverHost_ != null) {
            try {
                this.discoverHost = Boolean.parseBoolean(discoverHost_);
            }
            catch (Exception e) {
                logger.error("Parse Long discoverHost parameter failed:" + discoverHost_, (Throwable)e);
            }
        }
    }

    @Override
    public void close() {
    }

    public String execute(String entity, String options) throws ElasticSearchException {
        int triesCount = 0;
        String response = null;
        Throwable e = null;
        ESAddress host = null;
        String url = null;
        String endpoint = BULK_ENDPOINT;
        if (options != null) {
            endpoint = endpoint + "?" + options;
        }
        if (this.showTemplate && logger.isInfoEnabled()) {
            logger.info("ElasticSearch http request action:{},request body:\n{}", (Object)endpoint, (Object)entity);
        }
        while (true) {
            try {
                host = this.serversList.get();
                url = host.getAddress() + "/" + endpoint;
                ESStringResponseHandler responseHandler = new ESStringResponseHandler();
                response = this.restSeachExecutor.execute(url, entity, responseHandler);
                e = this.getException(responseHandler);
            }
            catch (HttpHostConnectException ex) {
                host.setStatus(1);
                e = new NoServerElasticSearchException(ex);
                if (triesCount >= this.serversList.size()) break;
                ++triesCount;
                continue;
            }
            catch (UnknownHostException ex) {
                host.setStatus(1);
                e = new NoServerElasticSearchException(ex);
                if (triesCount >= this.serversList.size()) break;
                ++triesCount;
                continue;
            }
            catch (ConnectTimeoutException connectTimeoutException) {
                host.setStatus(1);
                e = new NoServerElasticSearchException(connectTimeoutException);
                if (triesCount >= this.serversList.size()) break;
                ++triesCount;
                continue;
            }
            catch (NoServerElasticSearchException ex) {
                e = ex;
            }
            catch (ElasticSearchException ex) {
                e = ex;
            }
            catch (Exception ex) {
                e = ex;
            }
            catch (Throwable ex) {
                e = ex;
            }
            break;
        }
        if (e != null) {
            if (e instanceof ElasticSearchException) {
                throw (ElasticSearchException)e;
            }
            throw new ElasticSearchException(e);
        }
        return response;
    }

    @Override
    public ClientUtil getClientUtil(IndexNameBuilder indexNameBuilder) {
        return new RestClientUtil(this, indexNameBuilder);
    }

    @Override
    public ClientUtil getConfigClientUtil(IndexNameBuilder indexNameBuilder, String configFile) {
        return new ConfigRestClientUtil(this, indexNameBuilder, configFile);
    }

    public String executeHttp(String path, String action) throws ElasticSearchException {
        return this.executeHttp(path, null, action);
    }

    public <T> T executeHttp(String path, String action, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return this.executeHttp(path, null, action, responseHandler);
    }

    public <T> T discover(String path, String action, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return this.discover(path, null, action, responseHandler);
    }

    private String getPath(String host, String path) {
        String url = path.equals("") || path.startsWith("/") ? host + path : host + "/" + path;
        return url;
    }

    public <T> T executeHttp(String path, String entity, String action, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return this._executeHttp(path, entity, action, responseHandler, false);
    }

    private <T> T _executeHttp(String path, String entity, String action, ResponseHandler<T> responseHandler, boolean discoverHost) throws ElasticSearchException {
        int triesCount = 0;
        T response = null;
        Throwable e = null;
        if (this.showTemplate && logger.isInfoEnabled()) {
            if (entity != null) {
                logger.info("ElasticSearch http request action:{},request body:\n{}", (Object)path, (Object)entity);
            } else {
                logger.info("ElasticSearch http request action:{}", (Object)path);
            }
        }
        ESAddress host = null;
        String url = null;
        while (true) {
            try {
                host = this.serversList.get();
                url = this.getPath(host.getAddress(), path);
                response = !discoverHost ? (T)this.restSeachExecutor.executeHttp(url, entity, action, responseHandler) : (T)this.restSeachExecutor.discoverHost(url, entity, action, responseHandler);
                e = this.getException(responseHandler);
            }
            catch (HttpHostConnectException ex) {
                host.setStatus(1);
                e = new NoServerElasticSearchException(ex);
                if (triesCount >= this.serversList.size()) break;
                ++triesCount;
                continue;
            }
            catch (UnknownHostException ex) {
                host.setStatus(1);
                e = new NoServerElasticSearchException(ex);
                if (triesCount >= this.serversList.size()) break;
                ++triesCount;
                continue;
            }
            catch (ConnectTimeoutException connectTimeoutException) {
                host.setStatus(1);
                e = new NoServerElasticSearchException(connectTimeoutException);
                if (triesCount >= this.serversList.size()) break;
                ++triesCount;
                continue;
            }
            catch (NoServerElasticSearchException ex) {
                e = ex;
            }
            catch (ElasticSearchException ex) {
                e = ex;
            }
            catch (Exception ex) {
                e = ex;
            }
            catch (Throwable ex) {
                e = ex;
            }
            break;
        }
        if (e != null) {
            if (e instanceof ElasticSearchException) {
                throw (ElasticSearchException)e;
            }
            throw new ElasticSearchException(e);
        }
        return response;
    }

    public <T> T discover(String path, String entity, String action, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return this._executeHttp(path, entity, action, responseHandler, true);
    }

    public String executeHttp(String path, String entity, String action) throws ElasticSearchException {
        return this.executeHttp(path, entity, action, new ESStringResponseHandler());
    }

    public String executeRequest(String path, String entity) throws ElasticSearchException {
        int triesCount = 0;
        String response = null;
        Throwable e = null;
        if (this.showTemplate && logger.isInfoEnabled()) {
            if (entity != null) {
                logger.info("ElasticSearch http request action:{},request body:\n{}", (Object)path, (Object)entity);
            } else {
                logger.info("ElasticSearch http request action:{}", (Object)path);
            }
        }
        ESAddress host = null;
        String url = null;
        while (true) {
            try {
                host = this.serversList.get();
                url = this.getPath(host.getAddress(), path);
                ESStringResponseHandler responseHandler = new ESStringResponseHandler();
                response = this.restSeachExecutor.executeSimpleRequest(url, entity, responseHandler);
                e = this.getException(responseHandler);
            }
            catch (HttpHostConnectException ex) {
                host.setStatus(1);
                e = new NoServerElasticSearchException(ex);
                if (triesCount >= this.serversList.size()) break;
                ++triesCount;
                continue;
            }
            catch (UnknownHostException ex) {
                host.setStatus(1);
                e = new NoServerElasticSearchException(ex);
                if (triesCount >= this.serversList.size()) break;
                ++triesCount;
                continue;
            }
            catch (ConnectTimeoutException connectTimeoutException) {
                host.setStatus(1);
                e = new NoServerElasticSearchException(connectTimeoutException);
                if (triesCount >= this.serversList.size()) break;
                ++triesCount;
                continue;
            }
            catch (NoServerElasticSearchException ex) {
                e = ex;
            }
            catch (ElasticSearchException ex) {
                throw ex;
            }
            catch (Exception ex) {
                e = ex;
            }
            catch (Throwable ex) {
                e = ex;
            }
            break;
        }
        if (e != null) {
            throw new ElasticSearchException(e);
        }
        return response;
    }

    public <T> T executeRequest(String path, String entity, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return this.executeRequest(path, entity, responseHandler, "post");
    }

    private Exception getException(ResponseHandler responseHandler) {
        if (responseHandler instanceof BaseExceptionResponseHandler) {
            return ((BaseExceptionResponseHandler)responseHandler).getElasticSearchException();
        }
        return null;
    }

    public <T> T executeRequest(String path, String entity, ResponseHandler<T> responseHandler, String action) throws ElasticSearchException {
        T response = null;
        int triesCount = 0;
        Throwable e = null;
        if (this.showTemplate && logger.isInfoEnabled()) {
            if (entity != null) {
                logger.info("ElasticSearch http request action:{},request body:\n{}", (Object)path, (Object)entity);
            } else {
                logger.info("ElasticSearch http request action:{}", (Object)path);
            }
        }
        ESAddress host = null;
        String url = null;
        while (true) {
            try {
                host = this.serversList.get();
                url = this.getPath(host.getAddress(), path);
                response = this.restSeachExecutor.executeRequest(url, entity, action, responseHandler);
                e = this.getException(responseHandler);
            }
            catch (HttpHostConnectException ex) {
                host.setStatus(1);
                e = new NoServerElasticSearchException(ex);
                if (triesCount >= this.serversList.size()) break;
                ++triesCount;
                continue;
            }
            catch (UnknownHostException ex) {
                host.setStatus(1);
                e = new NoServerElasticSearchException(ex);
                if (triesCount >= this.serversList.size()) break;
                ++triesCount;
                continue;
            }
            catch (ConnectTimeoutException connectTimeoutException) {
                host.setStatus(1);
                e = new NoServerElasticSearchException(connectTimeoutException);
                if (triesCount >= this.serversList.size()) break;
                ++triesCount;
                continue;
            }
            catch (NoServerElasticSearchException ex) {
                e = ex;
            }
            catch (ElasticSearchException ex) {
                throw ex;
            }
            catch (Exception ex) {
                e = ex;
            }
            catch (Throwable ex) {
                e = ex;
            }
            break;
        }
        if (e != null) {
            if (e instanceof ElasticSearchException) {
                throw (ElasticSearchException)e;
            }
            throw new ElasticSearchException(e);
        }
        return response;
    }

    public FastDateFormat getFastDateFormat() {
        return this.fastDateFormat;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public boolean isShowTemplate() {
        return this.showTemplate;
    }

    public void setShowTemplate(boolean showTemplate) {
        this.showTemplate = showTemplate;
    }

    public void recoverRemovedNodes(List<HttpHost> hosts) {
        if (hosts == null || hosts.size() == 0) {
            return;
        }
        for (HttpHost httpHost : hosts) {
            ESAddress address = this.addressMap.get(httpHost.toString());
            if (address == null || address.getStatus() != 2) continue;
            address.onlySetStatus(0);
        }
    }

    @Override
    public Map getClusterInfo() {
        return this.clusterInfo;
    }

    @Override
    public String getClusterVarcharInfo() {
        return this.clusterVarcharInfo;
    }

    @Override
    public String getClusterVersionInfo() {
        return this.clusterVersionInfo;
    }

    public ExecutorService getSliceScrollQueryExecutorService() {
        return this.elasticSearch.getSliceScrollQueryExecutorService();
    }
}

