/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.schedule.quartz;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.frameworkset.tran.schedule.ExternalScheduler;
import org.frameworkset.util.shutdown.ShutdownUtil;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseQuartzDatasynJob
implements Job {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean inited;
    protected ExternalScheduler externalScheduler;
    private Lock lock = new ReentrantLock();

    public void execute(JobExecutionContext context) throws JobExecutionException {
        this.lock.lock();
        try {
            if (!this.inited) {
                try {
                    this.buildJob();
                }
                finally {
                    this.inited = true;
                }
            }
            this.externalScheduler.execute((Object)context);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void buildJob() {
        this.init();
        ShutdownUtil.addShutdownHook((Runnable)new Runnable(){

            @Override
            public void run() {
                BaseQuartzDatasynJob.this.destroy();
            }
        });
    }

    public void destroy() {
        if (this.externalScheduler != null) {
            this.externalScheduler.destroy();
        }
    }

    public abstract void init();
}

