/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.models.VectorizedQuery;
import java.io.IOException;

public class VectorQuery
implements JsonSerializable<VectorQuery> {
    private Integer kNearestNeighborsCount;
    private String fields;
    private Boolean exhaustive;

    public Integer getKNearestNeighborsCount() {
        return this.kNearestNeighborsCount;
    }

    public VectorQuery setKNearestNeighborsCount(Integer kNearestNeighborsCount) {
        this.kNearestNeighborsCount = kNearestNeighborsCount;
        return this;
    }

    public String getFields() {
        return this.fields;
    }

    public VectorQuery setFields(String ... fields) {
        this.fields = fields == null ? null : String.join((CharSequence)",", fields);
        return this;
    }

    public Boolean isExhaustive() {
        return this.exhaustive;
    }

    public VectorQuery setExhaustive(Boolean exhaustive) {
        this.exhaustive = exhaustive;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("k", (Number)this.kNearestNeighborsCount);
        jsonWriter.writeStringField("fields", this.fields);
        jsonWriter.writeBooleanField("exhaustive", this.exhaustive);
        return jsonWriter.writeEndObject();
    }

    public static VectorQuery fromJson(JsonReader jsonReader) throws IOException {
        return (VectorQuery)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            JsonReader readerToUse = reader.bufferObject();
            readerToUse.nextToken();
            while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = readerToUse.getFieldName();
                readerToUse.nextToken();
                if ("kind".equals(fieldName)) {
                    discriminatorValue = readerToUse.getString();
                    break;
                }
                readerToUse.skipChildren();
            }
            if (discriminatorValue != null) {
                readerToUse = readerToUse.reset();
            }
            if ("vector".equals(discriminatorValue)) {
                return VectorizedQuery.fromJson(readerToUse);
            }
            throw new IllegalStateException("Discriminator field 'kind' didn't match one of the expected values 'vector'");
        });
    }
}

