/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.VectorSearchAlgorithmConfiguration;
import com.azure.search.documents.indexes.models.VectorSearchProfile;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public final class VectorSearch
implements JsonSerializable<VectorSearch> {
    private List<VectorSearchProfile> profiles;
    private List<VectorSearchAlgorithmConfiguration> algorithms;

    public List<VectorSearchProfile> getProfiles() {
        return this.profiles;
    }

    public VectorSearch setProfiles(List<VectorSearchProfile> profiles) {
        this.profiles = profiles;
        return this;
    }

    public List<VectorSearchAlgorithmConfiguration> getAlgorithms() {
        return this.algorithms;
    }

    public VectorSearch setAlgorithms(List<VectorSearchAlgorithmConfiguration> algorithms) {
        this.algorithms = algorithms;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("profiles", this.profiles, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("algorithms", this.algorithms, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static VectorSearch fromJson(JsonReader jsonReader) throws IOException {
        return (VectorSearch)jsonReader.readObject(reader -> {
            VectorSearch deserializedVectorSearch = new VectorSearch();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("profiles".equals(fieldName)) {
                    List profiles;
                    deserializedVectorSearch.profiles = profiles = reader.readArray(reader1 -> VectorSearchProfile.fromJson(reader1));
                    continue;
                }
                if ("algorithms".equals(fieldName)) {
                    List algorithms;
                    deserializedVectorSearch.algorithms = algorithms = reader.readArray(reader1 -> VectorSearchAlgorithmConfiguration.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVectorSearch;
        });
    }

    public VectorSearch setProfiles(VectorSearchProfile ... profiles) {
        this.profiles = profiles == null ? null : Arrays.asList(profiles);
        return this;
    }

    public VectorSearch setAlgorithms(VectorSearchAlgorithmConfiguration ... algorithms) {
        this.algorithms = algorithms == null ? null : Arrays.asList(algorithms);
        return this;
    }
}

