/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.ScoringFunction;
import com.azure.search.documents.indexes.models.ScoringFunctionAggregation;
import com.azure.search.documents.indexes.models.TextWeights;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class ScoringProfile
implements JsonSerializable<ScoringProfile> {
    private final String name;
    private TextWeights textWeights;
    private List<ScoringFunction> functions;
    private ScoringFunctionAggregation functionAggregation;

    public ScoringProfile(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public TextWeights getTextWeights() {
        return this.textWeights;
    }

    public ScoringProfile setTextWeights(TextWeights textWeights) {
        this.textWeights = textWeights;
        return this;
    }

    public List<ScoringFunction> getFunctions() {
        return this.functions;
    }

    public ScoringProfile setFunctions(List<ScoringFunction> functions) {
        this.functions = functions;
        return this;
    }

    public ScoringFunctionAggregation getFunctionAggregation() {
        return this.functionAggregation;
    }

    public ScoringProfile setFunctionAggregation(ScoringFunctionAggregation functionAggregation) {
        this.functionAggregation = functionAggregation;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("text", (JsonSerializable)this.textWeights);
        jsonWriter.writeArrayField("functions", this.functions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("functionAggregation", Objects.toString((Object)this.functionAggregation, null));
        return jsonWriter.writeEndObject();
    }

    public static ScoringProfile fromJson(JsonReader jsonReader) throws IOException {
        return (ScoringProfile)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            TextWeights textWeights = null;
            List functions = null;
            ScoringFunctionAggregation functionAggregation = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("text".equals(fieldName)) {
                    textWeights = TextWeights.fromJson(reader);
                    continue;
                }
                if ("functions".equals(fieldName)) {
                    functions = reader.readArray(reader1 -> ScoringFunction.fromJson(reader1));
                    continue;
                }
                if ("functionAggregation".equals(fieldName)) {
                    functionAggregation = ScoringFunctionAggregation.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                ScoringProfile deserializedScoringProfile = new ScoringProfile(name);
                deserializedScoringProfile.textWeights = textWeights;
                deserializedScoringProfile.functions = functions;
                deserializedScoringProfile.functionAggregation = functionAggregation;
                return deserializedScoringProfile;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }

    public ScoringProfile setFunctions(ScoringFunction ... functions) {
        this.functions = functions == null ? null : Arrays.asList(functions);
        return this;
    }
}

