/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.LexicalTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;

public final class PathHierarchyTokenizer
extends LexicalTokenizer {
    private Character delimiter;
    private Character replacement;
    private Integer maxTokenLength;
    private Boolean tokenOrderReversed;
    private Integer numberOfTokensToSkip;

    public PathHierarchyTokenizer(String name) {
        super(name);
    }

    public Character getDelimiter() {
        return this.delimiter;
    }

    public PathHierarchyTokenizer setDelimiter(Character delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public Character getReplacement() {
        return this.replacement;
    }

    public PathHierarchyTokenizer setReplacement(Character replacement) {
        this.replacement = replacement;
        return this;
    }

    public Integer getMaxTokenLength() {
        return this.maxTokenLength;
    }

    public PathHierarchyTokenizer setMaxTokenLength(Integer maxTokenLength) {
        this.maxTokenLength = maxTokenLength;
        return this;
    }

    public Boolean isTokenOrderReversed() {
        return this.tokenOrderReversed;
    }

    public PathHierarchyTokenizer setTokenOrderReversed(Boolean tokenOrderReversed) {
        this.tokenOrderReversed = tokenOrderReversed;
        return this;
    }

    public Integer getNumberOfTokensToSkip() {
        return this.numberOfTokensToSkip;
    }

    public PathHierarchyTokenizer setNumberOfTokensToSkip(Integer numberOfTokensToSkip) {
        this.numberOfTokensToSkip = numberOfTokensToSkip;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", "#Microsoft.Azure.Search.PathHierarchyTokenizerV2");
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("delimiter", Objects.toString(this.delimiter, null));
        jsonWriter.writeStringField("replacement", Objects.toString(this.replacement, null));
        jsonWriter.writeNumberField("maxTokenLength", (Number)this.maxTokenLength);
        jsonWriter.writeBooleanField("reverse", this.tokenOrderReversed);
        jsonWriter.writeNumberField("skip", (Number)this.numberOfTokensToSkip);
        return jsonWriter.writeEndObject();
    }

    public static PathHierarchyTokenizer fromJson(JsonReader jsonReader) throws IOException {
        return (PathHierarchyTokenizer)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            Character delimiter = null;
            Character replacement = null;
            Integer maxTokenLength = null;
            Boolean tokenOrderReversed = null;
            Integer numberOfTokensToSkip = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if ("#Microsoft.Azure.Search.PathHierarchyTokenizerV2".equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Azure.Search.PathHierarchyTokenizerV2'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("delimiter".equals(fieldName)) {
                    delimiter = (Character)reader.getNullable(nonNullReader -> Character.valueOf(nonNullReader.getString().charAt(0)));
                    continue;
                }
                if ("replacement".equals(fieldName)) {
                    replacement = (Character)reader.getNullable(nonNullReader -> Character.valueOf(nonNullReader.getString().charAt(0)));
                    continue;
                }
                if ("maxTokenLength".equals(fieldName)) {
                    maxTokenLength = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("reverse".equals(fieldName)) {
                    tokenOrderReversed = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("skip".equals(fieldName)) {
                    numberOfTokensToSkip = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                PathHierarchyTokenizer deserializedPathHierarchyTokenizer = new PathHierarchyTokenizer(name);
                deserializedPathHierarchyTokenizer.delimiter = delimiter;
                deserializedPathHierarchyTokenizer.replacement = replacement;
                deserializedPathHierarchyTokenizer.maxTokenLength = maxTokenLength;
                deserializedPathHierarchyTokenizer.tokenOrderReversed = tokenOrderReversed;
                deserializedPathHierarchyTokenizer.numberOfTokensToSkip = numberOfTokensToSkip;
                return deserializedPathHierarchyTokenizer;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

