/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.CustomAnalyzer;
import com.azure.search.documents.indexes.models.LuceneStandardAnalyzer;
import com.azure.search.documents.indexes.models.PatternAnalyzer;
import com.azure.search.documents.indexes.models.StopAnalyzer;
import java.io.IOException;

public abstract class LexicalAnalyzer
implements JsonSerializable<LexicalAnalyzer> {
    private final String name;

    public LexicalAnalyzer(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static LexicalAnalyzer fromJson(JsonReader jsonReader) throws IOException {
        return (LexicalAnalyzer)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            JsonReader readerToUse = reader.bufferObject();
            readerToUse.nextToken();
            while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = readerToUse.getFieldName();
                readerToUse.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    discriminatorValue = readerToUse.getString();
                    break;
                }
                readerToUse.skipChildren();
            }
            if (discriminatorValue != null) {
                readerToUse = readerToUse.reset();
            }
            if ("#Microsoft.Azure.Search.CustomAnalyzer".equals(discriminatorValue)) {
                return CustomAnalyzer.fromJson(readerToUse);
            }
            if ("#Microsoft.Azure.Search.PatternAnalyzer".equals(discriminatorValue)) {
                return PatternAnalyzer.fromJson(readerToUse);
            }
            if ("#Microsoft.Azure.Search.StandardAnalyzer".equals(discriminatorValue)) {
                return LuceneStandardAnalyzer.fromJson(readerToUse);
            }
            if ("#Microsoft.Azure.Search.StopAnalyzer".equals(discriminatorValue)) {
                return StopAnalyzer.fromJson(readerToUse);
            }
            throw new IllegalStateException("Discriminator field '@odata.type' didn't match one of the expected values '#Microsoft.Azure.Search.CustomAnalyzer', '#Microsoft.Azure.Search.PatternAnalyzer', '#Microsoft.Azure.Search.StandardAnalyzer', or '#Microsoft.Azure.Search.StopAnalyzer'. It was: '" + discriminatorValue + "'.");
        });
    }
}

