/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;

public final class AnalyzedTokenInfo
implements JsonSerializable<AnalyzedTokenInfo> {
    private final String token;
    private final int startOffset;
    private final int endOffset;
    private final int position;

    public AnalyzedTokenInfo(String token, int startOffset, int endOffset, int position) {
        this.token = token;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.position = position;
    }

    public String getToken() {
        return this.token;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public int getPosition() {
        return this.position;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static AnalyzedTokenInfo fromJson(JsonReader jsonReader) throws IOException {
        return (AnalyzedTokenInfo)jsonReader.readObject(reader -> {
            boolean tokenFound = false;
            String token = null;
            boolean startOffsetFound = false;
            int startOffset = 0;
            boolean endOffsetFound = false;
            int endOffset = 0;
            boolean positionFound = false;
            int position = 0;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("token".equals(fieldName)) {
                    token = reader.getString();
                    tokenFound = true;
                    continue;
                }
                if ("startOffset".equals(fieldName)) {
                    startOffset = reader.getInt();
                    startOffsetFound = true;
                    continue;
                }
                if ("endOffset".equals(fieldName)) {
                    endOffset = reader.getInt();
                    endOffsetFound = true;
                    continue;
                }
                if ("position".equals(fieldName)) {
                    position = reader.getInt();
                    positionFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (tokenFound && startOffsetFound && endOffsetFound && positionFound) {
                AnalyzedTokenInfo deserializedAnalyzedTokenInfo = new AnalyzedTokenInfo(token, startOffset, endOffset, position);
                return deserializedAnalyzedTokenInfo;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!tokenFound) {
                missingProperties.add("token");
            }
            if (!startOffsetFound) {
                missingProperties.add("startOffset");
            }
            if (!endOffsetFound) {
                missingProperties.add("endOffset");
            }
            if (!positionFound) {
                missingProperties.add("position");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

