/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;

public final class RequestOptions
implements JsonSerializable<RequestOptions> {
    private UUID xMsClientRequestId;

    public UUID getXMsClientRequestId() {
        return this.xMsClientRequestId;
    }

    public RequestOptions setXMsClientRequestId(UUID xMsClientRequestId) {
        this.xMsClientRequestId = xMsClientRequestId;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("x-ms-client-request-id", Objects.toString(this.xMsClientRequestId, null));
        return jsonWriter.writeEndObject();
    }

    public static RequestOptions fromJson(JsonReader jsonReader) throws IOException {
        return (RequestOptions)jsonReader.readObject(reader -> {
            RequestOptions deserializedRequestOptions = new RequestOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("x-ms-client-request-id".equals(fieldName)) {
                    deserializedRequestOptions.xMsClientRequestId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRequestOptions;
        });
    }
}

