/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.LexicalTokenizer;
import java.io.IOException;
import java.util.ArrayList;

public final class KeywordTokenizerV1
extends LexicalTokenizer {
    private Integer bufferSize;

    public KeywordTokenizerV1(String name) {
        super(name);
    }

    public Integer getBufferSize() {
        return this.bufferSize;
    }

    public KeywordTokenizerV1 setBufferSize(Integer bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", "#Microsoft.Azure.Search.KeywordTokenizer");
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeNumberField("bufferSize", (Number)this.bufferSize);
        return jsonWriter.writeEndObject();
    }

    public static KeywordTokenizerV1 fromJson(JsonReader jsonReader) throws IOException {
        return (KeywordTokenizerV1)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            Integer bufferSize = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if ("#Microsoft.Azure.Search.KeywordTokenizer".equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Azure.Search.KeywordTokenizer'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("bufferSize".equals(fieldName)) {
                    bufferSize = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                KeywordTokenizerV1 deserializedKeywordTokenizerV1 = new KeywordTokenizerV1(name);
                deserializedKeywordTokenizerV1.bufferSize = bufferSize;
                return deserializedKeywordTokenizerV1;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

