/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.phoenix.shaded.jline.console.internal;

import com.aliyun.phoenix.shaded.jline.console.ConsoleReader;
import com.aliyun.phoenix.shaded.jline.console.completer.ArgumentCompleter;
import com.aliyun.phoenix.shaded.jline.console.completer.Completer;
import com.aliyun.phoenix.shaded.jline.console.history.FileHistory;
import com.aliyun.phoenix.shaded.jline.console.internal.ConsoleReaderInputStream;
import com.aliyun.phoenix.shaded.jline.internal.Configuration;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;

public class ConsoleRunner {
    public static final String property = "com.aliyun.phoenix.shaded.jline.history";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        List<String> argList = Arrays.asList(args);
        if (argList.size() == 0) {
            ConsoleRunner.usage();
            return;
        }
        String historyFileName = System.getProperty(property, null);
        String mainClass = argList.remove(0);
        ConsoleReader reader = new ConsoleReader();
        if (historyFileName != null) {
            reader.setHistory(new FileHistory(new File(Configuration.getUserHome(), String.format(".com.aliyun.phoenix.shaded.jline-%s.%s.history", mainClass, historyFileName))));
        } else {
            reader.setHistory(new FileHistory(new File(Configuration.getUserHome(), String.format(".com.aliyun.phoenix.shaded.jline-%s.history", mainClass))));
        }
        String completors = System.getProperty(ConsoleRunner.class.getName() + ".completers", "");
        ArrayList<Completer> completorList = new ArrayList<Completer>();
        StringTokenizer tok = new StringTokenizer(completors, ",");
        while (tok.hasMoreTokens()) {
            Object obj = Class.forName(tok.nextToken()).newInstance();
            completorList.add((Completer)obj);
        }
        if (completorList.size() > 0) {
            reader.addCompleter(new ArgumentCompleter(completorList));
        }
        ConsoleReaderInputStream.setIn(reader);
        try {
            Class<?> type = Class.forName(mainClass);
            Method method = type.getMethod("main", String[].class);
            method.invoke(null, new Object[0]);
        }
        finally {
            ConsoleReaderInputStream.restoreIn();
        }
    }

    private static void usage() {
        System.out.println("Usage: \n   java [-Djline.history='name'] " + ConsoleRunner.class.getName() + " <target class name> [args]" + "\n\nThe -Djline.history option will avoid history" + "\nmangling when running ConsoleRunner on the same application." + "\n\nargs will be passed directly to the target class name.");
    }
}

