/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.phoenix.shaded.com.google.common.base;

import com.aliyun.phoenix.shaded.com.google.common.annotations.GwtCompatible;
import com.aliyun.phoenix.shaded.com.google.common.annotations.VisibleForTesting;
import com.aliyun.phoenix.shaded.com.google.common.base.CharMatcher;

@GwtCompatible
final class MediumCharMatcher
extends CharMatcher {
    static final int MAX_SIZE = 1023;
    private final char[] table;
    private final boolean containsZero;
    private final long filter;
    private static final double DESIRED_LOAD_FACTOR = 0.5;

    private MediumCharMatcher(char[] table, long filter, boolean containsZero, String description) {
        super(description);
        this.table = table;
        this.filter = filter;
        this.containsZero = containsZero;
    }

    private boolean checkFilter(int c) {
        return 1L == (1L & this.filter >> c);
    }

    @VisibleForTesting
    static int chooseTableSize(int setSize) {
        if (setSize == 1) {
            return 2;
        }
        int tableSize = Integer.highestOneBit(setSize - 1) << 1;
        while ((double)tableSize * 0.5 < (double)setSize) {
            tableSize <<= 1;
        }
        return tableSize;
    }

    @Override
    public CharMatcher precomputed() {
        return this;
    }

    static CharMatcher from(char[] chars, String description) {
        long filter = 0L;
        int size = chars.length;
        boolean containsZero = chars[0] == '\u0000';
        for (char c : chars) {
            filter |= 1L << c;
        }
        char[] table = new char[MediumCharMatcher.chooseTableSize(size)];
        int mask = table.length - 1;
        for (char c : chars) {
            int index = c & mask;
            while (true) {
                if (table[index] == '\u0000') break;
                index = index + 1 & mask;
            }
            table[index] = c;
        }
        return new MediumCharMatcher(table, filter, containsZero, description);
    }

    @Override
    public boolean matches(char c) {
        int startingIndex;
        if (c == '\u0000') {
            return this.containsZero;
        }
        if (!this.checkFilter(c)) {
            return false;
        }
        int mask = this.table.length - 1;
        int index = startingIndex = c & mask;
        do {
            if (this.table[index] == '\u0000') {
                return false;
            }
            if (this.table[index] != c) continue;
            return true;
        } while ((index = index + 1 & mask) != startingIndex);
        return false;
    }
}

