/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore;

import com.alicloud.openservices.tablestore.AsyncClient;
import com.alicloud.openservices.tablestore.AsyncTimeseriesClient;
import com.alicloud.openservices.tablestore.ClientConfiguration;
import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.InternalClient;
import com.alicloud.openservices.tablestore.SyncClient;
import com.alicloud.openservices.tablestore.TableStoreException;
import com.alicloud.openservices.tablestore.TimeseriesClientInterface;
import com.alicloud.openservices.tablestore.TimeseriesConfiguration;
import com.alicloud.openservices.tablestore.core.ResourceManager;
import com.alicloud.openservices.tablestore.core.auth.CredentialsProvider;
import com.alicloud.openservices.tablestore.core.auth.DefaultCredentialProvider;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.timeseries.CreateTimeseriesAnalyticalStoreRequest;
import com.alicloud.openservices.tablestore.model.timeseries.CreateTimeseriesAnalyticalStoreResponse;
import com.alicloud.openservices.tablestore.model.timeseries.CreateTimeseriesLastpointIndexRequest;
import com.alicloud.openservices.tablestore.model.timeseries.CreateTimeseriesLastpointIndexResponse;
import com.alicloud.openservices.tablestore.model.timeseries.CreateTimeseriesTableRequest;
import com.alicloud.openservices.tablestore.model.timeseries.CreateTimeseriesTableResponse;
import com.alicloud.openservices.tablestore.model.timeseries.DeleteTimeseriesAnalyticalStoreRequest;
import com.alicloud.openservices.tablestore.model.timeseries.DeleteTimeseriesAnalyticalStoreResponse;
import com.alicloud.openservices.tablestore.model.timeseries.DeleteTimeseriesLastpointIndexRequest;
import com.alicloud.openservices.tablestore.model.timeseries.DeleteTimeseriesLastpointIndexResponse;
import com.alicloud.openservices.tablestore.model.timeseries.DeleteTimeseriesMetaRequest;
import com.alicloud.openservices.tablestore.model.timeseries.DeleteTimeseriesMetaResponse;
import com.alicloud.openservices.tablestore.model.timeseries.DeleteTimeseriesTableRequest;
import com.alicloud.openservices.tablestore.model.timeseries.DeleteTimeseriesTableResponse;
import com.alicloud.openservices.tablestore.model.timeseries.DescribeTimeseriesAnalyticalStoreRequest;
import com.alicloud.openservices.tablestore.model.timeseries.DescribeTimeseriesAnalyticalStoreResponse;
import com.alicloud.openservices.tablestore.model.timeseries.DescribeTimeseriesTableRequest;
import com.alicloud.openservices.tablestore.model.timeseries.DescribeTimeseriesTableResponse;
import com.alicloud.openservices.tablestore.model.timeseries.GetTimeseriesDataRequest;
import com.alicloud.openservices.tablestore.model.timeseries.GetTimeseriesDataResponse;
import com.alicloud.openservices.tablestore.model.timeseries.ListTimeseriesTableResponse;
import com.alicloud.openservices.tablestore.model.timeseries.PutTimeseriesDataRequest;
import com.alicloud.openservices.tablestore.model.timeseries.PutTimeseriesDataResponse;
import com.alicloud.openservices.tablestore.model.timeseries.QueryTimeseriesMetaRequest;
import com.alicloud.openservices.tablestore.model.timeseries.QueryTimeseriesMetaResponse;
import com.alicloud.openservices.tablestore.model.timeseries.ScanTimeseriesDataRequest;
import com.alicloud.openservices.tablestore.model.timeseries.ScanTimeseriesDataResponse;
import com.alicloud.openservices.tablestore.model.timeseries.SplitTimeseriesScanTaskRequest;
import com.alicloud.openservices.tablestore.model.timeseries.SplitTimeseriesScanTaskResponse;
import com.alicloud.openservices.tablestore.model.timeseries.UpdateTimeseriesAnalyticalStoreRequest;
import com.alicloud.openservices.tablestore.model.timeseries.UpdateTimeseriesAnalyticalStoreResponse;
import com.alicloud.openservices.tablestore.model.timeseries.UpdateTimeseriesMetaRequest;
import com.alicloud.openservices.tablestore.model.timeseries.UpdateTimeseriesMetaResponse;
import com.alicloud.openservices.tablestore.model.timeseries.UpdateTimeseriesTableRequest;
import com.alicloud.openservices.tablestore.model.timeseries.UpdateTimeseriesTableResponse;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.Weigher;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TimeseriesClient
implements TimeseriesClientInterface {
    private InternalClient internalClient;
    private Cache<String, Long> timeseriesMetaCache;

    public TimeseriesClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName) {
        this(endpoint, accessKeyId, accessKeySecret, instanceName, new ClientConfiguration());
    }

    public TimeseriesClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName, ClientConfiguration conf) {
        this(endpoint, accessKeyId, accessKeySecret, instanceName, conf, null);
    }

    public TimeseriesClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName, String stsToken) {
        this(endpoint, accessKeyId, accessKeySecret, instanceName, new ClientConfiguration(), stsToken);
    }

    public TimeseriesClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName, ClientConfiguration config, String stsToken) {
        this(endpoint, accessKeyId, accessKeySecret, instanceName, config, stsToken, null);
    }

    public TimeseriesClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName, ClientConfiguration config, String stsToken, ExecutorService callbackExecutor) {
        this(endpoint, new DefaultCredentialProvider(accessKeyId, accessKeySecret, stsToken), instanceName, config, new ResourceManager(config, callbackExecutor));
    }

    public TimeseriesClient(String endpoint, CredentialsProvider credsProvider, String instanceName, ClientConfiguration config, ResourceManager resourceManager) {
        this(new InternalClient(endpoint, credsProvider, instanceName, config, resourceManager));
    }

    TimeseriesClient(InternalClient internalClient) {
        Preconditions.checkNotNull(internalClient);
        this.internalClient = internalClient;
        if (this.internalClient.getTimeseriesMetaCache() != null) {
            this.timeseriesMetaCache = this.internalClient.getTimeseriesMetaCache();
            return;
        }
        ClientConfiguration config = this.internalClient.getClientConfig();
        if (config.getTimeseriesConfiguration() == null) {
            config.setTimeseriesConfiguration(new TimeseriesConfiguration());
        }
        this.timeseriesMetaCache = CacheBuilder.newBuilder().maximumWeight(config.getTimeseriesConfiguration().getMetaCacheMaxDataSize()).expireAfterAccess((long)config.getTimeseriesConfiguration().getMetaCacheExpireTimeAfterAccessInSec(), TimeUnit.SECONDS).weigher((Weigher)new Weigher<String, Long>(){

            public int weigh(String key, Long value) {
                return key.length() + 48 + 16;
            }
        }).build();
        this.internalClient.setTimeseriesMetaCache(this.timeseriesMetaCache);
    }

    public void setExtraHeaders(Map<String, String> extraHeaders) {
        this.internalClient.setExtraHeaders(extraHeaders);
    }

    @Override
    public CreateTimeseriesTableResponse createTimeseriesTable(CreateTimeseriesTableRequest request) {
        Future<CreateTimeseriesTableResponse> resp = this.internalClient.createTimeseriesTable(request, null);
        return this.waitForFuture(resp);
    }

    @Override
    public ListTimeseriesTableResponse listTimeseriesTable() {
        Future<ListTimeseriesTableResponse> resp = this.internalClient.listTimeseriesTable(null);
        return this.waitForFuture(resp);
    }

    @Override
    public DeleteTimeseriesTableResponse deleteTimeseriesTable(DeleteTimeseriesTableRequest request) {
        Future<DeleteTimeseriesTableResponse> resp = this.internalClient.deleteTimeseriesTable(request, null);
        return this.waitForFuture(resp);
    }

    @Override
    public DescribeTimeseriesTableResponse describeTimeseriesTable(DescribeTimeseriesTableRequest request) {
        Future<DescribeTimeseriesTableResponse> resp = this.internalClient.describeTimeseriesTable(request, null);
        return this.waitForFuture(resp);
    }

    @Override
    public UpdateTimeseriesTableResponse updateTimeseriesTable(UpdateTimeseriesTableRequest request) {
        Future<UpdateTimeseriesTableResponse> resp = this.internalClient.updateTimeseriesTable(request, null);
        return this.waitForFuture(resp);
    }

    @Override
    public PutTimeseriesDataResponse putTimeseriesData(PutTimeseriesDataRequest request) throws TableStoreException, ClientException {
        Future<PutTimeseriesDataResponse> resp = this.internalClient.putTimeseriesData(request, null);
        return this.waitForFuture(resp);
    }

    @Override
    public GetTimeseriesDataResponse getTimeseriesData(GetTimeseriesDataRequest request) throws TableStoreException, ClientException {
        Future<GetTimeseriesDataResponse> resp = this.internalClient.getTimeseriesData(request, null);
        return this.waitForFuture(resp);
    }

    @Override
    public QueryTimeseriesMetaResponse queryTimeseriesMeta(QueryTimeseriesMetaRequest request) throws TableStoreException, ClientException {
        Future<QueryTimeseriesMetaResponse> resp = this.internalClient.queryTimeseriesMeta(request, null);
        return this.waitForFuture(resp);
    }

    @Override
    public UpdateTimeseriesMetaResponse updateTimeseriesMeta(UpdateTimeseriesMetaRequest request) throws TableStoreException, ClientException {
        Future<UpdateTimeseriesMetaResponse> resp = this.internalClient.updateTimeseriesMeta(request, null);
        return this.waitForFuture(resp);
    }

    @Override
    public DeleteTimeseriesMetaResponse deleteTimeseriesMeta(DeleteTimeseriesMetaRequest request) throws TableStoreException, ClientException {
        Future<DeleteTimeseriesMetaResponse> resp = this.internalClient.deleteTimeseriesMeta(request, null);
        return this.waitForFuture(resp);
    }

    @Override
    public SplitTimeseriesScanTaskResponse splitTimeseriesScanTask(SplitTimeseriesScanTaskRequest request) throws TableStoreException, ClientException {
        Future<SplitTimeseriesScanTaskResponse> resp = this.internalClient.splitTimeseriesScanTask(request, null);
        return this.waitForFuture(resp);
    }

    @Override
    public ScanTimeseriesDataResponse scanTimeseriesData(ScanTimeseriesDataRequest request) throws TableStoreException, ClientException {
        Future<ScanTimeseriesDataResponse> resp = this.internalClient.scanTimeseriesData(request, null);
        return this.waitForFuture(resp);
    }

    @Override
    public CreateTimeseriesAnalyticalStoreResponse createTimeseriesAnalyticalStore(CreateTimeseriesAnalyticalStoreRequest request) throws TableStoreException, ClientException {
        Future<CreateTimeseriesAnalyticalStoreResponse> resp = this.internalClient.createTimeseriesAnalyticalStore(request, null);
        return this.waitForFuture(resp);
    }

    @Override
    public DeleteTimeseriesAnalyticalStoreResponse deleteTimeseriesAnalyticalStore(DeleteTimeseriesAnalyticalStoreRequest request) throws TableStoreException, ClientException {
        Future<DeleteTimeseriesAnalyticalStoreResponse> resp = this.internalClient.deleteTimeseriesAnalyticalStore(request, null);
        return this.waitForFuture(resp);
    }

    @Override
    public DescribeTimeseriesAnalyticalStoreResponse describeTimeseriesAnalyticalStore(DescribeTimeseriesAnalyticalStoreRequest request) throws TableStoreException, ClientException {
        Future<DescribeTimeseriesAnalyticalStoreResponse> resp = this.internalClient.describeTimeseriesAnalyticalStore(request, null);
        return this.waitForFuture(resp);
    }

    @Override
    public UpdateTimeseriesAnalyticalStoreResponse updateTimeseriesAnalyticalStore(UpdateTimeseriesAnalyticalStoreRequest request) throws TableStoreException, ClientException {
        Future<UpdateTimeseriesAnalyticalStoreResponse> resp = this.internalClient.updateTimeseriesAnalyticalStore(request, null);
        return this.waitForFuture(resp);
    }

    @Override
    public CreateTimeseriesLastpointIndexResponse createTimeseriesLastpointIndex(CreateTimeseriesLastpointIndexRequest request) throws TableStoreException, ClientException {
        Future<CreateTimeseriesLastpointIndexResponse> resp = this.internalClient.createTimeseriesLastpointIndex(request, null);
        return this.waitForFuture(resp);
    }

    @Override
    public DeleteTimeseriesLastpointIndexResponse deleteTimeseriesLastpointIndex(DeleteTimeseriesLastpointIndexRequest request) throws TableStoreException, ClientException {
        Future<DeleteTimeseriesLastpointIndexResponse> resp = this.internalClient.deleteTimeseriesLastpointIndex(request, null);
        return this.waitForFuture(resp);
    }

    private <Res> Res waitForFuture(Future<Res> f) {
        try {
            return f.get(this.internalClient.getClientConfig().getSyncClientWaitFutureTimeoutInMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new ClientException(String.format("The thread was interrupted: %s", e.getMessage()));
        }
        catch (ExecutionException e) {
            throw new ClientException("The thread was aborted", e);
        }
        catch (TimeoutException e) {
            throw new ClientException("Wait future timeout", e);
        }
    }

    public void shutdown() {
        this.internalClient.shutdown();
    }

    public SyncClient asSyncClient() {
        return new SyncClient(this.internalClient);
    }

    public AsyncClient asAsyncClient() {
        return new AsyncClient(this.internalClient);
    }

    public AsyncTimeseriesClient asAsyncTimeseriesClient() {
        return new AsyncTimeseriesClient(this.internalClient);
    }
}

