/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.common.statistics;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.statistics.StatisticsBriefInterceptor;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.statistics.StatisticsItem;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.statistics.StatisticsKindMeta;
import com.aliyun.openservices.shade.org.apache.commons.lang3.tuple.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class StatisticsManager {
    private Map<String, StatisticsKindMeta> kindMetaMap;
    private Pair<String, long[][]>[] briefMetas;
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, StatisticsItem>> statsTable = new ConcurrentHashMap();

    public StatisticsManager() {
        this.kindMetaMap = new HashMap<String, StatisticsKindMeta>();
    }

    public StatisticsManager(Map<String, StatisticsKindMeta> kindMeta) {
        this.kindMetaMap = kindMeta;
    }

    public void addStatisticsKindMeta(StatisticsKindMeta kindMeta) {
        this.kindMetaMap.put(kindMeta.getName(), kindMeta);
        this.statsTable.putIfAbsent(kindMeta.getName(), new ConcurrentHashMap(16));
    }

    public void setBriefMeta(Pair<String, long[][]>[] briefMetas) {
        this.briefMetas = briefMetas;
    }

    public boolean inc(String kind, String key, long ... itemAccumulates) {
        ConcurrentHashMap<String, StatisticsItem> itemMap = this.statsTable.get(kind);
        if (itemMap != null) {
            StatisticsItem item = itemMap.get(key);
            if (item == null) {
                item = new StatisticsItem(kind, key, this.kindMetaMap.get(kind).getItemNames());
                item.setInterceptor(new StatisticsBriefInterceptor(item, this.briefMetas));
                StatisticsItem oldItem = itemMap.putIfAbsent(key, item);
                if (oldItem != null) {
                    item = oldItem;
                } else {
                    this.scheduleStatisticsItem(item);
                }
            }
            item.incItems(itemAccumulates);
            return true;
        }
        return false;
    }

    private void scheduleStatisticsItem(StatisticsItem item) {
        this.kindMetaMap.get(item.getStatKind()).getScheduledPrinter().schedule(item);
    }
}

