/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.sample;

import com.aliyun.openservices.log.Client;
import com.aliyun.openservices.log.common.CsvColumn;
import com.aliyun.openservices.log.common.CsvExternalStore;
import com.aliyun.openservices.log.request.CreateCsvExternalStoreRequest;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;

public class CsvExternalStoreExample {
    private static final String endPoint = "";
    private static final String akId = "your_access_id";
    private static final String ak = "your_access_key";
    private static final Client client = new Client("", "your_access_id", "your_access_key");
    private static final String project = "your_project_name";
    private static final String logStore = "your_log_store";
    private static final String externalStoreName = "external_store_name_1";

    public static void main(String[] args) throws Exception {
        byte[] fileContent = CsvExternalStoreExample.readCsvFile("my.csv");
        List<CsvColumn> columns = Arrays.asList(new CsvColumn("Name", CsvColumn.CsvColumnType.VARCHAR), new CsvColumn("age", CsvColumn.CsvColumnType.BIGINT), new CsvColumn("Score", CsvColumn.CsvColumnType.DOUBLE));
        client.createCsvExternalStore(new CreateCsvExternalStoreRequest(project, new CsvExternalStore(externalStoreName, fileContent, columns)));
        String query = "* | select * from external_store_name_1";
        int from = (int)(System.currentTimeMillis() / 1000L) - 1800;
        client.GetLogs(project, logStore, from, from + 1800, endPoint, query);
    }

    private static byte[] readCsvFile(String csvFilePath) throws Exception {
        return Files.readAllBytes(Paths.get(csvFilePath, new String[0]));
    }
}

