/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.tablestore.agent.util;

import com.alicloud.openservices.tablestore.SyncClient;
import com.alicloud.openservices.tablestore.TableStoreException;
import com.alicloud.openservices.tablestore.model.BatchGetRowRequest;
import com.alicloud.openservices.tablestore.model.BatchGetRowResponse;
import com.alicloud.openservices.tablestore.model.BatchWriteRowRequest;
import com.alicloud.openservices.tablestore.model.BatchWriteRowResponse;
import com.alicloud.openservices.tablestore.model.CapacityUnit;
import com.alicloud.openservices.tablestore.model.Column;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.model.CreateIndexRequest;
import com.alicloud.openservices.tablestore.model.CreateTableRequest;
import com.alicloud.openservices.tablestore.model.DefinedColumnSchema;
import com.alicloud.openservices.tablestore.model.DefinedColumnType;
import com.alicloud.openservices.tablestore.model.DeleteTableRequest;
import com.alicloud.openservices.tablestore.model.DescribeTableRequest;
import com.alicloud.openservices.tablestore.model.DescribeTableResponse;
import com.alicloud.openservices.tablestore.model.Direction;
import com.alicloud.openservices.tablestore.model.GetRangeRequest;
import com.alicloud.openservices.tablestore.model.GetRangeResponse;
import com.alicloud.openservices.tablestore.model.IndexMeta;
import com.alicloud.openservices.tablestore.model.IndexType;
import com.alicloud.openservices.tablestore.model.IndexUpdateMode;
import com.alicloud.openservices.tablestore.model.ListTableResponse;
import com.alicloud.openservices.tablestore.model.MultiRowQueryCriteria;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.PrimaryKeyBuilder;
import com.alicloud.openservices.tablestore.model.PrimaryKeyColumn;
import com.alicloud.openservices.tablestore.model.PrimaryKeySchema;
import com.alicloud.openservices.tablestore.model.PrimaryKeyType;
import com.alicloud.openservices.tablestore.model.PrimaryKeyValue;
import com.alicloud.openservices.tablestore.model.RangeRowQueryCriteria;
import com.alicloud.openservices.tablestore.model.ReservedThroughput;
import com.alicloud.openservices.tablestore.model.Row;
import com.alicloud.openservices.tablestore.model.RowChange;
import com.alicloud.openservices.tablestore.model.RowDeleteChange;
import com.alicloud.openservices.tablestore.model.TableMeta;
import com.alicloud.openservices.tablestore.model.TableOptions;
import com.alicloud.openservices.tablestore.model.filter.ColumnValueFilter;
import com.alicloud.openservices.tablestore.model.filter.CompositeColumnValueFilter;
import com.alicloud.openservices.tablestore.model.filter.Filter;
import com.alicloud.openservices.tablestore.model.filter.SingleColumnValueFilter;
import com.alicloud.openservices.tablestore.model.search.CreateSearchIndexRequest;
import com.alicloud.openservices.tablestore.model.search.DeleteSearchIndexRequest;
import com.alicloud.openservices.tablestore.model.search.DescribeSearchIndexRequest;
import com.alicloud.openservices.tablestore.model.search.DescribeSearchIndexResponse;
import com.alicloud.openservices.tablestore.model.search.FieldSchema;
import com.alicloud.openservices.tablestore.model.search.IndexSchema;
import com.alicloud.openservices.tablestore.model.search.IndexSetting;
import com.alicloud.openservices.tablestore.model.search.ListSearchIndexRequest;
import com.alicloud.openservices.tablestore.model.search.ListSearchIndexResponse;
import com.alicloud.openservices.tablestore.model.search.SearchHit;
import com.alicloud.openservices.tablestore.model.search.SearchIndexInfo;
import com.alicloud.openservices.tablestore.model.search.SearchQuery;
import com.alicloud.openservices.tablestore.model.search.SearchRequest;
import com.alicloud.openservices.tablestore.model.search.SearchResponse;
import com.alicloud.openservices.tablestore.model.search.SyncStat;
import com.alicloud.openservices.tablestore.model.search.query.BoolQuery;
import com.alicloud.openservices.tablestore.model.search.query.KnnVectorQuery;
import com.alicloud.openservices.tablestore.model.search.query.Query;
import com.alicloud.openservices.tablestore.model.search.query.QueryBuilder;
import com.alicloud.openservices.tablestore.model.search.query.QueryBuilders;
import com.alicloud.openservices.tablestore.model.search.query.TermsQuery;
import com.alicloud.openservices.tablestore.model.search.sort.FieldSort;
import com.alicloud.openservices.tablestore.model.search.sort.Sort;
import com.alicloud.openservices.tablestore.model.search.sort.SortOrder;
import com.aliyun.openservices.tablestore.agent.model.Document;
import com.aliyun.openservices.tablestore.agent.model.DocumentHit;
import com.aliyun.openservices.tablestore.agent.model.Message;
import com.aliyun.openservices.tablestore.agent.model.MetaType;
import com.aliyun.openservices.tablestore.agent.model.Metadata;
import com.aliyun.openservices.tablestore.agent.model.Session;
import com.aliyun.openservices.tablestore.agent.model.filter.condition.AbstractConditionFilter;
import com.aliyun.openservices.tablestore.agent.model.filter.condition.And;
import com.aliyun.openservices.tablestore.agent.model.filter.condition.Not;
import com.aliyun.openservices.tablestore.agent.model.filter.condition.Or;
import com.aliyun.openservices.tablestore.agent.model.filter.operation.AbstractOperationFilter;
import com.aliyun.openservices.tablestore.agent.model.filter.operation.Eq;
import com.aliyun.openservices.tablestore.agent.model.filter.operation.Exists;
import com.aliyun.openservices.tablestore.agent.model.filter.operation.Gt;
import com.aliyun.openservices.tablestore.agent.model.filter.operation.Gte;
import com.aliyun.openservices.tablestore.agent.model.filter.operation.In;
import com.aliyun.openservices.tablestore.agent.model.filter.operation.Lt;
import com.aliyun.openservices.tablestore.agent.model.filter.operation.Lte;
import com.aliyun.openservices.tablestore.agent.model.filter.operation.NotEq;
import com.aliyun.openservices.tablestore.agent.model.filter.operation.NotIn;
import com.aliyun.openservices.tablestore.agent.model.filter.operation.TextMatch;
import com.aliyun.openservices.tablestore.agent.model.filter.operation.TextMatchPhrase;
import com.aliyun.openservices.tablestore.agent.model.filter.operation.VectorQuery;
import com.aliyun.openservices.tablestore.agent.model.sort.Order;
import com.aliyun.openservices.tablestore.agent.model.sort.ScoreSort;
import com.aliyun.openservices.tablestore.agent.util.Exceptions;
import com.aliyun.openservices.tablestore.agent.util.Pair;
import com.aliyun.openservices.tablestore.agent.util.Reference;
import com.aliyun.openservices.tablestore.agent.util.Triple;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TablestoreHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TablestoreHelper.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static void createTableIfNotExist(SyncClient client, String tableName, List<Pair<String, MetaType>> primaryKeys, List<Pair<String, MetaType>> definedColumns) {
        MetaType type;
        String name;
        ListTableResponse listTableResponse = client.listTable();
        for (Object name2 : listTableResponse.getTableNames()) {
            if (!((String)name2).equals(tableName)) continue;
            log.warn("tablestore table:[{}] already exists", (Object)tableName);
            return;
        }
        TableMeta tableMeta = new TableMeta(tableName);
        block15: for (Pair pair : primaryKeys) {
            name = (String)pair.getKey();
            type = (MetaType)((Object)pair.getValue());
            switch (type) {
                case STRING: {
                    tableMeta.addPrimaryKeyColumn(new PrimaryKeySchema(name, PrimaryKeyType.STRING));
                    continue block15;
                }
                case INTEGER: {
                    tableMeta.addPrimaryKeyColumn(new PrimaryKeySchema(name, PrimaryKeyType.INTEGER));
                    continue block15;
                }
                case BINARY: {
                    tableMeta.addPrimaryKeyColumn(new PrimaryKeySchema(name, PrimaryKeyType.BINARY));
                    continue block15;
                }
            }
            throw Exceptions.illegalArgument("unsupported primary key name:%s type:%s", new Object[]{name, type});
        }
        if (definedColumns != null) {
            block16: for (Pair<String, MetaType> pair : definedColumns) {
                name = pair.getKey();
                type = pair.getValue();
                switch (type) {
                    case STRING: {
                        tableMeta.addDefinedColumn(new DefinedColumnSchema(name, DefinedColumnType.STRING));
                        continue block16;
                    }
                    case INTEGER: {
                        tableMeta.addDefinedColumn(new DefinedColumnSchema(name, DefinedColumnType.INTEGER));
                        continue block16;
                    }
                    case DOUBLE: {
                        tableMeta.addDefinedColumn(new DefinedColumnSchema(name, DefinedColumnType.DOUBLE));
                        continue block16;
                    }
                    case BOOLEAN: {
                        tableMeta.addDefinedColumn(new DefinedColumnSchema(name, DefinedColumnType.BOOLEAN));
                        continue block16;
                    }
                    case BINARY: {
                        tableMeta.addDefinedColumn(new DefinedColumnSchema(name, DefinedColumnType.BINARY));
                        continue block16;
                    }
                }
                throw Exceptions.illegalArgument("unsupported defined column name:%s type:%s", new Object[]{name, type});
            }
        }
        TableOptions tableOptions = new TableOptions(-1, 1);
        CreateTableRequest createTableRequest = new CreateTableRequest(tableMeta, tableOptions);
        createTableRequest.setReservedThroughput(new ReservedThroughput(new CapacityUnit(0, 0)));
        log.info("tablestore create table:[{}] successfully.", (Object)tableName);
        try {
            client.createTable(createTableRequest);
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            throw Exceptions.runtimeThrowable(String.format("tablestore create table:[%s] failed", tableName), e);
        }
    }

    public static void createSecondaryIndexIfNotExist(SyncClient client, String tableName, String secondaryIndexName, List<String> primaryKeyNames, List<String> definedColumnNames, IndexType indexType) {
        IndexMeta indexMeta2;
        DescribeTableResponse describeTableResponse = client.describeTable(new DescribeTableRequest(tableName));
        List indexMetas = describeTableResponse.getIndexMeta();
        for (IndexMeta indexMeta2 : indexMetas) {
            if (!indexMeta2.getIndexName().equals(secondaryIndexName)) continue;
            log.warn("tablestore secondary index:[{}] already exists", (Object)secondaryIndexName);
            return;
        }
        boolean includeBaseData = false;
        indexMeta2 = new IndexMeta(secondaryIndexName);
        indexMeta2.setIndexUpdateMode(IndexType.IT_GLOBAL_INDEX.equals((Object)indexType) ? IndexUpdateMode.IUM_ASYNC_INDEX : IndexUpdateMode.IUM_SYNC_INDEX);
        indexMeta2.setIndexType(indexType);
        for (String primaryKeyName : primaryKeyNames) {
            indexMeta2.addPrimaryKeyColumn(primaryKeyName);
        }
        for (String columnName : definedColumnNames) {
            indexMeta2.addDefinedColumn(columnName);
        }
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(tableName, indexMeta2, includeBaseData);
        client.createIndex(createIndexRequest);
        log.info("tablestore create secondary index:[{}] successfully.", (Object)secondaryIndexName);
    }

    public static void deleteTable(SyncClient client, String tableName) {
        List tableNames = client.listTable().getTableNames();
        if (!tableNames.contains(tableName)) {
            return;
        }
        ListSearchIndexRequest listSearchIndexRequest = new ListSearchIndexRequest();
        listSearchIndexRequest.setTableName(tableName);
        ListSearchIndexResponse listSearchIndexResponse = client.listSearchIndex(listSearchIndexRequest);
        for (SearchIndexInfo indexInfo : listSearchIndexResponse.getIndexInfos()) {
            DeleteSearchIndexRequest deleteSearchIndexRequest = new DeleteSearchIndexRequest();
            deleteSearchIndexRequest.setTableName(indexInfo.getTableName());
            deleteSearchIndexRequest.setIndexName(indexInfo.getIndexName());
            client.deleteSearchIndex(deleteSearchIndexRequest);
            log.info("tablestore delete search index:[{}] successfully.", (Object)indexInfo.getIndexName());
        }
        try {
            DeleteTableRequest request = new DeleteTableRequest(tableName);
            client.deleteTable(request);
        }
        catch (TableStoreException e) {
            if ("OTSObjectNotExist".equals(e.getErrorCode()) && e.getMessage().contains("does not exist")) {
                log.warn("tablestore table:[{}] not found", (Object)tableName);
            }
            throw Exceptions.runtimeThrowable(String.format("tablestore delete table:[%s] failed", tableName), e);
        }
    }

    public static List<Column> metadataToColumns(Metadata metadata) {
        if (metadata == null) {
            return new ArrayList<Column>();
        }
        Map<String, Object> metadataMap = metadata.toMap();
        if (metadataMap == null || metadataMap.isEmpty()) {
            return new ArrayList<Column>();
        }
        ArrayList<Column> columns = new ArrayList<Column>(metadataMap.size());
        for (Map.Entry<String, Object> entry : metadataMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            columns.add(new Column(key, TablestoreHelper.toColumnValue(value)));
        }
        return columns;
    }

    public static ColumnValue toColumnValue(Object value) {
        if (value instanceof Float) {
            return ColumnValue.fromDouble((double)((Float)value).floatValue());
        }
        if (value instanceof Long) {
            return ColumnValue.fromLong((long)((Long)value));
        }
        if (value instanceof Short) {
            return ColumnValue.fromLong((long)((Short)value).shortValue());
        }
        if (value instanceof Integer) {
            return ColumnValue.fromLong((long)((Integer)value).longValue());
        }
        if (value instanceof Double) {
            return ColumnValue.fromDouble((double)((Double)value));
        }
        if (value instanceof String) {
            return ColumnValue.fromString((String)((String)value));
        }
        if (value instanceof Boolean) {
            return ColumnValue.fromBoolean((boolean)((Boolean)value));
        }
        if (value instanceof byte[]) {
            return ColumnValue.fromBinary((byte[])((byte[])value));
        }
        throw Exceptions.illegalArgument("unsupported value[%s] type:[%s]", value, value.getClass());
    }

    public static Session rowToSession(Row row) {
        String sessionId;
        if (row == null) {
            return null;
        }
        PrimaryKey primaryKey = row.getPrimaryKey();
        String userId = primaryKey.getPrimaryKeyColumn(0).getValue().asString();
        Reference<Long> updateTime = new Reference<Long>();
        if (primaryKey.size() == 2) {
            sessionId = primaryKey.getPrimaryKeyColumn(1).getValue().asString();
        } else {
            updateTime.set(primaryKey.getPrimaryKeyColumn(1).getValue().asLong());
            sessionId = primaryKey.getPrimaryKeyColumn(2).getValue().asString();
        }
        Column[] columns = row.getColumns();
        Metadata metadata = TablestoreHelper.columnsToMetadata(columns, column -> {
            String name = column.getName();
            ColumnValue value = column.getValue();
            if ("update_time".equals(name)) {
                updateTime.set(value.asLong());
                return true;
            }
            return false;
        });
        Session session = new Session(userId, sessionId, (Long)updateTime.get());
        session.setMetadata(metadata);
        return session;
    }

    public static Document rowToDocument(Row row, String textField, String embeddingField) {
        if (row == null) {
            return null;
        }
        PrimaryKey primaryKey = row.getPrimaryKey();
        String documentId = primaryKey.getPrimaryKeyColumn(0).getValue().asString();
        String tenantId = primaryKey.getPrimaryKeyColumn(1).getValue().asString();
        Column[] columns = row.getColumns();
        Reference text = new Reference();
        Reference embedding = new Reference();
        Metadata metadata = TablestoreHelper.columnsToMetadata(columns, column -> {
            String name = column.getName();
            ColumnValue value = column.getValue();
            if (textField.equals(name)) {
                text.set(value.asString());
                return true;
            }
            if (embeddingField.equals(name)) {
                embedding.set(TablestoreHelper.decodeEmbedding(value.asString()));
                return true;
            }
            return false;
        });
        Document document = new Document(documentId, tenantId);
        document.setText((String)text.get());
        document.setEmbedding((float[])embedding.get());
        document.setMetadata(metadata);
        return document;
    }

    public static Message rowToMessage(Row row) {
        long createTime;
        String messageId;
        if (row == null) {
            return null;
        }
        PrimaryKey primaryKey = row.getPrimaryKey();
        String sessionId = primaryKey.getPrimaryKeyColumn(0).getValue().asString();
        Reference content = new Reference();
        PrimaryKeyColumn primaryKey1 = primaryKey.getPrimaryKeyColumn(1);
        if (primaryKey1.getValue().getType().equals((Object)PrimaryKeyType.STRING)) {
            messageId = primaryKey1.getValue().asString();
            createTime = primaryKey.getPrimaryKeyColumn(2).getValue().asLong();
        } else {
            createTime = primaryKey1.getValue().asLong();
            messageId = primaryKey.getPrimaryKeyColumn(2).getValue().asString();
        }
        Column[] columns = row.getColumns();
        Metadata metadata = TablestoreHelper.columnsToMetadata(columns, column -> {
            String name = column.getName();
            ColumnValue value = column.getValue();
            if ("content".equals(name)) {
                content.set(value.asString());
                return true;
            }
            return false;
        });
        Message message = new Message(sessionId, messageId, createTime);
        message.setContent((String)content.get());
        message.setMetadata(metadata);
        return message;
    }

    public static Metadata columnsToMetadata(Column[] columns, Function<Column, Boolean> specialColumnConsumer) {
        Metadata metadata = new Metadata();
        block7: for (Column column : columns) {
            if (Boolean.TRUE.equals(specialColumnConsumer.apply(column))) continue;
            String name = column.getName();
            ColumnValue value = column.getValue();
            switch (value.getType()) {
                case DOUBLE: {
                    metadata.put(name, value.asDouble());
                    continue block7;
                }
                case INTEGER: {
                    metadata.put(name, value.asLong());
                    continue block7;
                }
                case STRING: {
                    metadata.put(name, value.asString());
                    continue block7;
                }
                case BINARY: {
                    metadata.put(name, value.asBinary());
                    continue block7;
                }
                case BOOLEAN: {
                    metadata.put(name, value.asBoolean());
                    continue block7;
                }
                default: {
                    throw Exceptions.illegalArgument("unsupported tablestore column name:%s type:%s", name, value.getType());
                }
            }
        }
        return metadata;
    }

    public static <T> void batchDelete(SyncClient client, String tableName, Iterator<T> iterator) {
        ArrayList<RowChange> rowChanges = new ArrayList<RowChange>();
        while (iterator.hasNext()) {
            T item = iterator.next();
            if (item instanceof Session) {
                Session session = (Session)item;
                rowChanges.add((RowChange)new RowDeleteChange(tableName, PrimaryKeyBuilder.createPrimaryKeyBuilder().addPrimaryKeyColumn("user_id", PrimaryKeyValue.fromString((String)session.getUserId())).addPrimaryKeyColumn("session_id", PrimaryKeyValue.fromString((String)session.getSessionId())).build()));
            } else if (item instanceof Message) {
                Message message = (Message)item;
                rowChanges.add((RowChange)new RowDeleteChange(tableName, PrimaryKeyBuilder.createPrimaryKeyBuilder().addPrimaryKeyColumn("session_id", PrimaryKeyValue.fromString((String)message.getSessionId())).addPrimaryKeyColumn("create_time", PrimaryKeyValue.fromLong((long)message.getCreateTime())).addPrimaryKeyColumn("message_id", PrimaryKeyValue.fromString((String)message.getMessageId())).build()));
            } else if (item instanceof Document) {
                Document document = (Document)item;
                rowChanges.add((RowChange)new RowDeleteChange(tableName, PrimaryKeyBuilder.createPrimaryKeyBuilder().addPrimaryKeyColumn("document_id", PrimaryKeyValue.fromString((String)document.getDocumentId())).addPrimaryKeyColumn("tenant_id", PrimaryKeyValue.fromString((String)document.getTenantId())).build()));
            } else if (item instanceof DocumentHit) {
                DocumentHit documentHit = (DocumentHit)item;
                Document document = documentHit.getDocument();
                rowChanges.add((RowChange)new RowDeleteChange(tableName, PrimaryKeyBuilder.createPrimaryKeyBuilder().addPrimaryKeyColumn("document_id", PrimaryKeyValue.fromString((String)document.getDocumentId())).addPrimaryKeyColumn("tenant_id", PrimaryKeyValue.fromString((String)document.getTenantId())).build()));
            } else {
                throw Exceptions.illegalArgument("unsupported item type:%s, detail:%s", item.getClass(), item);
            }
            if (rowChanges.size() != 200) continue;
            TablestoreHelper.batchWrite(client, rowChanges);
            rowChanges.clear();
        }
        if (!rowChanges.isEmpty()) {
            TablestoreHelper.batchWrite(client, rowChanges);
        }
    }

    public static void batchWrite(SyncClient client, List<RowChange> rowChanges) {
        BatchWriteRowRequest batchWriteRowRequest = new BatchWriteRowRequest();
        for (RowChange rowChange : rowChanges) {
            batchWriteRowRequest.addRowChange(rowChange);
        }
        ArrayList<String> errorDetails = new ArrayList<String>();
        try {
            BatchWriteRowResponse batchWriteRowResponse = client.batchWriteRow(batchWriteRowRequest);
            if (!batchWriteRowResponse.isAllSucceed()) {
                for (BatchWriteRowResponse.RowResult rowResult : batchWriteRowResponse.getFailedRows()) {
                    PrimaryKey primaryKey = batchWriteRowRequest.getRowChange(rowResult.getTableName(), rowResult.getIndex()).getPrimaryKey();
                    errorDetails.add(String.format("failed pk:[%s], failed msg:[%s]", primaryKey.jsonize(), rowResult.getError().getMessage()));
                }
                throw Exceptions.runtime(String.format("batch write failed, error details:%s", errorDetails), new Object[0]);
            }
        }
        catch (Exception e) {
            throw Exceptions.runtimeThrowable("batch write failed", e);
        }
    }

    public static <T> List<T> batchGetRow(SyncClient client, String tableName, List<PrimaryKey> primaryKeys, Function<Row, T> translateFunction) {
        MultiRowQueryCriteria multiRowQueryCriteria = new MultiRowQueryCriteria(tableName);
        for (PrimaryKey rowChange : primaryKeys) {
            multiRowQueryCriteria.addRow(rowChange);
        }
        multiRowQueryCriteria.setMaxVersions(1);
        ArrayList<String> errorDetails = new ArrayList<String>();
        try {
            BatchGetRowRequest batchGetRowRequest = new BatchGetRowRequest();
            batchGetRowRequest.addMultiRowQueryCriteria(multiRowQueryCriteria);
            BatchGetRowResponse batchGetRowResponse = client.batchGetRow(batchGetRowRequest);
            if (!batchGetRowResponse.isAllSucceed()) {
                for (BatchGetRowResponse.RowResult rowResult : batchGetRowResponse.getFailedRows()) {
                    PrimaryKey primaryKey = batchGetRowRequest.getPrimaryKey(rowResult.getTableName(), rowResult.getIndex());
                    errorDetails.add(String.format("failed pk:[%s], failed msg:[%s]", primaryKey.jsonize(), rowResult.getError().getMessage()));
                }
                throw Exceptions.runtime(String.format("batch get row failed, error details:%s", errorDetails), new Object[0]);
            }
            return batchGetRowResponse.getSucceedRows().stream().map(r -> translateFunction.apply(r.getRow())).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw Exceptions.runtimeThrowable("batch get row failed", e);
        }
    }

    public static ColumnValueFilter parserTableFilters(com.aliyun.openservices.tablestore.agent.model.filter.Filter metadataFilter) {
        if (metadataFilter == null) {
            return null;
        }
        if (metadataFilter instanceof AbstractConditionFilter) {
            if (metadataFilter instanceof And) {
                CompositeColumnValueFilter compositeColumnValueFilter = new CompositeColumnValueFilter(CompositeColumnValueFilter.LogicOperator.AND);
                for (com.aliyun.openservices.tablestore.agent.model.filter.Filter filter : ((And)metadataFilter).getFilters()) {
                    compositeColumnValueFilter.addFilter(TablestoreHelper.parserTableFilters(filter));
                }
                return compositeColumnValueFilter;
            }
            if (metadataFilter instanceof Or) {
                CompositeColumnValueFilter compositeColumnValueFilter = new CompositeColumnValueFilter(CompositeColumnValueFilter.LogicOperator.OR);
                for (com.aliyun.openservices.tablestore.agent.model.filter.Filter filter : ((Or)metadataFilter).getFilters()) {
                    compositeColumnValueFilter.addFilter(TablestoreHelper.parserTableFilters(filter));
                }
                return compositeColumnValueFilter;
            }
            if (metadataFilter instanceof Not) {
                CompositeColumnValueFilter compositeColumnValueFilter = new CompositeColumnValueFilter(CompositeColumnValueFilter.LogicOperator.NOT);
                for (com.aliyun.openservices.tablestore.agent.model.filter.Filter filter : ((Not)metadataFilter).getFilters()) {
                    compositeColumnValueFilter.addFilter(TablestoreHelper.parserTableFilters(filter));
                }
                return compositeColumnValueFilter;
            }
            throw Exceptions.illegalArgument("unsupported filter type:%s, filter:%s", metadataFilter.getClass(), metadataFilter);
        }
        if (metadataFilter instanceof AbstractOperationFilter) {
            return TablestoreHelper.parseTableFilter((AbstractOperationFilter)metadataFilter);
        }
        throw Exceptions.illegalArgument("unsupported filter type:%s, filter:%s", metadataFilter.getClass(), metadataFilter);
    }

    public static SingleColumnValueFilter parseTableFilter(AbstractOperationFilter metadataFilter) {
        if (metadataFilter instanceof Eq) {
            Eq eq = (Eq)metadataFilter;
            return new SingleColumnValueFilter(eq.getKey(), SingleColumnValueFilter.CompareOperator.EQUAL, TablestoreHelper.toColumnValue(eq.getValue()));
        }
        if (metadataFilter instanceof Gt) {
            Gt gt = (Gt)metadataFilter;
            return new SingleColumnValueFilter(gt.getKey(), SingleColumnValueFilter.CompareOperator.GREATER_THAN, TablestoreHelper.toColumnValue(gt.getValue()));
        }
        if (metadataFilter instanceof Gte) {
            Gte gte = (Gte)metadataFilter;
            return new SingleColumnValueFilter(gte.getKey(), SingleColumnValueFilter.CompareOperator.GREATER_EQUAL, TablestoreHelper.toColumnValue(gte.getValue()));
        }
        if (metadataFilter instanceof Lt) {
            Lt lt = (Lt)metadataFilter;
            return new SingleColumnValueFilter(lt.getKey(), SingleColumnValueFilter.CompareOperator.LESS_THAN, TablestoreHelper.toColumnValue(lt.getValue()));
        }
        if (metadataFilter instanceof Lte) {
            Lte lte = (Lte)metadataFilter;
            return new SingleColumnValueFilter(lte.getKey(), SingleColumnValueFilter.CompareOperator.LESS_EQUAL, TablestoreHelper.toColumnValue(lte.getValue()));
        }
        if (metadataFilter instanceof NotEq) {
            NotEq notEq = (NotEq)metadataFilter;
            return new SingleColumnValueFilter(notEq.getKey(), SingleColumnValueFilter.CompareOperator.NOT_EQUAL, TablestoreHelper.toColumnValue(notEq.getValue()));
        }
        throw Exceptions.illegalArgument("unsupported filter type:%s, filter:%s", metadataFilter.getClass(), metadataFilter);
    }

    public static Query parserSearchFilters(com.aliyun.openservices.tablestore.agent.model.filter.Filter metadataFilter) {
        if (metadataFilter == null) {
            return QueryBuilders.matchAll().build();
        }
        if (metadataFilter instanceof AbstractConditionFilter) {
            if (metadataFilter instanceof And) {
                BoolQuery.Builder bool = QueryBuilders.bool();
                for (com.aliyun.openservices.tablestore.agent.model.filter.Filter filter : ((And)metadataFilter).getFilters()) {
                    bool.must(TablestoreHelper.parserSearchFilters(filter));
                }
                return bool.build();
            }
            if (metadataFilter instanceof Or) {
                BoolQuery.Builder bool = QueryBuilders.bool();
                for (com.aliyun.openservices.tablestore.agent.model.filter.Filter filter : ((Or)metadataFilter).getFilters()) {
                    bool.should(TablestoreHelper.parserSearchFilters(filter));
                }
                return bool.build();
            }
            if (metadataFilter instanceof Not) {
                BoolQuery.Builder bool = QueryBuilders.bool();
                for (com.aliyun.openservices.tablestore.agent.model.filter.Filter filter : ((Not)metadataFilter).getFilters()) {
                    bool.mustNot(TablestoreHelper.parserSearchFilters(filter));
                }
                return bool.build();
            }
            throw Exceptions.illegalArgument("unsupported filter type:%s, filter:%s", metadataFilter.getClass(), metadataFilter);
        }
        if (metadataFilter instanceof AbstractOperationFilter) {
            return TablestoreHelper.parseSearchFilter((AbstractOperationFilter)metadataFilter);
        }
        throw Exceptions.illegalArgument("unsupported filter type:%s, filter:%s", metadataFilter.getClass(), metadataFilter);
    }

    public static Query parseSearchFilter(AbstractOperationFilter metadataFilter) {
        if (metadataFilter instanceof Eq) {
            Eq eq = (Eq)metadataFilter;
            return QueryBuilders.term((String)eq.getKey(), (Object)eq.getValue()).build();
        }
        if (metadataFilter instanceof Exists) {
            Exists op = (Exists)metadataFilter;
            return QueryBuilders.exists((String)op.getKey()).build();
        }
        if (metadataFilter instanceof Gt) {
            Gt gt = (Gt)metadataFilter;
            return QueryBuilders.range((String)gt.getKey()).greaterThan(gt.getValue()).build();
        }
        if (metadataFilter instanceof Gte) {
            Gte gte = (Gte)metadataFilter;
            return QueryBuilders.range((String)gte.getKey()).greaterThanOrEqual(gte.getValue()).build();
        }
        if (metadataFilter instanceof In) {
            In in = (In)metadataFilter;
            TermsQuery.Builder terms = QueryBuilders.terms((String)in.getKey());
            for (Object value : in.getValues()) {
                terms.addTerm(value);
            }
            return terms.build();
        }
        if (metadataFilter instanceof Lt) {
            Lt lt = (Lt)metadataFilter;
            return QueryBuilders.range((String)lt.getKey()).lessThan(lt.getValue()).build();
        }
        if (metadataFilter instanceof Lte) {
            Lte lte = (Lte)metadataFilter;
            return QueryBuilders.range((String)lte.getKey()).lessThanOrEqual(lte.getValue()).build();
        }
        if (metadataFilter instanceof NotEq) {
            NotEq notEq = (NotEq)metadataFilter;
            return QueryBuilders.bool().mustNot((Query)QueryBuilders.term((String)notEq.getKey(), (Object)notEq.getValue()).build()).build();
        }
        if (metadataFilter instanceof NotIn) {
            NotIn notIn = (NotIn)metadataFilter;
            TermsQuery.Builder terms = QueryBuilders.terms((String)notIn.getKey());
            for (Object value : notIn.getValues()) {
                terms.addTerm(value);
            }
            return QueryBuilders.bool().mustNot((Query)terms.build()).build();
        }
        if (metadataFilter instanceof TextMatch) {
            TextMatch match = (TextMatch)metadataFilter;
            return QueryBuilders.match((String)match.getKey(), (String)match.getValue()).build();
        }
        if (metadataFilter instanceof TextMatchPhrase) {
            TextMatchPhrase matchPhrase = (TextMatchPhrase)metadataFilter;
            return QueryBuilders.matchPhrase((String)matchPhrase.getKey(), (String)matchPhrase.getValue()).build();
        }
        if (metadataFilter instanceof VectorQuery) {
            VectorQuery vectorQuery = (VectorQuery)metadataFilter;
            KnnVectorQuery.Builder builder = QueryBuilders.knnVector((String)vectorQuery.getKey(), (int)vectorQuery.getTopK(), (float[])vectorQuery.getQueryVector());
            if (vectorQuery.getFilter() != null) {
                builder.filter(TablestoreHelper.parserSearchFilters(vectorQuery.getFilter()));
            }
            if (vectorQuery.getMinScore() != null) {
                builder.minScore(vectorQuery.getMinScore());
            }
            return builder.build();
        }
        throw Exceptions.illegalArgument("unsupported filter type:%s, filter:%s", metadataFilter.getClass(), metadataFilter);
    }

    public static String encodeNextPrimaryKeyToken(PrimaryKey nextPrimaryKey) {
        ArrayList<List<Object>> primaryKeys = new ArrayList<List<Object>>();
        for (PrimaryKeyColumn primaryKeyColumn : nextPrimaryKey.getPrimaryKeyColumns()) {
            PrimaryKeyValue columnValue = primaryKeyColumn.getValue();
            Object object = null;
            switch (columnValue.getType()) {
                case INTEGER: {
                    object = columnValue.asLong();
                    break;
                }
                case STRING: {
                    object = columnValue.asString();
                    break;
                }
                default: {
                    throw Exceptions.illegalArgument("unsupported tablestore primaryKeyValue type:%s, value:%s", columnValue.getType(), columnValue.toString());
                }
            }
            primaryKeys.add(Arrays.asList(primaryKeyColumn.getName(), object));
        }
        try {
            String sourceToken = MAPPER.writeValueAsString(primaryKeys);
            return Base64.getEncoder().encodeToString(sourceToken.getBytes(StandardCharsets.UTF_8));
        }
        catch (JsonProcessingException e) {
            throw Exceptions.runtimeThrowable(String.format("encode nextPrimaryKey token failed, primaryKey:%s", nextPrimaryKey), e);
        }
    }

    public static PrimaryKey decodeNextPrimaryKeyToken(String nextPrimaryKeyToken) {
        List primaryKeys;
        byte[] decodeBytes = Base64.getDecoder().decode(nextPrimaryKeyToken);
        String sourceToken = new String(decodeBytes, StandardCharsets.UTF_8);
        try {
            primaryKeys = (List)MAPPER.readValue(sourceToken, (TypeReference)new TypeReference<List<List<Object>>>(){});
        }
        catch (Exception e) {
            throw Exceptions.runtimeThrowable(String.format("decode nextPrimaryKey token failed, token:%s", nextPrimaryKeyToken), e);
        }
        PrimaryKeyBuilder primaryKeyBuilder = PrimaryKeyBuilder.createPrimaryKeyBuilder();
        for (List primaryKeyList : primaryKeys) {
            if (primaryKeyList.size() != 2) {
                throw Exceptions.illegalArgument("invalid primaryKey size:%s, primaryKey:%s", primaryKeyList.size(), primaryKeyList);
            }
            String name = (String)primaryKeyList.get(0);
            Object object = primaryKeyList.get(1);
            if (object instanceof String) {
                primaryKeyBuilder.addPrimaryKeyColumn(name, PrimaryKeyValue.fromString((String)object.toString()));
                continue;
            }
            if (object instanceof Number) {
                primaryKeyBuilder.addPrimaryKeyColumn(name, PrimaryKeyValue.fromLong((long)((Number)object).longValue()));
                continue;
            }
            throw Exceptions.illegalArgument("unsupported primaryKeyValue type:%s, value:%s", object.getClass(), object);
        }
        return primaryKeyBuilder.build();
    }

    public static void addSchemaIfNotExist(List<FieldSchema> schemas, FieldSchema newSchema) {
        if (schemas == null) {
            return;
        }
        for (FieldSchema schema : schemas) {
            if (!schema.getFieldName().equals(newSchema.getFieldName())) continue;
            return;
        }
        schemas.add(newSchema);
    }

    public static void createSearchIndexIfNotExist(SyncClient client, String tableName, String searchIndexName, List<FieldSchema> schemas, List<String> routingFields) {
        ListSearchIndexRequest listSearchIndexRequest = new ListSearchIndexRequest();
        listSearchIndexRequest.setTableName(tableName);
        ListSearchIndexResponse listSearchIndexResponse = client.listSearchIndex(listSearchIndexRequest);
        for (SearchIndexInfo indexInfo : listSearchIndexResponse.getIndexInfos()) {
            if (!indexInfo.getIndexName().equals(searchIndexName)) continue;
            log.warn("search index already exist, tableName:{}, searchIndexName:{}", (Object)tableName, (Object)searchIndexName);
            return;
        }
        CreateSearchIndexRequest request = new CreateSearchIndexRequest();
        request.setTableName(tableName);
        request.setIndexName(searchIndexName);
        IndexSchema indexSchema = new IndexSchema();
        indexSchema.setFieldSchemas(schemas);
        if (routingFields != null && !routingFields.isEmpty()) {
            IndexSetting indexSetting = new IndexSetting();
            indexSetting.setRoutingFields(routingFields);
            indexSchema.setIndexSetting(indexSetting);
        }
        request.setIndexSchema(indexSchema);
        client.createSearchIndex(request);
        log.info("create search index:{}, tableName:{}", (Object)searchIndexName, (Object)tableName);
    }

    public static Sort toOtsSort(List<com.aliyun.openservices.tablestore.agent.model.sort.Sort> sorts) {
        if (sorts == null || sorts.isEmpty()) {
            return null;
        }
        ArrayList<Object> sorters = new ArrayList<Object>();
        for (com.aliyun.openservices.tablestore.agent.model.sort.Sort sort : sorts) {
            if (sort instanceof com.aliyun.openservices.tablestore.agent.model.sort.FieldSort) {
                com.aliyun.openservices.tablestore.agent.model.sort.FieldSort fieldSort = (com.aliyun.openservices.tablestore.agent.model.sort.FieldSort)sort;
                sorters.add(new FieldSort(fieldSort.getField(), fieldSort.getOrder().equals((Object)Order.ASC) ? SortOrder.ASC : SortOrder.DESC));
                continue;
            }
            if (sort instanceof ScoreSort) {
                ScoreSort s = (ScoreSort)sort;
                SortOrder order = s.getOrder().equals((Object)Order.ASC) ? SortOrder.ASC : SortOrder.DESC;
                com.alicloud.openservices.tablestore.model.search.sort.ScoreSort scoreSort = new com.alicloud.openservices.tablestore.model.search.sort.ScoreSort();
                scoreSort.setOrder(order);
                sorters.add(scoreSort);
                continue;
            }
            throw Exceptions.illegalArgument("unsupported sorter type:%s, sorter:%s", sort.getClass(), sort);
        }
        return new Sort(sorters);
    }

    public static List<Document> batchGetDocuments(SyncClient client, String tableName, List<PrimaryKey> pkList, String textField, String embeddingField) {
        ArrayList<Document> documents = new ArrayList<Document>(pkList.size());
        int batchSize = 100;
        int total = pkList.size();
        for (int start = 0; start < total; start += batchSize) {
            int end = Math.min(start + batchSize, total);
            List<PrimaryKey> currentBatch = pkList.subList(start, end);
            List<Document> processed = TablestoreHelper.batchGetRow(client, tableName, currentBatch, r -> TablestoreHelper.rowToDocument(r, textField, embeddingField));
            documents.addAll(processed);
        }
        return documents;
    }

    public static <T> Triple<List<T>, String, List<Double>> parserSearchResponse(SearchResponse searchResponse, Function<Row, T> rowToInstance) {
        ArrayList<T> list = new ArrayList<T>();
        ArrayList<Double> scores = new ArrayList<Double>();
        String nextToken = null;
        if (searchResponse.getNextToken() != null) {
            nextToken = Base64.getEncoder().encodeToString(searchResponse.getNextToken());
        }
        for (SearchHit searchHit : searchResponse.getSearchHits()) {
            Row row = searchHit.getRow();
            T instance = rowToInstance.apply(row);
            list.add(instance);
            scores.add(searchHit.getScore());
        }
        return Triple.of(list, nextToken, scores);
    }

    public static String encodeEmbedding(float[] embedding) {
        try {
            return MAPPER.writeValueAsString((Object)embedding);
        }
        catch (JsonProcessingException e) {
            throw Exceptions.runtimeThrowable(String.format("encode embedding failed, embedding:%s", Arrays.toString(embedding)), e);
        }
    }

    public static float[] decodeEmbedding(String embedding) {
        try {
            return (float[])MAPPER.readValue(embedding, float[].class);
        }
        catch (JsonProcessingException e) {
            throw Exceptions.runtimeThrowable(String.format("decode embedding failed, embedding:%s", embedding), e);
        }
    }

    public static void waitSearchIndexReady(SyncClient client, String tableName, String indexName, int totalCount) {
        long maxWaitTime = 3000000000000L;
        long startTime = System.nanoTime();
        while (System.nanoTime() - startTime < maxWaitTime) {
            SearchRequest searchRequest = SearchRequest.newBuilder().tableName(tableName).indexName(indexName).searchQuery(SearchQuery.newBuilder().query((QueryBuilder)QueryBuilders.matchAll()).limit(0).getTotalCount(true).build()).build();
            SearchResponse searchResponse = client.search(searchRequest);
            if (searchResponse.getTotalCount() == (long)totalCount) {
                log.info("search index ready, use: {}s", (Object)((System.nanoTime() - startTime) / 1000000000L));
                return;
            }
            try {
                Thread.sleep(800L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        throw Exceptions.runtime("search index not ready", new Object[0]);
    }

    public static void waitSearchIndexIncPhrase(SyncClient client, String tableName, String indexName) {
        long maxWaitTime = 3000000000000L;
        long startTime = System.nanoTime();
        while (System.nanoTime() - startTime < maxWaitTime) {
            DescribeSearchIndexRequest request = new DescribeSearchIndexRequest();
            request.setTableName(tableName);
            request.setIndexName(indexName);
            DescribeSearchIndexResponse searchResponse = client.describeSearchIndex(request);
            SyncStat syncStat = searchResponse.getSyncStat();
            if (syncStat.getSyncPhase().equals((Object)SyncStat.SyncPhase.INCR) && Math.abs(syncStat.getCurrentSyncTimestamp() / 1000L / 1000L - System.currentTimeMillis()) <= 10000L) {
                log.info("search index inc phrase ready, use: {}s", (Object)((System.nanoTime() - startTime) / 1000000000L));
                return;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        throw Exceptions.runtime("search index not ready", new Object[0]);
    }

    public static String maxOrNull(String str, int max, String end) {
        if (str == null) {
            return null;
        }
        if (str.length() <= max) {
            return str;
        }
        return str.substring(0, max) + "......" + end;
    }

    public static class GetRangeIterator<E>
    implements Iterator<E> {
        private final SyncClient client;
        private final String tableName;
        private final Function<Row, E> translateFunction;
        private PrimaryKey inclusiveStartPrimaryKey;
        private final PrimaryKey exclusiveEndPrimaryKey;
        private final ColumnValueFilter metadataFilter;
        private final Direction direction;
        private final long iteratorMaxCount;
        private final int batchSize;
        private final List<String> columnToGet;
        private long count;
        private LinkedList<Row> rowsBufferList;

        public GetRangeIterator(SyncClient client, String tableName, Function<Row, E> translateFunction, PrimaryKey inclusiveStartPrimaryKey, PrimaryKey exclusiveEndPrimaryKey, com.aliyun.openservices.tablestore.agent.model.filter.Filter metadataFilter, Order order, Long iteratorMaxCount, Integer batchSize, List<String> columnToGet) {
            this.client = client;
            this.tableName = tableName;
            this.translateFunction = translateFunction;
            this.inclusiveStartPrimaryKey = inclusiveStartPrimaryKey;
            this.exclusiveEndPrimaryKey = exclusiveEndPrimaryKey;
            this.metadataFilter = TablestoreHelper.parserTableFilters(metadataFilter);
            this.direction = Order.DESC.equals((Object)order) ? Direction.BACKWARD : Direction.FORWARD;
            this.iteratorMaxCount = iteratorMaxCount == null ? -1L : iteratorMaxCount;
            this.batchSize = GetRangeIterator.configBatchSize(batchSize, iteratorMaxCount, metadataFilter);
            this.columnToGet = columnToGet == null ? new ArrayList() : columnToGet;
            this.count = 0L;
            this.rowsBufferList = new LinkedList();
            this.fetchNextBatch();
        }

        private static int configBatchSize(Integer batchSize, Long iteratorMaxCount, com.aliyun.openservices.tablestore.agent.model.filter.Filter metadataFilter) {
            if ((batchSize == null || batchSize == -1) && iteratorMaxCount != null && iteratorMaxCount > 0L) {
                if (metadataFilter == null) {
                    return Math.max(Math.min(5000, iteratorMaxCount.intValue()), 1);
                }
                return Math.max(Math.min(5000, (int)((double)iteratorMaxCount.intValue() * 1.3)), 1);
            }
            return batchSize == null || batchSize <= 0 ? 5000 : batchSize;
        }

        @Override
        public boolean hasNext() {
            if (this.iteratorMaxCount > 0L && this.count >= this.iteratorMaxCount) {
                return false;
            }
            if (this.bufferHasData()) {
                return true;
            }
            if (this.hasNextBatch()) {
                this.fetchNextBatch();
            }
            return this.bufferHasData();
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Row row = this.rowsBufferList.pop();
            ++this.count;
            return this.translateFunction.apply(row);
        }

        private void fetchNextBatch() {
            RangeRowQueryCriteria rangeRowQueryCriteria = new RangeRowQueryCriteria(this.tableName);
            rangeRowQueryCriteria.setInclusiveStartPrimaryKey(this.inclusiveStartPrimaryKey);
            rangeRowQueryCriteria.setExclusiveEndPrimaryKey(this.exclusiveEndPrimaryKey);
            rangeRowQueryCriteria.setMaxVersions(1);
            rangeRowQueryCriteria.setLimit(this.batchSize);
            rangeRowQueryCriteria.setDirection(this.direction);
            rangeRowQueryCriteria.addColumnsToGet(this.columnToGet);
            if (this.metadataFilter != null) {
                rangeRowQueryCriteria.setFilter((Filter)this.metadataFilter);
            }
            GetRangeRequest getRangeRequest = new GetRangeRequest(rangeRowQueryCriteria);
            GetRangeResponse rangeResponse = this.client.getRange(getRangeRequest);
            this.inclusiveStartPrimaryKey = rangeResponse.getNextStartPrimaryKey();
            this.rowsBufferList = new LinkedList(rangeResponse.getRows());
        }

        private boolean bufferHasData() {
            return !this.rowsBufferList.isEmpty();
        }

        private boolean hasNextBatch() {
            return this.inclusiveStartPrimaryKey != null;
        }

        public PrimaryKey nextStartPrimaryKey() {
            if (this.rowsBufferList != null && !this.rowsBufferList.isEmpty()) {
                return this.rowsBufferList.peek().getPrimaryKey();
            }
            return this.inclusiveStartPrimaryKey;
        }
    }
}

