/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.tablestore.agent.model.filter.operation;

import com.aliyun.openservices.tablestore.agent.model.filter.Filter;
import com.aliyun.openservices.tablestore.agent.model.filter.operation.AbstractOperationFilter;
import com.aliyun.openservices.tablestore.agent.util.TablestoreHelper;
import java.util.Arrays;
import lombok.Generated;

public class VectorQuery
implements AbstractOperationFilter {
    private final String key;
    private final float[] queryVector;
    private int topK;
    private Filter filter;
    private Float minScore;

    public VectorQuery(String key, float[] queryVector) {
        this.key = key;
        this.queryVector = queryVector;
        this.topK = 20;
    }

    private String shortQueryVector() {
        return TablestoreHelper.maxOrNull(this.queryVector == null ? null : TablestoreHelper.encodeEmbedding(this.queryVector), 80, "]");
    }

    @Generated
    protected VectorQuery(VectorQueryBuilder<?, ?> b) {
        this.key = ((VectorQueryBuilder)b).key;
        this.queryVector = ((VectorQueryBuilder)b).queryVector;
        this.topK = ((VectorQueryBuilder)b).topK;
        this.filter = ((VectorQueryBuilder)b).filter;
        this.minScore = ((VectorQueryBuilder)b).minScore;
    }

    @Generated
    public static VectorQueryBuilder<?, ?> builder() {
        return new VectorQueryBuilderImpl();
    }

    @Generated
    public VectorQueryBuilder<?, ?> toBuilder() {
        return new VectorQueryBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public float[] getQueryVector() {
        return this.queryVector;
    }

    @Generated
    public int getTopK() {
        return this.topK;
    }

    @Generated
    public Filter getFilter() {
        return this.filter;
    }

    @Generated
    public Float getMinScore() {
        return this.minScore;
    }

    @Generated
    public VectorQuery setTopK(int topK) {
        this.topK = topK;
        return this;
    }

    @Generated
    public VectorQuery setFilter(Filter filter) {
        this.filter = filter;
        return this;
    }

    @Generated
    public VectorQuery setMinScore(Float minScore) {
        this.minScore = minScore;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VectorQuery)) {
            return false;
        }
        VectorQuery other = (VectorQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTopK() != other.getTopK()) {
            return false;
        }
        Float this$minScore = this.getMinScore();
        Float other$minScore = other.getMinScore();
        if (this$minScore == null ? other$minScore != null : !((Object)this$minScore).equals(other$minScore)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        if (!Arrays.equals(this.getQueryVector(), other.getQueryVector())) {
            return false;
        }
        Filter this$filter = this.getFilter();
        Filter other$filter = other.getFilter();
        return !(this$filter == null ? other$filter != null : !this$filter.equals(other$filter));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof VectorQuery;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTopK();
        Float $minScore = this.getMinScore();
        result = result * 59 + ($minScore == null ? 43 : ((Object)$minScore).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        result = result * 59 + Arrays.hashCode(this.getQueryVector());
        Filter $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : $filter.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "VectorQuery(key=" + this.getKey() + ", topK=" + this.getTopK() + ", filter=" + this.getFilter() + ", minScore=" + this.getMinScore() + ", queryVector=" + this.shortQueryVector() + ")";
    }

    @Generated
    private static final class VectorQueryBuilderImpl
    extends VectorQueryBuilder<VectorQuery, VectorQueryBuilderImpl> {
        @Generated
        private VectorQueryBuilderImpl() {
        }

        @Override
        @Generated
        protected VectorQueryBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public VectorQuery build() {
            return new VectorQuery(this);
        }
    }

    @Generated
    public static abstract class VectorQueryBuilder<C extends VectorQuery, B extends VectorQueryBuilder<C, B>> {
        @Generated
        private String key;
        @Generated
        private float[] queryVector;
        @Generated
        private int topK;
        @Generated
        private Filter filter;
        @Generated
        private Float minScore;

        @Generated
        protected B $fillValuesFrom(C instance) {
            VectorQueryBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(VectorQuery instance, VectorQueryBuilder<?, ?> b) {
            b.key(instance.key);
            b.queryVector(instance.queryVector);
            b.topK(instance.topK);
            b.filter(instance.filter);
            b.minScore(instance.minScore);
        }

        @Generated
        public B key(String key) {
            this.key = key;
            return this.self();
        }

        @Generated
        public B queryVector(float[] queryVector) {
            this.queryVector = queryVector;
            return this.self();
        }

        @Generated
        public B topK(int topK) {
            this.topK = topK;
            return this.self();
        }

        @Generated
        public B filter(Filter filter) {
            this.filter = filter;
            return this.self();
        }

        @Generated
        public B minScore(Float minScore) {
            this.minScore = minScore;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "VectorQuery.VectorQueryBuilder(key=" + this.key + ", queryVector=" + Arrays.toString(this.queryVector) + ", topK=" + this.topK + ", filter=" + this.filter + ", minScore=" + this.minScore + ")";
        }
    }
}

