/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.tablestore.agent.model;

import com.aliyun.openservices.tablestore.agent.model.Metadata;
import com.aliyun.openservices.tablestore.agent.util.TimeUtils;
import lombok.Generated;

public class Session {
    private final String userId;
    private final String sessionId;
    private Long updateTime;
    private Metadata metadata;
    public static final String SESSION_USER_ID = "user_id";
    public static final String SESSION_SESSION_ID = "session_id";
    public static final String SESSION_UPDATE_TIME = "update_time";

    public Session(Session session) {
        this(session.getUserId(), session.getSessionId(), session.getUpdateTime(), session.getMetadata());
    }

    public Session(String userId, String sessionId) {
        this(userId, sessionId, TimeUtils.currentTimeMicroseconds());
    }

    public Session(String userId, String sessionId, Long updateTime) {
        this(userId, sessionId, updateTime, new Metadata());
    }

    public Session(String userId, String sessionId, Long updateTime, Metadata metadata) {
        this.userId = userId;
        this.sessionId = sessionId;
        this.updateTime = updateTime;
        this.metadata = metadata;
    }

    public void refreshUpdateTime() {
        this.updateTime = TimeUtils.currentTimeMicroseconds();
    }

    @Generated
    protected Session(SessionBuilder<?, ?> b) {
        this.userId = ((SessionBuilder)b).userId;
        this.sessionId = ((SessionBuilder)b).sessionId;
        this.updateTime = ((SessionBuilder)b).updateTime;
        this.metadata = ((SessionBuilder)b).metadata;
    }

    @Generated
    public static SessionBuilder<?, ?> builder() {
        return new SessionBuilderImpl();
    }

    @Generated
    public SessionBuilder<?, ?> toBuilder() {
        return new SessionBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String toString() {
        return "Session(userId=" + this.getUserId() + ", sessionId=" + this.getSessionId() + ", updateTime=" + this.getUpdateTime() + ", metadata=" + this.getMetadata() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Session)) {
            return false;
        }
        Session other = (Session)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$updateTime = this.getUpdateTime();
        Long other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$sessionId = this.getSessionId();
        String other$sessionId = other.getSessionId();
        if (this$sessionId == null ? other$sessionId != null : !this$sessionId.equals(other$sessionId)) {
            return false;
        }
        Metadata this$metadata = this.getMetadata();
        Metadata other$metadata = other.getMetadata();
        return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Session;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $sessionId = this.getSessionId();
        result = result * 59 + ($sessionId == null ? 43 : $sessionId.hashCode());
        Metadata $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        return result;
    }

    @Generated
    public String getUserId() {
        return this.userId;
    }

    @Generated
    public String getSessionId() {
        return this.sessionId;
    }

    @Generated
    public Long getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Generated
    public Session setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    @Generated
    public Session setMetadata(Metadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @Generated
    private static final class SessionBuilderImpl
    extends SessionBuilder<Session, SessionBuilderImpl> {
        @Generated
        private SessionBuilderImpl() {
        }

        @Override
        @Generated
        protected SessionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Session build() {
            return new Session(this);
        }
    }

    @Generated
    public static abstract class SessionBuilder<C extends Session, B extends SessionBuilder<C, B>> {
        @Generated
        private String userId;
        @Generated
        private String sessionId;
        @Generated
        private Long updateTime;
        @Generated
        private Metadata metadata;

        @Generated
        protected B $fillValuesFrom(C instance) {
            SessionBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Session instance, SessionBuilder<?, ?> b) {
            b.userId(instance.userId);
            b.sessionId(instance.sessionId);
            b.updateTime(instance.updateTime);
            b.metadata(instance.metadata);
        }

        @Generated
        public B userId(String userId) {
            this.userId = userId;
            return this.self();
        }

        @Generated
        public B sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this.self();
        }

        @Generated
        public B updateTime(Long updateTime) {
            this.updateTime = updateTime;
            return this.self();
        }

        @Generated
        public B metadata(Metadata metadata) {
            this.metadata = metadata;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "Session.SessionBuilder(userId=" + this.userId + ", sessionId=" + this.sessionId + ", updateTime=" + this.updateTime + ", metadata=" + this.metadata + ")";
        }
    }
}

