/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.tablestore.agent.memory;

import com.alicloud.openservices.tablestore.SyncClient;
import com.alicloud.openservices.tablestore.TableStoreException;
import com.alicloud.openservices.tablestore.model.Column;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.model.Condition;
import com.alicloud.openservices.tablestore.model.DeleteRowRequest;
import com.alicloud.openservices.tablestore.model.GetRowRequest;
import com.alicloud.openservices.tablestore.model.GetRowResponse;
import com.alicloud.openservices.tablestore.model.IndexType;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.PrimaryKeyBuilder;
import com.alicloud.openservices.tablestore.model.PrimaryKeyValue;
import com.alicloud.openservices.tablestore.model.PutRowRequest;
import com.alicloud.openservices.tablestore.model.Row;
import com.alicloud.openservices.tablestore.model.RowDeleteChange;
import com.alicloud.openservices.tablestore.model.RowExistenceExpectation;
import com.alicloud.openservices.tablestore.model.RowPutChange;
import com.alicloud.openservices.tablestore.model.RowUpdateChange;
import com.alicloud.openservices.tablestore.model.SingleRowQueryCriteria;
import com.alicloud.openservices.tablestore.model.UpdateRowRequest;
import com.alicloud.openservices.tablestore.model.search.FieldSchema;
import com.alicloud.openservices.tablestore.model.search.FieldType;
import com.alicloud.openservices.tablestore.model.search.SearchQuery;
import com.alicloud.openservices.tablestore.model.search.SearchRequest;
import com.alicloud.openservices.tablestore.model.search.SearchResponse;
import com.alicloud.openservices.tablestore.model.search.query.Query;
import com.alicloud.openservices.tablestore.model.search.sort.Sort;
import com.aliyun.openservices.tablestore.agent.memory.MemorySearchRequest;
import com.aliyun.openservices.tablestore.agent.memory.MemoryStore;
import com.aliyun.openservices.tablestore.agent.model.Message;
import com.aliyun.openservices.tablestore.agent.model.MetaType;
import com.aliyun.openservices.tablestore.agent.model.Response;
import com.aliyun.openservices.tablestore.agent.model.Session;
import com.aliyun.openservices.tablestore.agent.model.filter.Filter;
import com.aliyun.openservices.tablestore.agent.model.sort.Order;
import com.aliyun.openservices.tablestore.agent.util.CollectionUtil;
import com.aliyun.openservices.tablestore.agent.util.Exceptions;
import com.aliyun.openservices.tablestore.agent.util.Pair;
import com.aliyun.openservices.tablestore.agent.util.TablestoreHelper;
import com.aliyun.openservices.tablestore.agent.util.Triple;
import com.aliyun.openservices.tablestore.agent.util.ValidationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryStoreImpl
implements MemoryStore {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MemoryStoreImpl.class);
    @NonNull
    private final SyncClient client;
    @NonNull
    private String sessionTableName;
    @NonNull
    private String sessionSecondaryIndexName;
    @NonNull
    private List<Pair<String, MetaType>> sessionSecondaryIndexMeta;
    @NonNull
    private String sessionSearchIndexName;
    @NonNull
    private List<FieldSchema> sessionSearchIndexSchema;
    @NonNull
    private String messageTableName;
    @NonNull
    private String messageSearchIndexName;
    @NonNull
    private String messageSecondaryIndexName;
    @NonNull
    private List<FieldSchema> messageSearchIndexSchema;

    @Override
    public void putSession(Session session) {
        ValidationUtils.ensureNotNull(session, "session");
        ValidationUtils.ensureNotNull(session.getUserId(), "userId");
        ValidationUtils.ensureNotNull(session.getSessionId(), "sessionId");
        ValidationUtils.ensureGreaterThanAndEqualZero(session.getUpdateTime(), "updateTime");
        PrimaryKeyBuilder primaryKeyBuilder = PrimaryKeyBuilder.createPrimaryKeyBuilder();
        primaryKeyBuilder.addPrimaryKeyColumn("user_id", PrimaryKeyValue.fromString((String)session.getUserId()));
        primaryKeyBuilder.addPrimaryKeyColumn("session_id", PrimaryKeyValue.fromString((String)session.getSessionId()));
        PrimaryKey primaryKey = primaryKeyBuilder.build();
        RowPutChange rowPutChange = new RowPutChange(this.sessionTableName, primaryKey);
        List<Column> columns = TablestoreHelper.metadataToColumns(session.getMetadata());
        columns.add(new Column("update_time", ColumnValue.fromLong((long)session.getUpdateTime())));
        rowPutChange.addColumns(columns);
        try {
            this.client.putRow(new PutRowRequest(rowPutChange));
            if (log.isDebugEnabled()) {
                log.debug("put session:{}", (Object)session);
            }
        }
        catch (Exception e) {
            throw Exceptions.runtimeThrowable(String.format("put session:%s failed", session), e);
        }
    }

    @Override
    public void updateSession(Session session) {
        ValidationUtils.ensureNotNull(session, "session");
        ValidationUtils.ensureNotNull(session.getUserId(), "userId");
        ValidationUtils.ensureNotNull(session.getSessionId(), "sessionId");
        ValidationUtils.ensureGreaterThanAndEqualZero(session.getUpdateTime(), "updateTime");
        PrimaryKeyBuilder primaryKeyBuilder = PrimaryKeyBuilder.createPrimaryKeyBuilder();
        primaryKeyBuilder.addPrimaryKeyColumn("user_id", PrimaryKeyValue.fromString((String)session.getUserId()));
        primaryKeyBuilder.addPrimaryKeyColumn("session_id", PrimaryKeyValue.fromString((String)session.getSessionId()));
        PrimaryKey primaryKey = primaryKeyBuilder.build();
        RowUpdateChange change = new RowUpdateChange(this.sessionTableName, primaryKey);
        List<Column> columns = TablestoreHelper.metadataToColumns(session.getMetadata());
        columns.add(new Column("update_time", ColumnValue.fromLong((long)session.getUpdateTime())));
        change.put(columns);
        try {
            this.client.updateRow(new UpdateRowRequest(change));
            if (log.isDebugEnabled()) {
                log.debug("update session:{}", (Object)session);
            }
        }
        catch (Exception e) {
            throw Exceptions.runtimeThrowable(String.format("update session:%s failed", session), e);
        }
    }

    @Override
    public void deleteSession(String userId, String sessionId) {
        ValidationUtils.ensureNotNull(userId, "userId");
        ValidationUtils.ensureNotNull(sessionId, "sessionId");
        PrimaryKeyBuilder primaryKeyBuilder = PrimaryKeyBuilder.createPrimaryKeyBuilder();
        primaryKeyBuilder.addPrimaryKeyColumn("user_id", PrimaryKeyValue.fromString((String)userId));
        primaryKeyBuilder.addPrimaryKeyColumn("session_id", PrimaryKeyValue.fromString((String)sessionId));
        PrimaryKey primaryKey = primaryKeyBuilder.build();
        RowDeleteChange rowDeleteChange = new RowDeleteChange(this.sessionTableName, primaryKey);
        rowDeleteChange.setCondition(new Condition(RowExistenceExpectation.IGNORE));
        try {
            this.client.deleteRow(new DeleteRowRequest(rowDeleteChange));
            if (log.isDebugEnabled()) {
                log.debug("delete session, userId:{}, sessionId:{}", (Object)userId, (Object)sessionId);
            }
        }
        catch (Exception e) {
            throw Exceptions.runtimeThrowable(String.format("delete session failed, userId:%s, sessionId:%s", userId, sessionId), e);
        }
    }

    @Override
    public void deleteSessions(String userId) {
        ValidationUtils.ensureNotNull(userId, "userId");
        log.info("delete sessions, userId:{}", (Object)userId);
        Iterator<Session> iterator = this.listSessions(userId, null, -1L, 5000);
        TablestoreHelper.batchDelete(this.client, this.sessionTableName, iterator);
    }

    @Override
    public void deleteSessionAndMessages(String userId, String sessionId) {
        log.info("delete session and messages, userId:{}, sessionId:{}", (Object)userId, (Object)sessionId);
        this.deleteSessions(userId);
        this.deleteMessages(sessionId);
    }

    @Override
    public void deleteAllSessions() {
        log.info("delete all sessions");
        TablestoreHelper.batchDelete(this.client, this.sessionTableName, this.listAllSessions());
    }

    @Override
    public Session getSession(String userId, String sessionId) {
        ValidationUtils.ensureNotNull(userId, "userId");
        ValidationUtils.ensureNotNull(sessionId, "sessionId");
        PrimaryKeyBuilder primaryKeyBuilder = PrimaryKeyBuilder.createPrimaryKeyBuilder();
        primaryKeyBuilder.addPrimaryKeyColumn("user_id", PrimaryKeyValue.fromString((String)userId));
        primaryKeyBuilder.addPrimaryKeyColumn("session_id", PrimaryKeyValue.fromString((String)sessionId));
        PrimaryKey primaryKey = primaryKeyBuilder.build();
        SingleRowQueryCriteria criteria = new SingleRowQueryCriteria(this.sessionTableName, primaryKey);
        criteria.setMaxVersions(1);
        try {
            GetRowResponse response = this.client.getRow(new GetRowRequest(criteria));
            Row row = response.getRow();
            Session session = TablestoreHelper.rowToSession(row);
            if (log.isDebugEnabled()) {
                log.debug("get session:{}", (Object)session);
            }
            return session;
        }
        catch (Exception e) {
            throw Exceptions.runtimeThrowable(String.format("get session failed, userId:%s, sessionId:%s ", userId, sessionId), e);
        }
    }

    @Override
    public Iterator<Session> listAllSessions() {
        log.info("list all sessions");
        PrimaryKey start = PrimaryKeyBuilder.createPrimaryKeyBuilder().addPrimaryKeyColumn("user_id", PrimaryKeyValue.INF_MIN).addPrimaryKeyColumn("session_id", PrimaryKeyValue.INF_MIN).build();
        PrimaryKey end = PrimaryKeyBuilder.createPrimaryKeyBuilder().addPrimaryKeyColumn("user_id", PrimaryKeyValue.INF_MAX).addPrimaryKeyColumn("session_id", PrimaryKeyValue.INF_MAX).build();
        return new TablestoreHelper.GetRangeIterator<Session>(this.client, this.sessionTableName, TablestoreHelper::rowToSession, start, end, null, Order.ASC, -1L, 5000, null);
    }

    @Override
    public Iterator<Session> listSessions(String userId, Filter metadataFilter, Long maxCount, Integer batchSize) {
        log.info("list sessions, userId:{}, metadataFilter:{}, maxCount:{}, batchSize:{}", new Object[]{userId, metadataFilter, maxCount, batchSize});
        ValidationUtils.ensureNotNull(userId, "userId");
        PrimaryKey start = PrimaryKeyBuilder.createPrimaryKeyBuilder().addPrimaryKeyColumn("user_id", PrimaryKeyValue.fromString((String)userId)).addPrimaryKeyColumn("session_id", PrimaryKeyValue.INF_MIN).build();
        PrimaryKey end = PrimaryKeyBuilder.createPrimaryKeyBuilder().addPrimaryKeyColumn("user_id", PrimaryKeyValue.fromString((String)userId)).addPrimaryKeyColumn("session_id", PrimaryKeyValue.INF_MAX).build();
        return new TablestoreHelper.GetRangeIterator<Session>(this.client, this.sessionTableName, TablestoreHelper::rowToSession, start, end, metadataFilter, Order.ASC, maxCount, batchSize, null);
    }

    @Override
    public Iterator<Session> listRecentSessions(String userId, Filter metadataFilter, Long inclusiveStartUpdateTime, Long inclusiveEndUpdateTime, Long maxCount, Integer batchSize) {
        log.info("list recent sessions, userId:{}, metadataFilter:{}, inclusiveStartUpdateTime:{}, inclusiveEndUpdateTime:{}, maxCount:{}, batchSize:{}", new Object[]{userId, metadataFilter, inclusiveStartUpdateTime, inclusiveEndUpdateTime, maxCount, batchSize});
        ValidationUtils.ensureNotNull(userId, "userId");
        if (inclusiveStartUpdateTime != null && inclusiveEndUpdateTime != null && inclusiveStartUpdateTime < inclusiveEndUpdateTime) {
            throw Exceptions.illegalArgument("inclusiveStartUpdateTime must be greater than inclusiveEndUpdateTime, because the results are returned in reverse order of update time", new Object[0]);
        }
        PrimaryKey start = PrimaryKeyBuilder.createPrimaryKeyBuilder().addPrimaryKeyColumn("user_id", PrimaryKeyValue.fromString((String)userId)).addPrimaryKeyColumn("update_time", inclusiveStartUpdateTime == null ? PrimaryKeyValue.INF_MAX : PrimaryKeyValue.fromLong((long)inclusiveStartUpdateTime)).addPrimaryKeyColumn("session_id", PrimaryKeyValue.INF_MAX).build();
        PrimaryKey end = PrimaryKeyBuilder.createPrimaryKeyBuilder().addPrimaryKeyColumn("user_id", PrimaryKeyValue.fromString((String)userId)).addPrimaryKeyColumn("update_time", inclusiveEndUpdateTime == null ? PrimaryKeyValue.INF_MIN : PrimaryKeyValue.fromLong((long)inclusiveEndUpdateTime)).addPrimaryKeyColumn("session_id", PrimaryKeyValue.INF_MIN).build();
        return new TablestoreHelper.GetRangeIterator<Session>(this.client, this.sessionSecondaryIndexName, TablestoreHelper::rowToSession, start, end, metadataFilter, Order.DESC, maxCount, batchSize, null);
    }

    @Override
    public Response<Session> listRecentSessionsPaginated(String userId, int pageSize, Filter metadataFilter, Long inclusiveStartUpdateTime, Long inclusiveEndUpdateTime, String nextToken, Integer batchSize) {
        log.info("list recent sessions paginated, userId:{}, pageSize:{}, metadataFilter:{}, inclusiveStartUpdateTime:{}, inclusiveEndUpdateTime:{}, nextToken:{}, batchSize:{}", new Object[]{userId, pageSize, metadataFilter, inclusiveStartUpdateTime, inclusiveEndUpdateTime, nextToken, batchSize});
        ValidationUtils.ensureNotNull(userId, "userId");
        if (inclusiveStartUpdateTime != null && inclusiveEndUpdateTime != null && inclusiveStartUpdateTime < inclusiveEndUpdateTime) {
            throw Exceptions.illegalArgument("inclusiveStartUpdateTime must be greater than inclusiveEndUpdateTime, because the results are returned in reverse order of update time", new Object[0]);
        }
        PrimaryKey start = PrimaryKeyBuilder.createPrimaryKeyBuilder().addPrimaryKeyColumn("user_id", PrimaryKeyValue.fromString((String)userId)).addPrimaryKeyColumn("update_time", inclusiveStartUpdateTime == null ? PrimaryKeyValue.INF_MAX : PrimaryKeyValue.fromLong((long)inclusiveStartUpdateTime)).addPrimaryKeyColumn("session_id", PrimaryKeyValue.INF_MAX).build();
        if (nextToken != null) {
            start = TablestoreHelper.decodeNextPrimaryKeyToken(nextToken);
        }
        PrimaryKey end = PrimaryKeyBuilder.createPrimaryKeyBuilder().addPrimaryKeyColumn("user_id", PrimaryKeyValue.fromString((String)userId)).addPrimaryKeyColumn("update_time", inclusiveEndUpdateTime == null ? PrimaryKeyValue.INF_MIN : PrimaryKeyValue.fromLong((long)inclusiveEndUpdateTime)).addPrimaryKeyColumn("session_id", PrimaryKeyValue.INF_MIN).build();
        TablestoreHelper.GetRangeIterator<Session> rangeIterator = new TablestoreHelper.GetRangeIterator<Session>(this.client, this.sessionSecondaryIndexName, TablestoreHelper::rowToSession, start, end, metadataFilter, Order.DESC, Long.valueOf(pageSize), batchSize, null);
        List<Session> sessions = CollectionUtil.toList(rangeIterator);
        PrimaryKey nextStartPrimaryKey = rangeIterator.nextStartPrimaryKey();
        String token = nextStartPrimaryKey == null ? null : TablestoreHelper.encodeNextPrimaryKeyToken(nextStartPrimaryKey);
        return new Response<Session>(sessions, token);
    }

    @Override
    public Response<Session> searchSessions(MemorySearchRequest searchRequest) {
        if (log.isDebugEnabled()) {
            log.debug("before search sessions:{}", (Object)searchRequest);
        }
        ValidationUtils.ensureNotNull(searchRequest, "MemorySearchRequest");
        Query query = TablestoreHelper.parserSearchFilters(searchRequest.getMetadataFilter());
        Sort otsSort = TablestoreHelper.toOtsSort(searchRequest.getSorts());
        byte[] nextToken = null;
        if (searchRequest.getNextToken() != null) {
            nextToken = Base64.getDecoder().decode(searchRequest.getNextToken());
        }
        SearchQuery searchQuery = SearchQuery.newBuilder().query(query).getTotalCount(false).limit(searchRequest.getLimit()).offset(0).sort(otsSort).token(nextToken).build();
        SearchRequest otsSearchRequest = SearchRequest.newBuilder().tableName(this.sessionTableName).indexName(this.sessionSearchIndexName).searchQuery(searchQuery).returnAllColumns(true).build();
        try {
            SearchResponse searchResponse = this.client.search(otsSearchRequest);
            log.info("search sessions:{}, request_id:{}", (Object)searchRequest, (Object)searchResponse.getRequestId());
            Triple<List<Session>, String, List<Double>> triple = TablestoreHelper.parserSearchResponse(searchResponse, TablestoreHelper::rowToSession);
            List<Session> sessions = triple.getLeft();
            String nextTokenStr = triple.getMiddle();
            return new Response<Session>(sessions, nextTokenStr);
        }
        catch (TableStoreException e) {
            throw Exceptions.runtimeThrowable(String.format("search sessions failed, request_id:%s, query:[%s]", e.getRequestId(), searchRequest), e);
        }
        catch (Exception e) {
            throw Exceptions.runtimeThrowable(String.format("search sessions failed, query:[%s]", searchRequest), e);
        }
    }

    @Override
    public void putMessage(Message message) {
        ValidationUtils.ensureNotNull(message, "message");
        ValidationUtils.ensureNotNull(message.getSessionId(), "sessionId");
        ValidationUtils.ensureNotNull(message.getMessageId(), "messageId");
        ValidationUtils.ensureGreaterThanAndEqualZero(message.getCreateTime(), "createTime");
        PrimaryKeyBuilder primaryKeyBuilder = PrimaryKeyBuilder.createPrimaryKeyBuilder();
        primaryKeyBuilder.addPrimaryKeyColumn("session_id", PrimaryKeyValue.fromString((String)message.getSessionId()));
        primaryKeyBuilder.addPrimaryKeyColumn("create_time", PrimaryKeyValue.fromLong((long)message.getCreateTime()));
        primaryKeyBuilder.addPrimaryKeyColumn("message_id", PrimaryKeyValue.fromString((String)message.getMessageId()));
        PrimaryKey primaryKey = primaryKeyBuilder.build();
        RowPutChange rowPutChange = new RowPutChange(this.messageTableName, primaryKey);
        List<Column> columns = TablestoreHelper.metadataToColumns(message.getMetadata());
        if (message.getContent() != null) {
            columns.add(new Column("content", ColumnValue.fromString((String)message.getContent())));
        }
        rowPutChange.addColumns(columns);
        try {
            this.client.putRow(new PutRowRequest(rowPutChange));
            if (log.isDebugEnabled()) {
                log.debug("put message:{}", (Object)message);
            }
        }
        catch (Exception e) {
            throw Exceptions.runtimeThrowable(String.format("put message:%s failed", message), e);
        }
    }

    @Override
    public void updateMessage(Message message) {
        ValidationUtils.ensureNotNull(message, "message");
        ValidationUtils.ensureNotNull(message.getSessionId(), "sessionId");
        ValidationUtils.ensureNotNull(message.getMessageId(), "messageId");
        if (message.getCreateTime() == null) {
            Long createTimeFromSecondaryIndex = this.getMessageCreateTimeFromSecondaryIndex(message.getSessionId(), message.getMessageId());
            if (createTimeFromSecondaryIndex == null) {
                throw Exceptions.illegalArgument("message is not exist because createTime is null and can't find in secondaryIndex, sessionId:%s, messageId:%s", message.getSessionId(), message.getMessageId());
            }
            message.setCreateTime(createTimeFromSecondaryIndex);
        }
        PrimaryKeyBuilder primaryKeyBuilder = PrimaryKeyBuilder.createPrimaryKeyBuilder();
        primaryKeyBuilder.addPrimaryKeyColumn("session_id", PrimaryKeyValue.fromString((String)message.getSessionId()));
        primaryKeyBuilder.addPrimaryKeyColumn("create_time", PrimaryKeyValue.fromLong((long)message.getCreateTime()));
        primaryKeyBuilder.addPrimaryKeyColumn("message_id", PrimaryKeyValue.fromString((String)message.getMessageId()));
        PrimaryKey primaryKey = primaryKeyBuilder.build();
        RowUpdateChange change = new RowUpdateChange(this.messageTableName, primaryKey);
        List<Column> columns = TablestoreHelper.metadataToColumns(message.getMetadata());
        if (message.getContent() != null) {
            columns.add(new Column("content", ColumnValue.fromString((String)message.getContent())));
        }
        change.put(columns);
        try {
            this.client.updateRow(new UpdateRowRequest(change));
            if (log.isDebugEnabled()) {
                log.debug("update message:{}", (Object)message);
            }
        }
        catch (Exception e) {
            throw Exceptions.runtimeThrowable(String.format("update message:%s failed", message), e);
        }
    }

    @Override
    public void deleteMessage(Message message) {
        ValidationUtils.ensureNotNull(message, "message");
        ValidationUtils.ensureNotNull(message.getSessionId(), "sessionId");
        ValidationUtils.ensureNotNull(message.getMessageId(), "messageId");
        if (message.getCreateTime() == null) {
            Long createTimeFromSecondaryIndex = this.getMessageCreateTimeFromSecondaryIndex(message.getSessionId(), message.getMessageId());
            if (createTimeFromSecondaryIndex == null) {
                return;
            }
            message.setCreateTime(createTimeFromSecondaryIndex);
        }
        PrimaryKeyBuilder primaryKeyBuilder = PrimaryKeyBuilder.createPrimaryKeyBuilder();
        primaryKeyBuilder.addPrimaryKeyColumn("session_id", PrimaryKeyValue.fromString((String)message.getSessionId()));
        primaryKeyBuilder.addPrimaryKeyColumn("create_time", PrimaryKeyValue.fromLong((long)message.getCreateTime()));
        primaryKeyBuilder.addPrimaryKeyColumn("message_id", PrimaryKeyValue.fromString((String)message.getMessageId()));
        PrimaryKey primaryKey = primaryKeyBuilder.build();
        RowDeleteChange rowDeleteChange = new RowDeleteChange(this.messageTableName, primaryKey);
        rowDeleteChange.setCondition(new Condition(RowExistenceExpectation.IGNORE));
        try {
            this.client.deleteRow(new DeleteRowRequest(rowDeleteChange));
            if (log.isDebugEnabled()) {
                log.debug("delete message:{}", (Object)message);
            }
        }
        catch (Exception e) {
            throw Exceptions.runtimeThrowable(String.format("delete message failed, message:%s", message), e);
        }
    }

    @Override
    public void deleteMessage(String sessionId, String messageId, Long createTime) {
        Message message = new Message(sessionId, messageId, createTime);
        this.deleteMessage(message);
    }

    @Override
    public void deleteMessages(String sessionId) {
        log.info("delete messages, sessionId:{}", (Object)sessionId);
        Iterator<Message> messages = this.listMessages(sessionId);
        TablestoreHelper.batchDelete(this.client, this.messageTableName, messages);
    }

    @Override
    public void deleteAllMessages() {
        log.info("delete all messages");
        Iterator<Message> allMessages = this.listAllMessages();
        TablestoreHelper.batchDelete(this.client, this.messageTableName, allMessages);
    }

    @Override
    public Message getMessage(String sessionId, String messageId, Long createTime) {
        ValidationUtils.ensureNotNull(sessionId, "sessionId");
        ValidationUtils.ensureNotNull(messageId, "messageId");
        if (createTime == null) {
            Long createTimeFromSecondaryIndex = this.getMessageCreateTimeFromSecondaryIndex(sessionId, messageId);
            if (createTimeFromSecondaryIndex == null) {
                return null;
            }
            createTime = createTimeFromSecondaryIndex;
        }
        PrimaryKeyBuilder primaryKeyBuilder = PrimaryKeyBuilder.createPrimaryKeyBuilder();
        primaryKeyBuilder.addPrimaryKeyColumn("session_id", PrimaryKeyValue.fromString((String)sessionId));
        primaryKeyBuilder.addPrimaryKeyColumn("create_time", PrimaryKeyValue.fromLong((long)createTime));
        primaryKeyBuilder.addPrimaryKeyColumn("message_id", PrimaryKeyValue.fromString((String)messageId));
        PrimaryKey primaryKey = primaryKeyBuilder.build();
        SingleRowQueryCriteria criteria = new SingleRowQueryCriteria(this.messageTableName, primaryKey);
        criteria.setMaxVersions(1);
        try {
            GetRowResponse response = this.client.getRow(new GetRowRequest(criteria));
            Row row = response.getRow();
            Message message = TablestoreHelper.rowToMessage(row);
            if (log.isDebugEnabled()) {
                log.debug("get message:{}", (Object)message);
            }
            return message;
        }
        catch (Exception e) {
            throw Exceptions.runtimeThrowable(String.format("get message failed, sessionId:%s, createTime:%s, messageId:%s", sessionId, createTime, messageId), e);
        }
    }

    @Override
    public Iterator<Message> listAllMessages() {
        log.info("list all messages");
        PrimaryKey start = PrimaryKeyBuilder.createPrimaryKeyBuilder().addPrimaryKeyColumn("session_id", PrimaryKeyValue.INF_MIN).addPrimaryKeyColumn("create_time", PrimaryKeyValue.INF_MIN).addPrimaryKeyColumn("message_id", PrimaryKeyValue.INF_MIN).build();
        PrimaryKey end = PrimaryKeyBuilder.createPrimaryKeyBuilder().addPrimaryKeyColumn("session_id", PrimaryKeyValue.INF_MAX).addPrimaryKeyColumn("create_time", PrimaryKeyValue.INF_MAX).addPrimaryKeyColumn("message_id", PrimaryKeyValue.INF_MAX).build();
        return new TablestoreHelper.GetRangeIterator<Message>(this.client, this.messageTableName, TablestoreHelper::rowToMessage, start, end, null, Order.ASC, -1L, 5000, null);
    }

    @Override
    public Iterator<Message> listMessages(String sessionId) {
        return this.listMessages(sessionId, null, null, null, Order.ASC, null, null);
    }

    @Override
    public Iterator<Message> listMessages(String sessionId, Filter metadataFilter, Long inclusiveStartCreateTime, Long inclusiveEndCreateTime, Order order, Long maxCount, Integer batchSize) {
        PrimaryKeyValue constMax;
        PrimaryKeyValue constMin;
        log.info("list messages, sessionId:{}, metadataFilter:{}, inclusiveStartCreateTime:{}, inclusiveEndCreateTime:{}, order:{}, maxCount:{}, batchSize:{}", new Object[]{sessionId, metadataFilter, inclusiveStartCreateTime, inclusiveEndCreateTime, order, maxCount, batchSize});
        ValidationUtils.ensureNotNull(sessionId, "sessionId");
        if (inclusiveStartCreateTime != null || inclusiveEndCreateTime != null) {
            if (order == null) {
                throw Exceptions.illegalArgument("order is required when inclusiveStartCreateTime or inclusiveEndCreateTime is specified", new Object[0]);
            }
        } else if (order == null) {
            order = Order.DESC;
        }
        if (inclusiveStartCreateTime != null && inclusiveEndCreateTime != null) {
            if (Order.DESC.equals((Object)order) && inclusiveStartCreateTime < inclusiveEndCreateTime) {
                throw Exceptions.illegalArgument("inclusiveStartUpdateTime must be greater than inclusiveEndUpdateTime, because the results are returned in reverse order of update time", new Object[0]);
            }
            if (Order.ASC.equals((Object)order) && inclusiveStartCreateTime > inclusiveEndCreateTime) {
                throw Exceptions.illegalArgument("inclusiveStartUpdateTime must be less than inclusiveEndUpdateTime, because the results are returned in order of update time", new Object[0]);
            }
        }
        if (Order.ASC.equals((Object)order)) {
            constMin = PrimaryKeyValue.INF_MIN;
            constMax = PrimaryKeyValue.INF_MAX;
        } else {
            constMin = PrimaryKeyValue.INF_MAX;
            constMax = PrimaryKeyValue.INF_MIN;
        }
        PrimaryKey start = PrimaryKeyBuilder.createPrimaryKeyBuilder().addPrimaryKeyColumn("session_id", PrimaryKeyValue.fromString((String)sessionId)).addPrimaryKeyColumn("create_time", inclusiveStartCreateTime == null ? constMin : PrimaryKeyValue.fromLong((long)inclusiveStartCreateTime)).addPrimaryKeyColumn("message_id", constMin).build();
        PrimaryKey end = PrimaryKeyBuilder.createPrimaryKeyBuilder().addPrimaryKeyColumn("session_id", PrimaryKeyValue.fromString((String)sessionId)).addPrimaryKeyColumn("create_time", inclusiveEndCreateTime == null ? constMax : PrimaryKeyValue.fromLong((long)inclusiveEndCreateTime)).addPrimaryKeyColumn("message_id", constMax).build();
        return new TablestoreHelper.GetRangeIterator<Message>(this.client, this.messageTableName, TablestoreHelper::rowToMessage, start, end, metadataFilter, order, maxCount, batchSize, null);
    }

    @Override
    public Response<Message> listMessagesPaginated(String sessionId, int pageSize, Filter metadataFilter, Long inclusiveStartCreateTime, Long inclusiveEndCreateTime, Order order, String nextToken, Integer batchSize) {
        PrimaryKeyValue constMax;
        PrimaryKeyValue constMin;
        log.info("list messages paginated, sessionId:{}, pageSize:{}, metadataFilter:{}, inclusiveStartCreateTime:{}, inclusiveEndCreateTime:{}, order:{}, nextToken:{}, batchSize:{}", new Object[]{sessionId, pageSize, metadataFilter, inclusiveStartCreateTime, inclusiveEndCreateTime, order, nextToken, batchSize});
        ValidationUtils.ensureNotNull(sessionId, "sessionId");
        if (inclusiveStartCreateTime != null || inclusiveEndCreateTime != null) {
            if (order == null) {
                throw Exceptions.illegalArgument("order is required when inclusiveStartCreateTime or inclusiveEndCreateTime is specified", new Object[0]);
            }
        } else if (order == null) {
            order = Order.DESC;
        }
        if (inclusiveStartCreateTime != null && inclusiveEndCreateTime != null) {
            if (Order.DESC.equals((Object)order) && inclusiveStartCreateTime < inclusiveEndCreateTime) {
                throw Exceptions.illegalArgument("inclusiveStartUpdateTime must be greater than inclusiveEndUpdateTime, because the results are returned in reverse order of update time", new Object[0]);
            }
            if (Order.ASC.equals((Object)order) && inclusiveStartCreateTime > inclusiveEndCreateTime) {
                throw Exceptions.illegalArgument("inclusiveStartUpdateTime must be less than inclusiveEndUpdateTime, because the results are returned in order of update time", new Object[0]);
            }
        }
        if (Order.ASC.equals((Object)order)) {
            constMin = PrimaryKeyValue.INF_MIN;
            constMax = PrimaryKeyValue.INF_MAX;
        } else {
            constMin = PrimaryKeyValue.INF_MAX;
            constMax = PrimaryKeyValue.INF_MIN;
        }
        PrimaryKey start = PrimaryKeyBuilder.createPrimaryKeyBuilder().addPrimaryKeyColumn("session_id", PrimaryKeyValue.fromString((String)sessionId)).addPrimaryKeyColumn("create_time", inclusiveStartCreateTime == null ? constMin : PrimaryKeyValue.fromLong((long)inclusiveStartCreateTime)).addPrimaryKeyColumn("message_id", constMin).build();
        if (nextToken != null) {
            start = TablestoreHelper.decodeNextPrimaryKeyToken(nextToken);
        }
        PrimaryKey end = PrimaryKeyBuilder.createPrimaryKeyBuilder().addPrimaryKeyColumn("session_id", PrimaryKeyValue.fromString((String)sessionId)).addPrimaryKeyColumn("create_time", inclusiveEndCreateTime == null ? constMax : PrimaryKeyValue.fromLong((long)inclusiveEndCreateTime)).addPrimaryKeyColumn("message_id", constMax).build();
        TablestoreHelper.GetRangeIterator<Message> rangeIterator = new TablestoreHelper.GetRangeIterator<Message>(this.client, this.messageTableName, TablestoreHelper::rowToMessage, start, end, metadataFilter, order, Long.valueOf(pageSize), batchSize, null);
        List<Message> messages = CollectionUtil.toList(rangeIterator);
        PrimaryKey nextStartPrimaryKey = rangeIterator.nextStartPrimaryKey();
        String token = nextStartPrimaryKey == null ? null : TablestoreHelper.encodeNextPrimaryKeyToken(nextStartPrimaryKey);
        return new Response<Message>(messages, token);
    }

    @Override
    public Response<Message> searchMessages(MemorySearchRequest searchRequest) {
        if (log.isDebugEnabled()) {
            log.debug("before search messages:{}", (Object)searchRequest);
        }
        ValidationUtils.ensureNotNull(searchRequest, "MemorySearchRequest");
        Query query = TablestoreHelper.parserSearchFilters(searchRequest.getMetadataFilter());
        Sort otsSort = TablestoreHelper.toOtsSort(searchRequest.getSorts());
        byte[] nextToken = null;
        if (searchRequest.getNextToken() != null) {
            nextToken = Base64.getDecoder().decode(searchRequest.getNextToken());
        }
        SearchQuery searchQuery = SearchQuery.newBuilder().query(query).getTotalCount(false).limit(searchRequest.getLimit()).offset(0).sort(otsSort).token(nextToken).build();
        SearchRequest otsSearchRequest = SearchRequest.newBuilder().tableName(this.messageTableName).indexName(this.messageSearchIndexName).searchQuery(searchQuery).returnAllColumns(true).build();
        try {
            SearchResponse searchResponse = this.client.search(otsSearchRequest);
            log.info("search messages:{}, request_id:{}", (Object)searchRequest, (Object)searchResponse.getRequestId());
            Triple<List<Message>, String, List<Double>> triple = TablestoreHelper.parserSearchResponse(searchResponse, TablestoreHelper::rowToMessage);
            List<Message> messages = triple.getLeft();
            String nextTokenStr = triple.getMiddle();
            return new Response<Message>(messages, nextTokenStr);
        }
        catch (TableStoreException e) {
            throw Exceptions.runtimeThrowable(String.format("search messages failed, request_id:%s, query:[%s]", e.getRequestId(), searchRequest), e);
        }
        catch (Exception e) {
            throw Exceptions.runtimeThrowable(String.format("search messages failed, query:[%s]", searchRequest), e);
        }
    }

    @Override
    public void initTable() {
        ArrayList<Pair<String, MetaType>> sessionDefinedColumns = new ArrayList<Pair<String, MetaType>>(this.sessionSecondaryIndexMeta);
        if (!this.sessionSecondaryIndexMeta.stream().noneMatch(s -> "update_time".equals(s.getKey()))) {
            throw Exceptions.illegalArgument("sessionSecondaryIndexMeta can't contains 'update_time'", new Object[0]);
        }
        sessionDefinedColumns.add(Pair.of("update_time", MetaType.INTEGER));
        TablestoreHelper.createTableIfNotExist(this.client, this.sessionTableName, Arrays.asList(Pair.of("user_id", MetaType.STRING), Pair.of("session_id", MetaType.STRING)), sessionDefinedColumns);
        List<String> definedColumnNames = this.sessionSecondaryIndexMeta.stream().map(Pair::getKey).collect(Collectors.toList());
        TablestoreHelper.createSecondaryIndexIfNotExist(this.client, this.sessionTableName, this.sessionSecondaryIndexName, Arrays.asList("user_id", "update_time", "session_id"), definedColumnNames, IndexType.IT_LOCAL_INDEX);
        TablestoreHelper.createTableIfNotExist(this.client, this.messageTableName, Arrays.asList(Pair.of("session_id", MetaType.STRING), Pair.of("create_time", MetaType.INTEGER), Pair.of("message_id", MetaType.STRING)), Collections.emptyList());
        TablestoreHelper.createSecondaryIndexIfNotExist(this.client, this.messageTableName, this.messageSecondaryIndexName, Arrays.asList("session_id", "message_id", "create_time"), Collections.emptyList(), IndexType.IT_LOCAL_INDEX);
    }

    @Override
    public void initSearchIndex() {
        if (this.sessionSearchIndexSchema == null || this.sessionSearchIndexSchema.isEmpty()) {
            log.warn("skip create session search index because sessionSearchIndexSchema is empty");
        } else {
            ArrayList<FieldSchema> sessionSchemas = new ArrayList<FieldSchema>(this.sessionSearchIndexSchema);
            TablestoreHelper.addSchemaIfNotExist(sessionSchemas, new FieldSchema("user_id", FieldType.KEYWORD));
            TablestoreHelper.addSchemaIfNotExist(sessionSchemas, new FieldSchema("session_id", FieldType.KEYWORD));
            TablestoreHelper.addSchemaIfNotExist(sessionSchemas, new FieldSchema("update_time", FieldType.LONG));
            TablestoreHelper.createSearchIndexIfNotExist(this.client, this.sessionTableName, this.sessionSearchIndexName, sessionSchemas, Collections.emptyList());
        }
        if (this.messageSearchIndexSchema == null || this.messageSearchIndexSchema.isEmpty()) {
            log.warn("skip create message search index because messageSearchIndexSchema is empty");
        } else {
            ArrayList<FieldSchema> messageSchemas = new ArrayList<FieldSchema>(this.messageSearchIndexSchema);
            TablestoreHelper.addSchemaIfNotExist(messageSchemas, new FieldSchema("session_id", FieldType.KEYWORD));
            TablestoreHelper.addSchemaIfNotExist(messageSchemas, new FieldSchema("message_id", FieldType.KEYWORD));
            TablestoreHelper.addSchemaIfNotExist(messageSchemas, new FieldSchema("create_time", FieldType.LONG));
            TablestoreHelper.addSchemaIfNotExist(messageSchemas, new FieldSchema("content", FieldType.TEXT).setAnalyzer(FieldSchema.Analyzer.MaxWord));
            TablestoreHelper.createSearchIndexIfNotExist(this.client, this.messageTableName, this.messageSearchIndexName, messageSchemas, Collections.emptyList());
        }
    }

    @Override
    public void deleteTableAndIndex() {
        TablestoreHelper.deleteTable(this.client, this.sessionTableName);
        TablestoreHelper.deleteTable(this.client, this.messageTableName);
    }

    private Long getMessageCreateTimeFromSecondaryIndex(String sessionId, String messageId) {
        PrimaryKey end;
        PrimaryKey start = PrimaryKeyBuilder.createPrimaryKeyBuilder().addPrimaryKeyColumn("session_id", PrimaryKeyValue.fromString((String)sessionId)).addPrimaryKeyColumn("message_id", PrimaryKeyValue.fromString((String)messageId)).addPrimaryKeyColumn("create_time", PrimaryKeyValue.INF_MIN).build();
        TablestoreHelper.GetRangeIterator<Message> iterator = new TablestoreHelper.GetRangeIterator<Message>(this.client, this.messageSecondaryIndexName, TablestoreHelper::rowToMessage, start, end = PrimaryKeyBuilder.createPrimaryKeyBuilder().addPrimaryKeyColumn("session_id", PrimaryKeyValue.fromString((String)sessionId)).addPrimaryKeyColumn("message_id", PrimaryKeyValue.fromString((String)messageId)).addPrimaryKeyColumn("create_time", PrimaryKeyValue.INF_MAX).build(), null, Order.ASC, null, null, null);
        List<Message> messages = CollectionUtil.toList(iterator);
        if (messages.size() == 1) {
            return messages.get(0).getCreateTime();
        }
        if (messages.size() > 1) {
            throw Exceptions.illegalArgument("message is not unique, sessionId:%s, messageId:%s, details messages:[%s]", sessionId, messageId, messages);
        }
        return null;
    }

    @Generated
    private static String $default$sessionTableName() {
        return "session";
    }

    @Generated
    private static String $default$sessionSecondaryIndexName() {
        return "session_secondary_index";
    }

    @Generated
    private static List<Pair<String, MetaType>> $default$sessionSecondaryIndexMeta() {
        return Collections.emptyList();
    }

    @Generated
    private static String $default$sessionSearchIndexName() {
        return "session_search_index_name";
    }

    @Generated
    private static List<FieldSchema> $default$sessionSearchIndexSchema() {
        return Collections.emptyList();
    }

    @Generated
    private static String $default$messageTableName() {
        return "message";
    }

    @Generated
    private static String $default$messageSearchIndexName() {
        return "message_search_index";
    }

    @Generated
    private static String $default$messageSecondaryIndexName() {
        return "message_secondary_index";
    }

    @Generated
    private static List<FieldSchema> $default$messageSearchIndexSchema() {
        return Collections.emptyList();
    }

    @Generated
    MemoryStoreImpl(@NonNull SyncClient client, @NonNull String sessionTableName, @NonNull String sessionSecondaryIndexName, @NonNull List<Pair<String, MetaType>> sessionSecondaryIndexMeta, @NonNull String sessionSearchIndexName, @NonNull List<FieldSchema> sessionSearchIndexSchema, @NonNull String messageTableName, @NonNull String messageSearchIndexName, @NonNull String messageSecondaryIndexName, @NonNull List<FieldSchema> messageSearchIndexSchema) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (sessionTableName == null) {
            throw new NullPointerException("sessionTableName is marked non-null but is null");
        }
        if (sessionSecondaryIndexName == null) {
            throw new NullPointerException("sessionSecondaryIndexName is marked non-null but is null");
        }
        if (sessionSecondaryIndexMeta == null) {
            throw new NullPointerException("sessionSecondaryIndexMeta is marked non-null but is null");
        }
        if (sessionSearchIndexName == null) {
            throw new NullPointerException("sessionSearchIndexName is marked non-null but is null");
        }
        if (sessionSearchIndexSchema == null) {
            throw new NullPointerException("sessionSearchIndexSchema is marked non-null but is null");
        }
        if (messageTableName == null) {
            throw new NullPointerException("messageTableName is marked non-null but is null");
        }
        if (messageSearchIndexName == null) {
            throw new NullPointerException("messageSearchIndexName is marked non-null but is null");
        }
        if (messageSecondaryIndexName == null) {
            throw new NullPointerException("messageSecondaryIndexName is marked non-null but is null");
        }
        if (messageSearchIndexSchema == null) {
            throw new NullPointerException("messageSearchIndexSchema is marked non-null but is null");
        }
        this.client = client;
        this.sessionTableName = sessionTableName;
        this.sessionSecondaryIndexName = sessionSecondaryIndexName;
        this.sessionSecondaryIndexMeta = sessionSecondaryIndexMeta;
        this.sessionSearchIndexName = sessionSearchIndexName;
        this.sessionSearchIndexSchema = sessionSearchIndexSchema;
        this.messageTableName = messageTableName;
        this.messageSearchIndexName = messageSearchIndexName;
        this.messageSecondaryIndexName = messageSecondaryIndexName;
        this.messageSearchIndexSchema = messageSearchIndexSchema;
    }

    @Generated
    public static MemoryStoreImplBuilder builder() {
        return new MemoryStoreImplBuilder();
    }

    @NonNull
    @Generated
    public SyncClient getClient() {
        return this.client;
    }

    @NonNull
    @Generated
    public String getSessionTableName() {
        return this.sessionTableName;
    }

    @NonNull
    @Generated
    public String getSessionSecondaryIndexName() {
        return this.sessionSecondaryIndexName;
    }

    @NonNull
    @Generated
    public List<Pair<String, MetaType>> getSessionSecondaryIndexMeta() {
        return this.sessionSecondaryIndexMeta;
    }

    @NonNull
    @Generated
    public String getSessionSearchIndexName() {
        return this.sessionSearchIndexName;
    }

    @NonNull
    @Generated
    public List<FieldSchema> getSessionSearchIndexSchema() {
        return this.sessionSearchIndexSchema;
    }

    @NonNull
    @Generated
    public String getMessageTableName() {
        return this.messageTableName;
    }

    @NonNull
    @Generated
    public String getMessageSearchIndexName() {
        return this.messageSearchIndexName;
    }

    @NonNull
    @Generated
    public String getMessageSecondaryIndexName() {
        return this.messageSecondaryIndexName;
    }

    @NonNull
    @Generated
    public List<FieldSchema> getMessageSearchIndexSchema() {
        return this.messageSearchIndexSchema;
    }

    @Generated
    public static class MemoryStoreImplBuilder {
        @Generated
        private SyncClient client;
        @Generated
        private boolean sessionTableName$set;
        @Generated
        private String sessionTableName$value;
        @Generated
        private boolean sessionSecondaryIndexName$set;
        @Generated
        private String sessionSecondaryIndexName$value;
        @Generated
        private boolean sessionSecondaryIndexMeta$set;
        @Generated
        private List<Pair<String, MetaType>> sessionSecondaryIndexMeta$value;
        @Generated
        private boolean sessionSearchIndexName$set;
        @Generated
        private String sessionSearchIndexName$value;
        @Generated
        private boolean sessionSearchIndexSchema$set;
        @Generated
        private List<FieldSchema> sessionSearchIndexSchema$value;
        @Generated
        private boolean messageTableName$set;
        @Generated
        private String messageTableName$value;
        @Generated
        private boolean messageSearchIndexName$set;
        @Generated
        private String messageSearchIndexName$value;
        @Generated
        private boolean messageSecondaryIndexName$set;
        @Generated
        private String messageSecondaryIndexName$value;
        @Generated
        private boolean messageSearchIndexSchema$set;
        @Generated
        private List<FieldSchema> messageSearchIndexSchema$value;

        @Generated
        MemoryStoreImplBuilder() {
        }

        @Generated
        public MemoryStoreImplBuilder client(@NonNull SyncClient client) {
            if (client == null) {
                throw new NullPointerException("client is marked non-null but is null");
            }
            this.client = client;
            return this;
        }

        @Generated
        public MemoryStoreImplBuilder sessionTableName(@NonNull String sessionTableName) {
            if (sessionTableName == null) {
                throw new NullPointerException("sessionTableName is marked non-null but is null");
            }
            this.sessionTableName$value = sessionTableName;
            this.sessionTableName$set = true;
            return this;
        }

        @Generated
        public MemoryStoreImplBuilder sessionSecondaryIndexName(@NonNull String sessionSecondaryIndexName) {
            if (sessionSecondaryIndexName == null) {
                throw new NullPointerException("sessionSecondaryIndexName is marked non-null but is null");
            }
            this.sessionSecondaryIndexName$value = sessionSecondaryIndexName;
            this.sessionSecondaryIndexName$set = true;
            return this;
        }

        @Generated
        public MemoryStoreImplBuilder sessionSecondaryIndexMeta(@NonNull List<Pair<String, MetaType>> sessionSecondaryIndexMeta) {
            if (sessionSecondaryIndexMeta == null) {
                throw new NullPointerException("sessionSecondaryIndexMeta is marked non-null but is null");
            }
            this.sessionSecondaryIndexMeta$value = sessionSecondaryIndexMeta;
            this.sessionSecondaryIndexMeta$set = true;
            return this;
        }

        @Generated
        public MemoryStoreImplBuilder sessionSearchIndexName(@NonNull String sessionSearchIndexName) {
            if (sessionSearchIndexName == null) {
                throw new NullPointerException("sessionSearchIndexName is marked non-null but is null");
            }
            this.sessionSearchIndexName$value = sessionSearchIndexName;
            this.sessionSearchIndexName$set = true;
            return this;
        }

        @Generated
        public MemoryStoreImplBuilder sessionSearchIndexSchema(@NonNull List<FieldSchema> sessionSearchIndexSchema) {
            if (sessionSearchIndexSchema == null) {
                throw new NullPointerException("sessionSearchIndexSchema is marked non-null but is null");
            }
            this.sessionSearchIndexSchema$value = sessionSearchIndexSchema;
            this.sessionSearchIndexSchema$set = true;
            return this;
        }

        @Generated
        public MemoryStoreImplBuilder messageTableName(@NonNull String messageTableName) {
            if (messageTableName == null) {
                throw new NullPointerException("messageTableName is marked non-null but is null");
            }
            this.messageTableName$value = messageTableName;
            this.messageTableName$set = true;
            return this;
        }

        @Generated
        public MemoryStoreImplBuilder messageSearchIndexName(@NonNull String messageSearchIndexName) {
            if (messageSearchIndexName == null) {
                throw new NullPointerException("messageSearchIndexName is marked non-null but is null");
            }
            this.messageSearchIndexName$value = messageSearchIndexName;
            this.messageSearchIndexName$set = true;
            return this;
        }

        @Generated
        public MemoryStoreImplBuilder messageSecondaryIndexName(@NonNull String messageSecondaryIndexName) {
            if (messageSecondaryIndexName == null) {
                throw new NullPointerException("messageSecondaryIndexName is marked non-null but is null");
            }
            this.messageSecondaryIndexName$value = messageSecondaryIndexName;
            this.messageSecondaryIndexName$set = true;
            return this;
        }

        @Generated
        public MemoryStoreImplBuilder messageSearchIndexSchema(@NonNull List<FieldSchema> messageSearchIndexSchema) {
            if (messageSearchIndexSchema == null) {
                throw new NullPointerException("messageSearchIndexSchema is marked non-null but is null");
            }
            this.messageSearchIndexSchema$value = messageSearchIndexSchema;
            this.messageSearchIndexSchema$set = true;
            return this;
        }

        @Generated
        public MemoryStoreImpl build() {
            String sessionTableName$value = this.sessionTableName$value;
            if (!this.sessionTableName$set) {
                sessionTableName$value = MemoryStoreImpl.$default$sessionTableName();
            }
            String sessionSecondaryIndexName$value = this.sessionSecondaryIndexName$value;
            if (!this.sessionSecondaryIndexName$set) {
                sessionSecondaryIndexName$value = MemoryStoreImpl.$default$sessionSecondaryIndexName();
            }
            List sessionSecondaryIndexMeta$value = this.sessionSecondaryIndexMeta$value;
            if (!this.sessionSecondaryIndexMeta$set) {
                sessionSecondaryIndexMeta$value = MemoryStoreImpl.$default$sessionSecondaryIndexMeta();
            }
            String sessionSearchIndexName$value = this.sessionSearchIndexName$value;
            if (!this.sessionSearchIndexName$set) {
                sessionSearchIndexName$value = MemoryStoreImpl.$default$sessionSearchIndexName();
            }
            List sessionSearchIndexSchema$value = this.sessionSearchIndexSchema$value;
            if (!this.sessionSearchIndexSchema$set) {
                sessionSearchIndexSchema$value = MemoryStoreImpl.$default$sessionSearchIndexSchema();
            }
            String messageTableName$value = this.messageTableName$value;
            if (!this.messageTableName$set) {
                messageTableName$value = MemoryStoreImpl.$default$messageTableName();
            }
            String messageSearchIndexName$value = this.messageSearchIndexName$value;
            if (!this.messageSearchIndexName$set) {
                messageSearchIndexName$value = MemoryStoreImpl.$default$messageSearchIndexName();
            }
            String messageSecondaryIndexName$value = this.messageSecondaryIndexName$value;
            if (!this.messageSecondaryIndexName$set) {
                messageSecondaryIndexName$value = MemoryStoreImpl.$default$messageSecondaryIndexName();
            }
            List messageSearchIndexSchema$value = this.messageSearchIndexSchema$value;
            if (!this.messageSearchIndexSchema$set) {
                messageSearchIndexSchema$value = MemoryStoreImpl.$default$messageSearchIndexSchema();
            }
            return new MemoryStoreImpl(this.client, sessionTableName$value, sessionSecondaryIndexName$value, sessionSecondaryIndexMeta$value, sessionSearchIndexName$value, sessionSearchIndexSchema$value, messageTableName$value, messageSearchIndexName$value, messageSecondaryIndexName$value, messageSearchIndexSchema$value);
        }

        @Generated
        public String toString() {
            return "MemoryStoreImpl.MemoryStoreImplBuilder(client=" + this.client + ", sessionTableName$value=" + this.sessionTableName$value + ", sessionSecondaryIndexName$value=" + this.sessionSecondaryIndexName$value + ", sessionSecondaryIndexMeta$value=" + this.sessionSecondaryIndexMeta$value + ", sessionSearchIndexName$value=" + this.sessionSearchIndexName$value + ", sessionSearchIndexSchema$value=" + this.sessionSearchIndexSchema$value + ", messageTableName$value=" + this.messageTableName$value + ", messageSearchIndexName$value=" + this.messageSearchIndexName$value + ", messageSecondaryIndexName$value=" + this.messageSecondaryIndexName$value + ", messageSearchIndexSchema$value=" + this.messageSearchIndexSchema$value + ")";
        }
    }
}

