/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.tablestore.agent.knowledge;

import com.alicloud.openservices.tablestore.SyncClient;
import com.alicloud.openservices.tablestore.TableStoreException;
import com.alicloud.openservices.tablestore.model.Column;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.model.Condition;
import com.alicloud.openservices.tablestore.model.DeleteRowRequest;
import com.alicloud.openservices.tablestore.model.GetRowRequest;
import com.alicloud.openservices.tablestore.model.GetRowResponse;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.PrimaryKeyBuilder;
import com.alicloud.openservices.tablestore.model.PrimaryKeyValue;
import com.alicloud.openservices.tablestore.model.PutRowRequest;
import com.alicloud.openservices.tablestore.model.Row;
import com.alicloud.openservices.tablestore.model.RowDeleteChange;
import com.alicloud.openservices.tablestore.model.RowExistenceExpectation;
import com.alicloud.openservices.tablestore.model.RowPutChange;
import com.alicloud.openservices.tablestore.model.RowUpdateChange;
import com.alicloud.openservices.tablestore.model.SingleRowQueryCriteria;
import com.alicloud.openservices.tablestore.model.UpdateRowRequest;
import com.alicloud.openservices.tablestore.model.search.FieldSchema;
import com.alicloud.openservices.tablestore.model.search.FieldType;
import com.alicloud.openservices.tablestore.model.search.SearchQuery;
import com.alicloud.openservices.tablestore.model.search.SearchRequest;
import com.alicloud.openservices.tablestore.model.search.SearchResponse;
import com.alicloud.openservices.tablestore.model.search.query.Query;
import com.alicloud.openservices.tablestore.model.search.sort.Sort;
import com.alicloud.openservices.tablestore.model.search.vector.VectorDataType;
import com.alicloud.openservices.tablestore.model.search.vector.VectorMetricType;
import com.alicloud.openservices.tablestore.model.search.vector.VectorOptions;
import com.aliyun.openservices.tablestore.agent.knowledge.KnowledgeSearchRequest;
import com.aliyun.openservices.tablestore.agent.knowledge.KnowledgeStore;
import com.aliyun.openservices.tablestore.agent.model.Document;
import com.aliyun.openservices.tablestore.agent.model.DocumentHit;
import com.aliyun.openservices.tablestore.agent.model.MetaType;
import com.aliyun.openservices.tablestore.agent.model.Response;
import com.aliyun.openservices.tablestore.agent.model.filter.Filter;
import com.aliyun.openservices.tablestore.agent.model.filter.Filters;
import com.aliyun.openservices.tablestore.agent.model.filter.operation.TextMatch;
import com.aliyun.openservices.tablestore.agent.model.filter.operation.VectorQuery;
import com.aliyun.openservices.tablestore.agent.model.sort.Order;
import com.aliyun.openservices.tablestore.agent.model.sort.ScoreSort;
import com.aliyun.openservices.tablestore.agent.util.CollectionUtil;
import com.aliyun.openservices.tablestore.agent.util.Exceptions;
import com.aliyun.openservices.tablestore.agent.util.Pair;
import com.aliyun.openservices.tablestore.agent.util.TablestoreHelper;
import com.aliyun.openservices.tablestore.agent.util.Triple;
import com.aliyun.openservices.tablestore.agent.util.ValidationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnowledgeStoreImpl
implements KnowledgeStore {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KnowledgeStoreImpl.class);
    private final SyncClient client;
    @NonNull
    private final String tableName;
    @NonNull
    private final String searchIndexName;
    @NonNull
    private final List<FieldSchema> metadataSchema;
    @NonNull
    private final String textField;
    @NonNull
    private final String embeddingField;
    @NonNull
    private final VectorMetricType embeddingMetricType;
    @NonNull
    private final Integer embeddingDimension;
    @NonNull
    private final Boolean enableMultiTenant;
    public static final String FLAG_ROUTING_VALUES = "_flag_routing_values";
    public static final String FLAG_SKIP_WRAP_TENANT_IDS = "_flag_skip_wrap_tenant_ids";

    @Override
    public void putDocument(Document document) {
        ValidationUtils.ensureNotNull(document, "document");
        ValidationUtils.ensureNotNull(document.getDocumentId(), "documentId");
        this.checkDimension(document);
        this.checkEnableMultiTenant(document);
        PrimaryKeyBuilder primaryKeyBuilder = PrimaryKeyBuilder.createPrimaryKeyBuilder();
        primaryKeyBuilder.addPrimaryKeyColumn("document_id", PrimaryKeyValue.fromString((String)document.getDocumentId()));
        primaryKeyBuilder.addPrimaryKeyColumn("tenant_id", PrimaryKeyValue.fromString((String)document.getTenantId()));
        PrimaryKey primaryKey = primaryKeyBuilder.build();
        RowPutChange rowPutChange = new RowPutChange(this.tableName, primaryKey);
        List<Column> columns = TablestoreHelper.metadataToColumns(document.getMetadata());
        if (document.getText() != null) {
            columns.add(new Column(this.textField, ColumnValue.fromString((String)document.getText())));
        }
        if (document.getEmbedding() != null) {
            columns.add(new Column(this.embeddingField, ColumnValue.fromString((String)TablestoreHelper.encodeEmbedding(document.getEmbedding()))));
        }
        rowPutChange.addColumns(columns);
        try {
            this.client.putRow(new PutRowRequest(rowPutChange));
            if (log.isDebugEnabled()) {
                log.debug("put document:{}", (Object)document);
            }
        }
        catch (Exception e) {
            throw Exceptions.runtimeThrowable(String.format("put document:%s failed", document), e);
        }
    }

    @Override
    public void updateDocument(Document document) {
        ValidationUtils.ensureNotNull(document, "document");
        ValidationUtils.ensureNotNull(document.getDocumentId(), "documentId");
        this.checkDimension(document);
        this.checkEnableMultiTenant(document);
        PrimaryKeyBuilder primaryKeyBuilder = PrimaryKeyBuilder.createPrimaryKeyBuilder();
        primaryKeyBuilder.addPrimaryKeyColumn("document_id", PrimaryKeyValue.fromString((String)document.getDocumentId()));
        primaryKeyBuilder.addPrimaryKeyColumn("tenant_id", PrimaryKeyValue.fromString((String)document.getTenantId()));
        PrimaryKey primaryKey = primaryKeyBuilder.build();
        RowUpdateChange change = new RowUpdateChange(this.tableName, primaryKey);
        List<Column> columns = TablestoreHelper.metadataToColumns(document.getMetadata());
        if (document.getText() != null) {
            columns.add(new Column(this.textField, ColumnValue.fromString((String)document.getText())));
        }
        if (document.getEmbedding() != null) {
            columns.add(new Column(this.embeddingField, ColumnValue.fromString((String)TablestoreHelper.encodeEmbedding(document.getEmbedding()))));
        }
        change.put(columns);
        try {
            this.client.updateRow(new UpdateRowRequest(change));
            if (log.isDebugEnabled()) {
                log.debug("update document:{}", (Object)document);
            }
        }
        catch (Exception e) {
            throw Exceptions.runtimeThrowable(String.format("update document:%s failed", document), e);
        }
    }

    @Override
    public void deleteDocument(String documentId, String tenantId) {
        ValidationUtils.ensureNotNull(documentId, "documentId");
        if (this.enableMultiTenant.booleanValue() && (tenantId == null || "__default".equals(tenantId))) {
            List<String> tenantIds = this.getTenantIds(documentId);
            for (String getTenantId : tenantIds) {
                this.innerDelete(documentId, getTenantId);
            }
            return;
        }
        this.innerDelete(documentId, tenantId);
    }

    private void innerDelete(String documentId, String tenantId) {
        tenantId = this.checkEnableMultiTenantId(tenantId);
        PrimaryKeyBuilder primaryKeyBuilder = PrimaryKeyBuilder.createPrimaryKeyBuilder();
        primaryKeyBuilder.addPrimaryKeyColumn("document_id", PrimaryKeyValue.fromString((String)documentId));
        primaryKeyBuilder.addPrimaryKeyColumn("tenant_id", PrimaryKeyValue.fromString((String)tenantId));
        PrimaryKey primaryKey = primaryKeyBuilder.build();
        RowDeleteChange rowDeleteChange = new RowDeleteChange(this.tableName, primaryKey);
        rowDeleteChange.setCondition(new Condition(RowExistenceExpectation.IGNORE));
        try {
            this.client.deleteRow(new DeleteRowRequest(rowDeleteChange));
            if (log.isDebugEnabled()) {
                log.debug("delete session, documentId:{}, tenantId:{}", (Object)documentId, (Object)tenantId);
            }
        }
        catch (Exception e) {
            throw Exceptions.runtimeThrowable(String.format("delete session failed, documentId:%s, tenantId:%s", documentId, tenantId), e);
        }
    }

    @Override
    public void deleteDocument(String documentId) {
        this.deleteDocument(documentId, null);
    }

    @Override
    public void deleteDocumentByTenant(String tenantId) {
        HashSet<String> tenantIds = new HashSet<String>();
        if (tenantId != null) {
            tenantIds.add(tenantId);
        }
        this.deleteDocument(tenantIds, null);
    }

    @Override
    public void deleteDocument(Set<String> tenantIds, Filter metadataFilter) {
        Response<DocumentHit> response;
        log.info("delete document, tenantIds:{}, metadataFilter:{}", tenantIds, (Object)metadataFilter);
        String nextToken = null;
        do {
            Object knowledgeSearchRequest = ((KnowledgeSearchRequest.KnowledgeSearchRequestBuilder)((KnowledgeSearchRequest.KnowledgeSearchRequestBuilder)((KnowledgeSearchRequest.KnowledgeSearchRequestBuilder)((KnowledgeSearchRequest.KnowledgeSearchRequestBuilder)((KnowledgeSearchRequest.KnowledgeSearchRequestBuilder)KnowledgeSearchRequest.builder().tenantIds(tenantIds)).metadataFilter(metadataFilter)).limit(1000)).nextToken(nextToken)).columnsToGet(Arrays.asList("document_id", "tenant_id"))).build();
            response = this.searchDocuments((KnowledgeSearchRequest)knowledgeSearchRequest);
            List<DocumentHit> hits = response.getHits();
            TablestoreHelper.batchDelete(this.client, this.tableName, hits.iterator());
        } while ((nextToken = response.getNextToken()) != null);
    }

    @Override
    public void deleteAllDocuments() {
        log.info("delete all documents");
        Iterator<Document> documents = this.listAllDocuments();
        TablestoreHelper.batchDelete(this.client, this.tableName, documents);
    }

    @Override
    public Document getDocument(String documentId, String tenantId) {
        ValidationUtils.ensureNotNull(documentId, "documentId");
        tenantId = this.checkEnableMultiTenantId(tenantId);
        PrimaryKeyBuilder primaryKeyBuilder = PrimaryKeyBuilder.createPrimaryKeyBuilder();
        primaryKeyBuilder.addPrimaryKeyColumn("document_id", PrimaryKeyValue.fromString((String)documentId));
        primaryKeyBuilder.addPrimaryKeyColumn("tenant_id", PrimaryKeyValue.fromString((String)tenantId));
        PrimaryKey primaryKey = primaryKeyBuilder.build();
        SingleRowQueryCriteria criteria = new SingleRowQueryCriteria(this.tableName, primaryKey);
        criteria.setMaxVersions(1);
        try {
            GetRowResponse response = this.client.getRow(new GetRowRequest(criteria));
            Row row = response.getRow();
            Document document = TablestoreHelper.rowToDocument(row, this.textField, this.embeddingField);
            if (log.isDebugEnabled()) {
                log.debug("get document:{}", (Object)document);
            }
            return document;
        }
        catch (Exception e) {
            throw Exceptions.runtimeThrowable(String.format("get document failed, documentId:%s, tenantId:%s ", documentId, tenantId), e);
        }
    }

    @Override
    public Document getDocument(String documentId) {
        String tenantId = this.checkEnableMultiTenantId(null);
        return this.getDocument(documentId, tenantId);
    }

    @Override
    public List<Document> getDocuments(List<String> documentIdList, String tenantId) {
        log.info("get documents, documentIdList:{}, tenantId:{}", documentIdList, (Object)tenantId);
        String newTenantId = this.checkEnableMultiTenantId(tenantId);
        ArrayList<PrimaryKey> pkList = new ArrayList<PrimaryKey>(documentIdList.size());
        for (String docId : documentIdList) {
            PrimaryKeyBuilder primaryKeyBuilder = PrimaryKeyBuilder.createPrimaryKeyBuilder();
            primaryKeyBuilder.addPrimaryKeyColumn("document_id", PrimaryKeyValue.fromString((String)docId));
            primaryKeyBuilder.addPrimaryKeyColumn("tenant_id", PrimaryKeyValue.fromString((String)newTenantId));
            PrimaryKey primaryKey = primaryKeyBuilder.build();
            pkList.add(primaryKey);
        }
        List<Document> documents = TablestoreHelper.batchGetDocuments(this.client, this.tableName, pkList, this.textField, this.embeddingField);
        if (documents.size() != documentIdList.size()) {
            throw Exceptions.runtime("get documents failed, documentIdList[%s]:%s, tenantId:%s, documents:%s", documentIdList.size(), documentIdList, newTenantId, documents.size());
        }
        return documents;
    }

    @Override
    public List<Document> getDocuments(List<String> documentIdList) {
        return this.getDocuments(documentIdList, null);
    }

    @Override
    public Iterator<Document> listAllDocuments() {
        log.info("list all documents");
        PrimaryKey start = PrimaryKeyBuilder.createPrimaryKeyBuilder().addPrimaryKeyColumn("document_id", PrimaryKeyValue.INF_MIN).addPrimaryKeyColumn("tenant_id", PrimaryKeyValue.INF_MIN).build();
        PrimaryKey end = PrimaryKeyBuilder.createPrimaryKeyBuilder().addPrimaryKeyColumn("document_id", PrimaryKeyValue.INF_MAX).addPrimaryKeyColumn("tenant_id", PrimaryKeyValue.INF_MAX).build();
        return new TablestoreHelper.GetRangeIterator<Document>(this.client, this.tableName, row -> TablestoreHelper.rowToDocument(row, this.textField, this.embeddingField), start, end, null, Order.ASC, -1L, -1, null);
    }

    @Override
    public Response<DocumentHit> searchDocuments(KnowledgeSearchRequest searchRequest) {
        if (log.isDebugEnabled()) {
            log.debug("before search documents:{}", (Object)searchRequest);
        }
        ValidationUtils.ensureNotNull(searchRequest, "KnowledgeSearchRequest");
        Filter filter = this.wrapTenantIds(searchRequest.getTenantIds(), searchRequest.getMetadataFilter());
        Query query = TablestoreHelper.parserSearchFilters(filter);
        Sort otsSort = TablestoreHelper.toOtsSort(searchRequest.getSorts());
        byte[] nextToken = null;
        if (searchRequest.getNextToken() != null) {
            nextToken = Base64.getDecoder().decode(searchRequest.getNextToken());
        }
        SearchQuery searchQuery = SearchQuery.newBuilder().query(query).getTotalCount(false).limit(searchRequest.getLimit()).offset(0).sort(otsSort).token(nextToken).build();
        SearchRequest otsSearchRequest = new SearchRequest(this.tableName, this.searchIndexName, searchQuery);
        List<PrimaryKey> routingValues = this.getRoutingValues(searchRequest);
        if (!routingValues.isEmpty()) {
            otsSearchRequest.setRoutingValues(routingValues);
        }
        otsSearchRequest.setColumnsToGet(this.toColumnsToGet(searchRequest.getColumnsToGet()));
        try {
            SearchResponse searchResponse = this.client.search(otsSearchRequest);
            log.info("search documents:{}, request_id:{}", (Object)searchRequest, (Object)searchResponse.getRequestId());
            Triple<List<Document>, String, List<Double>> triple = TablestoreHelper.parserSearchResponse(searchResponse, r -> TablestoreHelper.rowToDocument(r, this.textField, this.embeddingField));
            List<Document> documents = triple.getLeft();
            String nextTokenStr = triple.getMiddle();
            List<Double> scores = triple.getRight();
            ArrayList<DocumentHit> documentHits = new ArrayList<DocumentHit>(documents.size());
            for (int i = 0; i < documents.size(); ++i) {
                documentHits.add(new DocumentHit(documents.get(i), scores.get(i)));
            }
            return new Response<DocumentHit>(documentHits, nextTokenStr);
        }
        catch (TableStoreException e) {
            throw Exceptions.runtimeThrowable(String.format("search documents failed, request_id:%s, query:[%s]", e.getRequestId(), searchRequest), e);
        }
        catch (Exception e) {
            throw Exceptions.runtimeThrowable(String.format("search documents failed, query:[%s]", searchRequest), e);
        }
    }

    @Override
    public Response<DocumentHit> fullTextSearch(String query, Set<String> tenantIds, int limit, Filter metadataFilter, String nextToken, List<String> columnsToGet) {
        TextMatch textMatch = Filters.textMatch(this.textField, query);
        metadataFilter = metadataFilter != null ? Filters.and(textMatch, metadataFilter) : textMatch;
        Object knowledgeSearchRequest = ((KnowledgeSearchRequest.KnowledgeSearchRequestBuilder)((KnowledgeSearchRequest.KnowledgeSearchRequestBuilder)((KnowledgeSearchRequest.KnowledgeSearchRequestBuilder)((KnowledgeSearchRequest.KnowledgeSearchRequestBuilder)((KnowledgeSearchRequest.KnowledgeSearchRequestBuilder)((KnowledgeSearchRequest.KnowledgeSearchRequestBuilder)KnowledgeSearchRequest.builder().tenantIds(tenantIds)).metadataFilter(metadataFilter)).limit(limit)).nextToken(nextToken)).columnsToGet(columnsToGet)).sorts(Collections.singletonList(((ScoreSort.ScoreSortBuilder)ScoreSort.builder().order(Order.DESC)).build()))).build();
        return this.searchDocuments((KnowledgeSearchRequest)knowledgeSearchRequest);
    }

    @Override
    public Response<DocumentHit> vectorSearch(float[] queryVector, int topK, Float minScore, Set<String> tenantIds, Filter metadataFilter, List<String> columnsToGet) {
        return this.vectorSearch(queryVector, topK, minScore, tenantIds, metadataFilter, columnsToGet, null);
    }

    public Response<DocumentHit> vectorSearch(float[] queryVector, int topK, Float minScore, Set<String> tenantIds, Filter metadataFilter, List<String> columnsToGet, Map<String, Object> varArgs) {
        Filter filter = varArgs != null && varArgs.containsKey(FLAG_SKIP_WRAP_TENANT_IDS) ? metadataFilter : this.wrapTenantIds(tenantIds, metadataFilter);
        VectorQuery vectorQuery = Filters.vectorQuery(this.embeddingField, queryVector).setTopK(topK).setFilter(filter).setMinScore(minScore);
        Object knowledgeSearchRequest = ((KnowledgeSearchRequest.KnowledgeSearchRequestBuilder)((KnowledgeSearchRequest.KnowledgeSearchRequestBuilder)((KnowledgeSearchRequest.KnowledgeSearchRequestBuilder)((KnowledgeSearchRequest.KnowledgeSearchRequestBuilder)((KnowledgeSearchRequest.KnowledgeSearchRequestBuilder)((KnowledgeSearchRequest.KnowledgeSearchRequestBuilder)((KnowledgeSearchRequest.KnowledgeSearchRequestBuilder)KnowledgeSearchRequest.builder().tenantIds(null)).metadataFilter(vectorQuery)).limit(topK)).nextToken(null)).columnsToGet(columnsToGet)).sorts(Collections.singletonList(((ScoreSort.ScoreSortBuilder)ScoreSort.builder().order(Order.DESC)).build()))).varArg(FLAG_ROUTING_VALUES, this.buildRouting(tenantIds))).build();
        return this.searchDocuments((KnowledgeSearchRequest)knowledgeSearchRequest);
    }

    @Override
    public boolean enableMultiTenant() {
        return this.enableMultiTenant;
    }

    @Override
    public void initTable() {
        TablestoreHelper.createTableIfNotExist(this.client, this.tableName, Arrays.asList(Pair.of("document_id", MetaType.STRING), Pair.of("tenant_id", MetaType.STRING)), Collections.emptyList());
        ArrayList<FieldSchema> messageSchemas = new ArrayList<FieldSchema>(this.metadataSchema);
        TablestoreHelper.addSchemaIfNotExist(messageSchemas, new FieldSchema("document_id", FieldType.KEYWORD));
        TablestoreHelper.addSchemaIfNotExist(messageSchemas, new FieldSchema("tenant_id", FieldType.KEYWORD));
        TablestoreHelper.addSchemaIfNotExist(messageSchemas, new FieldSchema(this.textField, FieldType.TEXT).setAnalyzer(FieldSchema.Analyzer.MaxWord));
        TablestoreHelper.addSchemaIfNotExist(messageSchemas, new FieldSchema(this.embeddingField, FieldType.VECTOR).setVectorOptions(new VectorOptions(VectorDataType.FLOAT_32, this.embeddingDimension.intValue(), this.embeddingMetricType)));
        ArrayList<String> routing = new ArrayList<String>();
        if (this.enableMultiTenant.booleanValue()) {
            routing.add("tenant_id");
        }
        TablestoreHelper.createSearchIndexIfNotExist(this.client, this.tableName, this.searchIndexName, messageSchemas, routing);
    }

    @Override
    public void deleteTableAndIndex() {
        TablestoreHelper.deleteTable(this.client, this.tableName);
    }

    private void checkDimension(Document document) {
        if (document == null || document.getEmbedding() == null) {
            return;
        }
        int actualDimension = document.getEmbedding().length;
        if (this.embeddingDimension != actualDimension) {
            throw Exceptions.illegalArgument("document's embedding embedding length:%s is not the same as the knowledge store dimension:%s, document id:%s", this.embeddingDimension, actualDimension, document.getDocumentId());
        }
    }

    private void checkEnableMultiTenant(Document document) {
        if (document == null) {
            return;
        }
        this.checkEnableMultiTenantId(document.getTenantId());
    }

    private String checkEnableMultiTenantId(String tenantId) {
        if (!this.enableMultiTenant.booleanValue()) {
            if (tenantId == null) {
                return "__default";
            }
            if (!"__default".equals(tenantId)) {
                throw Exceptions.illegalArgument("the multi-tenant capability is not enabled, but the 'tenant_id' is set", new Object[0]);
            }
        } else if ("__default".equals(tenantId) || tenantId == null) {
            throw Exceptions.illegalArgument("the multi-tenant capability is enabled, but the 'tenant_id' is not set", new Object[0]);
        }
        return tenantId;
    }

    private SearchRequest.ColumnsToGet toColumnsToGet(List<String> columnsToGet) {
        if (columnsToGet == null || columnsToGet.isEmpty()) {
            SearchRequest.ColumnsToGet otsColumnsToGet = new SearchRequest.ColumnsToGet();
            List<String> defaultColumnsToGet = this.getDefaultColumnsToGet();
            otsColumnsToGet.setColumns(defaultColumnsToGet);
            return otsColumnsToGet;
        }
        SearchRequest.ColumnsToGet otsColumnsToGet = new SearchRequest.ColumnsToGet();
        otsColumnsToGet.setColumns(columnsToGet);
        return otsColumnsToGet;
    }

    private List<String> getDefaultColumnsToGet() {
        ArrayList<String> defaultColumnsToGet = new ArrayList<String>();
        for (FieldSchema fieldSchema : this.metadataSchema) {
            if (fieldSchema.getFieldType().equals((Object)FieldType.VECTOR) || fieldSchema.getFieldName().equals(this.embeddingField)) continue;
            defaultColumnsToGet.add(fieldSchema.getFieldName());
        }
        defaultColumnsToGet.add("document_id");
        defaultColumnsToGet.add("tenant_id");
        defaultColumnsToGet.add(this.textField);
        return defaultColumnsToGet;
    }

    private Filter wrapTenantIds(Set<String> tenantIds, Filter metadataFilter) {
        if (this.enableMultiTenant.booleanValue()) {
            if (tenantIds == null || tenantIds.isEmpty()) {
                return metadataFilter;
            }
            if (tenantIds.size() == 1) {
                if (metadataFilter == null) {
                    return Filters.eq("tenant_id", tenantIds.iterator().next());
                }
                return Filters.and(Filters.eq("tenant_id", tenantIds.iterator().next()), metadataFilter);
            }
            if (metadataFilter == null) {
                return Filters.in("tenant_id", new ArrayList<String>(tenantIds));
            }
            return Filters.and(Filters.in("tenant_id", new ArrayList<String>(tenantIds)), metadataFilter);
        }
        if (tenantIds == null || tenantIds.isEmpty()) {
            return metadataFilter;
        }
        throw Exceptions.illegalArgument("the multi-tenant capability is not enabled, but the 'tenant id' is set", new Object[0]);
    }

    private List<PrimaryKey> buildRouting(Set<String> tenantIds) {
        if (!this.enableMultiTenant.booleanValue()) {
            if (tenantIds == null || tenantIds.isEmpty()) {
                return Collections.emptyList();
            }
            throw Exceptions.illegalArgument("the multi-tenant capability is not enabled, but the 'tenant id' is set", new Object[0]);
        }
        if (tenantIds == null || tenantIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PrimaryKey> routing = new ArrayList<PrimaryKey>(tenantIds.size());
        for (String tid : tenantIds) {
            PrimaryKeyBuilder primaryKeyBuilder = PrimaryKeyBuilder.createPrimaryKeyBuilder();
            primaryKeyBuilder.addPrimaryKeyColumn("tenant_id", PrimaryKeyValue.fromString((String)tid));
            routing.add(primaryKeyBuilder.build());
        }
        return routing;
    }

    private List<PrimaryKey> getRoutingValues(KnowledgeSearchRequest searchRequest) {
        if (searchRequest == null) {
            return Collections.emptyList();
        }
        if (searchRequest.getVarArgs() != null && searchRequest.getVarArgs().containsKey(FLAG_ROUTING_VALUES)) {
            return (List)searchRequest.getVarArgs().get(FLAG_ROUTING_VALUES);
        }
        return this.buildRouting(searchRequest.getTenantIds());
    }

    private List<String> getTenantIds(String documentId) {
        PrimaryKey start = PrimaryKeyBuilder.createPrimaryKeyBuilder().addPrimaryKeyColumn("document_id", PrimaryKeyValue.fromString((String)documentId)).addPrimaryKeyColumn("tenant_id", PrimaryKeyValue.INF_MIN).build();
        PrimaryKey end = PrimaryKeyBuilder.createPrimaryKeyBuilder().addPrimaryKeyColumn("document_id", PrimaryKeyValue.fromString((String)documentId)).addPrimaryKeyColumn("tenant_id", PrimaryKeyValue.INF_MAX).build();
        TablestoreHelper.GetRangeIterator<Document> iterator = new TablestoreHelper.GetRangeIterator<Document>(this.client, this.tableName, row -> TablestoreHelper.rowToDocument(row, this.textField, this.embeddingField), start, end, null, Order.ASC, -1L, -1, Arrays.asList("tenant_id", "document_id"));
        List<Document> documents = CollectionUtil.toList(iterator);
        ArrayList<String> tenantIds = new ArrayList<String>();
        for (Document document : documents) {
            if (document == null || document.getTenantId() == null) continue;
            tenantIds.add(document.getTenantId());
        }
        if (tenantIds.size() > 1) {
            log.warn("document id:{} has more than one tenant id:{}", (Object)documentId, tenantIds);
        }
        return tenantIds;
    }

    @Generated
    private static String $default$tableName() {
        return "knowledge";
    }

    @Generated
    private static String $default$searchIndexName() {
        return "knowledge_search_index_name";
    }

    @Generated
    private static List<FieldSchema> $default$metadataSchema() {
        return Collections.emptyList();
    }

    @Generated
    private static String $default$textField() {
        return "text";
    }

    @Generated
    private static String $default$embeddingField() {
        return "embedding";
    }

    @Generated
    private static VectorMetricType $default$embeddingMetricType() {
        return VectorMetricType.COSINE;
    }

    @Generated
    KnowledgeStoreImpl(SyncClient client, @NonNull String tableName, @NonNull String searchIndexName, @NonNull List<FieldSchema> metadataSchema, @NonNull String textField, @NonNull String embeddingField, @NonNull VectorMetricType embeddingMetricType, @NonNull Integer embeddingDimension, @NonNull Boolean enableMultiTenant) {
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        if (searchIndexName == null) {
            throw new NullPointerException("searchIndexName is marked non-null but is null");
        }
        if (metadataSchema == null) {
            throw new NullPointerException("metadataSchema is marked non-null but is null");
        }
        if (textField == null) {
            throw new NullPointerException("textField is marked non-null but is null");
        }
        if (embeddingField == null) {
            throw new NullPointerException("embeddingField is marked non-null but is null");
        }
        if (embeddingMetricType == null) {
            throw new NullPointerException("embeddingMetricType is marked non-null but is null");
        }
        if (embeddingDimension == null) {
            throw new NullPointerException("embeddingDimension is marked non-null but is null");
        }
        if (enableMultiTenant == null) {
            throw new NullPointerException("enableMultiTenant is marked non-null but is null");
        }
        this.client = client;
        this.tableName = tableName;
        this.searchIndexName = searchIndexName;
        this.metadataSchema = metadataSchema;
        this.textField = textField;
        this.embeddingField = embeddingField;
        this.embeddingMetricType = embeddingMetricType;
        this.embeddingDimension = embeddingDimension;
        this.enableMultiTenant = enableMultiTenant;
    }

    @Generated
    public static KnowledgeStoreImplBuilder builder() {
        return new KnowledgeStoreImplBuilder();
    }

    @Generated
    public SyncClient getClient() {
        return this.client;
    }

    @NonNull
    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @NonNull
    @Generated
    public String getSearchIndexName() {
        return this.searchIndexName;
    }

    @NonNull
    @Generated
    public List<FieldSchema> getMetadataSchema() {
        return this.metadataSchema;
    }

    @NonNull
    @Generated
    public String getTextField() {
        return this.textField;
    }

    @NonNull
    @Generated
    public String getEmbeddingField() {
        return this.embeddingField;
    }

    @NonNull
    @Generated
    public VectorMetricType getEmbeddingMetricType() {
        return this.embeddingMetricType;
    }

    @NonNull
    @Generated
    public Integer getEmbeddingDimension() {
        return this.embeddingDimension;
    }

    @NonNull
    @Generated
    public Boolean getEnableMultiTenant() {
        return this.enableMultiTenant;
    }

    @Generated
    public static class KnowledgeStoreImplBuilder {
        @Generated
        private SyncClient client;
        @Generated
        private boolean tableName$set;
        @Generated
        private String tableName$value;
        @Generated
        private boolean searchIndexName$set;
        @Generated
        private String searchIndexName$value;
        @Generated
        private boolean metadataSchema$set;
        @Generated
        private List<FieldSchema> metadataSchema$value;
        @Generated
        private boolean textField$set;
        @Generated
        private String textField$value;
        @Generated
        private boolean embeddingField$set;
        @Generated
        private String embeddingField$value;
        @Generated
        private boolean embeddingMetricType$set;
        @Generated
        private VectorMetricType embeddingMetricType$value;
        @Generated
        private Integer embeddingDimension;
        @Generated
        private Boolean enableMultiTenant;

        @Generated
        KnowledgeStoreImplBuilder() {
        }

        @Generated
        public KnowledgeStoreImplBuilder client(SyncClient client) {
            this.client = client;
            return this;
        }

        @Generated
        public KnowledgeStoreImplBuilder tableName(@NonNull String tableName) {
            if (tableName == null) {
                throw new NullPointerException("tableName is marked non-null but is null");
            }
            this.tableName$value = tableName;
            this.tableName$set = true;
            return this;
        }

        @Generated
        public KnowledgeStoreImplBuilder searchIndexName(@NonNull String searchIndexName) {
            if (searchIndexName == null) {
                throw new NullPointerException("searchIndexName is marked non-null but is null");
            }
            this.searchIndexName$value = searchIndexName;
            this.searchIndexName$set = true;
            return this;
        }

        @Generated
        public KnowledgeStoreImplBuilder metadataSchema(@NonNull List<FieldSchema> metadataSchema) {
            if (metadataSchema == null) {
                throw new NullPointerException("metadataSchema is marked non-null but is null");
            }
            this.metadataSchema$value = metadataSchema;
            this.metadataSchema$set = true;
            return this;
        }

        @Generated
        public KnowledgeStoreImplBuilder textField(@NonNull String textField) {
            if (textField == null) {
                throw new NullPointerException("textField is marked non-null but is null");
            }
            this.textField$value = textField;
            this.textField$set = true;
            return this;
        }

        @Generated
        public KnowledgeStoreImplBuilder embeddingField(@NonNull String embeddingField) {
            if (embeddingField == null) {
                throw new NullPointerException("embeddingField is marked non-null but is null");
            }
            this.embeddingField$value = embeddingField;
            this.embeddingField$set = true;
            return this;
        }

        @Generated
        public KnowledgeStoreImplBuilder embeddingMetricType(@NonNull VectorMetricType embeddingMetricType) {
            if (embeddingMetricType == null) {
                throw new NullPointerException("embeddingMetricType is marked non-null but is null");
            }
            this.embeddingMetricType$value = embeddingMetricType;
            this.embeddingMetricType$set = true;
            return this;
        }

        @Generated
        public KnowledgeStoreImplBuilder embeddingDimension(@NonNull Integer embeddingDimension) {
            if (embeddingDimension == null) {
                throw new NullPointerException("embeddingDimension is marked non-null but is null");
            }
            this.embeddingDimension = embeddingDimension;
            return this;
        }

        @Generated
        public KnowledgeStoreImplBuilder enableMultiTenant(@NonNull Boolean enableMultiTenant) {
            if (enableMultiTenant == null) {
                throw new NullPointerException("enableMultiTenant is marked non-null but is null");
            }
            this.enableMultiTenant = enableMultiTenant;
            return this;
        }

        @Generated
        public KnowledgeStoreImpl build() {
            String tableName$value = this.tableName$value;
            if (!this.tableName$set) {
                tableName$value = KnowledgeStoreImpl.$default$tableName();
            }
            String searchIndexName$value = this.searchIndexName$value;
            if (!this.searchIndexName$set) {
                searchIndexName$value = KnowledgeStoreImpl.$default$searchIndexName();
            }
            List metadataSchema$value = this.metadataSchema$value;
            if (!this.metadataSchema$set) {
                metadataSchema$value = KnowledgeStoreImpl.$default$metadataSchema();
            }
            String textField$value = this.textField$value;
            if (!this.textField$set) {
                textField$value = KnowledgeStoreImpl.$default$textField();
            }
            String embeddingField$value = this.embeddingField$value;
            if (!this.embeddingField$set) {
                embeddingField$value = KnowledgeStoreImpl.$default$embeddingField();
            }
            VectorMetricType embeddingMetricType$value = this.embeddingMetricType$value;
            if (!this.embeddingMetricType$set) {
                embeddingMetricType$value = KnowledgeStoreImpl.$default$embeddingMetricType();
            }
            return new KnowledgeStoreImpl(this.client, tableName$value, searchIndexName$value, metadataSchema$value, textField$value, embeddingField$value, embeddingMetricType$value, this.embeddingDimension, this.enableMultiTenant);
        }

        @Generated
        public String toString() {
            return "KnowledgeStoreImpl.KnowledgeStoreImplBuilder(client=" + this.client + ", tableName$value=" + this.tableName$value + ", searchIndexName$value=" + this.searchIndexName$value + ", metadataSchema$value=" + this.metadataSchema$value + ", textField$value=" + this.textField$value + ", embeddingField$value=" + this.embeddingField$value + ", embeddingMetricType$value=" + this.embeddingMetricType$value + ", embeddingDimension=" + this.embeddingDimension + ", enableMultiTenant=" + this.enableMultiTenant + ")";
        }
    }
}

