/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.document.parser;

import com.agentsflex.core.document.Document;
import com.agentsflex.core.document.DocumentParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;

public class PdfBoxDocumentParser
implements DocumentParser {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document parse(InputStream stream) {
        try (PDDocument pdfDocument = PDDocument.load((InputStream)stream);){
            PDFTextStripper stripper = new PDFTextStripper();
            String text = stripper.getText(pdfDocument);
            Document document = new Document(text);
            return document;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Document> parseWithPage(InputStream inputStream) {
        try (PDDocument pdfDocument = PDDocument.load((InputStream)inputStream);){
            List<Document> list = this.getDocuments(pdfDocument);
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<Document> getDocuments(PDDocument pdDocument) throws IOException {
        ArrayList<Document> documents = new ArrayList<Document>();
        int pageCount = pdDocument.getNumberOfPages();
        for (int pageNumber = 1; pageNumber <= pageCount; ++pageNumber) {
            PDFTextStripper stripper = new PDFTextStripper();
            stripper.setStartPage(pageNumber);
            stripper.setEndPage(pageNumber);
            String content = stripper.getText(pdDocument);
            Document document = new Document();
            document.setContent(content);
            document.addMetadata("pageNumber", (Object)pageNumber);
            documents.add(document);
        }
        return documents;
    }
}

