/*
 * Decompiled with CFR 0.152.
 */
package com.xsxx.sms;

import cn.hutool.json.JSONUtil;
import com.xsxx.sms.BaseApi;
import com.xsxx.sms.model.BatchSubmitResp;
import com.xsxx.sms.model.DeliverResp;
import com.xsxx.sms.model.ReportResp;
import com.xsxx.sms.model.Sms;
import com.xsxx.sms.model.SubmitResp;
import com.xsxx.sms.security.MD5Util;
import com.xsxx.sms.util.SmsUtil;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.ConnectionPool;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

@Deprecated
public class V2Client
implements BaseApi {
    protected OkHttpClient okHttpClient;
    protected int MAX_REQUESTS_PER_HOST = 10;
    protected String URI_SUBMIT;
    @Deprecated
    protected String URI_BATCHSUBMIT;
    protected String URI_REPORT;
    protected String URI_DELIVRD;
    protected String URI_BALANCE;
    protected String URI_DAILY_STATS;
    protected String token;

    public V2Client(String url, String username, String token, Integer requestPerHost, String fetchURL) throws IllegalArgumentException {
        if (!SmsUtil.isURL(url) || username == null || token == null) {
            throw new IllegalArgumentException();
        }
        this.token = MD5Util.MD5(token);
        this.okHttpClient = new OkHttpClient.Builder().connectTimeout(5L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).retryOnConnectionFailure(true).connectionPool(new ConnectionPool(200, 10L, TimeUnit.SECONDS)).build();
        if (requestPerHost != null && requestPerHost > 5 && requestPerHost < this.okHttpClient.dispatcher().getMaxRequests()) {
            this.MAX_REQUESTS_PER_HOST = requestPerHost;
        }
        this.okHttpClient.dispatcher().setMaxRequestsPerHost(this.MAX_REQUESTS_PER_HOST);
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        this.URI_SUBMIT = url + "websms/smsJsonService?action=sendsms&userId=" + username;
        this.URI_BATCHSUBMIT = url + "batchwebsms/smsJsonService?userId=" + username;
        if (SmsUtil.isURL(fetchURL)) {
            this.URI_REPORT = fetchURL + "websms/smsJsonService?action=getsendreport&userId=" + username;
            this.URI_DELIVRD = fetchURL + "websms/smsJsonService?action=getdeliver&userId=" + username;
        }
    }

    public V2Client(String url, String username, String token, Integer requestPerHost) throws IllegalArgumentException {
        this(url, username, token, requestPerHost, null);
    }

    public V2Client(String url, String username, String token) throws IllegalArgumentException {
        this(url, username, token, null, null);
    }

    @Override
    public boolean submit(Sms sms, final Consumer<SubmitResp> consumer) {
        Request request = this.makeRequest(sms);
        if (this.okHttpClient.dispatcher().queuedCallsCount() < this.MAX_REQUESTS_PER_HOST) {
            this.okHttpClient.newCall(request).enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    SubmitResp submitResp = new SubmitResp();
                    submitResp.setStatus(-1);
                    submitResp.setMsg(e.getMessage());
                    consumer.accept(submitResp);
                }

                public void onResponse(Call call, Response response) throws IOException {
                    consumer.accept(JSONUtil.toBean((String)response.body().string(), SubmitResp.class));
                    response.body().close();
                }
            });
            return false;
        }
        SubmitResp resp = new SubmitResp();
        try {
            Response response = this.okHttpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                resp = (SubmitResp)JSONUtil.toBean((String)response.body().string(), SubmitResp.class);
            } else {
                resp.setStatus(response.code());
                resp.setMsg(response.message());
            }
        }
        catch (IOException e) {
            resp.setStatus(-1);
            resp.setMsg(e.getMessage());
        }
        consumer.accept(resp);
        return true;
    }

    @Override
    public ReportResp getReport() {
        if (this.URI_REPORT == null) {
            return null;
        }
        Request request = this.makeRequest(this.URI_REPORT);
        ReportResp resp = new ReportResp();
        try {
            Response response = this.okHttpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                resp = (ReportResp)JSONUtil.toBean((String)response.body().string(), ReportResp.class);
            } else {
                resp.setStatus(response.code());
                resp.setMsg(response.message());
            }
        }
        catch (IOException e) {
            resp.setStatus(-1);
            resp.setMsg(e.getMessage());
        }
        return resp;
    }

    @Override
    public DeliverResp getDeliver() {
        if (this.URI_DELIVRD == null) {
            return null;
        }
        Request request = this.makeRequest(this.URI_DELIVRD);
        DeliverResp resp = new DeliverResp();
        try {
            Response response = this.okHttpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                resp = (DeliverResp)JSONUtil.toBean((String)response.body().string(), DeliverResp.class);
            } else {
                resp.setStatus(response.code());
                resp.setMsg(response.message());
            }
        }
        catch (IOException e) {
            resp.setStatus(-1);
            resp.setMsg(e.getMessage());
        }
        return resp;
    }

    @Override
    @Deprecated
    public BatchSubmitResp submit(List<Sms> smsContents) {
        Request request = this.makeRequest(smsContents);
        BatchSubmitResp resp = new BatchSubmitResp();
        try {
            Response response = this.okHttpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                resp = (BatchSubmitResp)JSONUtil.toBean((String)response.body().string(), BatchSubmitResp.class);
            } else {
                resp.setStatus(response.code());
                resp.setMsg(response.message());
            }
        }
        catch (IOException e) {
            resp.setStatus(-1);
            resp.setMsg(e.getMessage());
        }
        return resp;
    }

    protected Request makeRequest(Sms sms) {
        FormBody.Builder builder = new FormBody.Builder().add("md5password", this.token).add("content", sms.getContent()).add("mobile", sms.getMobile());
        if (sms.getExtCode() != null) {
            builder.add("extCode", sms.getExtCode());
        }
        if (sms.getMsgId() != null) {
            builder.add("msgId", sms.getMsgId().toString());
        }
        FormBody requestBody = builder.build();
        return new Request.Builder().url(this.URI_SUBMIT).post((RequestBody)requestBody).build();
    }

    @Deprecated
    protected Request makeRequest(List<Sms> smsContents) {
        FormBody.Builder builder = new FormBody.Builder().add("md5password", this.token).add("contentArr", JSONUtil.toJsonStr(smsContents));
        FormBody requestBody = builder.build();
        builder.build();
        return new Request.Builder().url(this.URI_BATCHSUBMIT).post((RequestBody)requestBody).build();
    }

    @Deprecated
    protected Request makeRequest(String url) {
        FormBody.Builder builder = new FormBody.Builder().add("md5password", this.token);
        FormBody requestBody = builder.build();
        return new Request.Builder().url(url).post((RequestBody)requestBody).build();
    }
}

