/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.strategy;

import cn.dev33.satoken.annotation.SaCheckDisable;
import cn.dev33.satoken.annotation.SaCheckHttpBasic;
import cn.dev33.satoken.annotation.SaCheckHttpDigest;
import cn.dev33.satoken.annotation.SaCheckLogin;
import cn.dev33.satoken.annotation.SaCheckOr;
import cn.dev33.satoken.annotation.SaCheckPermission;
import cn.dev33.satoken.annotation.SaCheckRole;
import cn.dev33.satoken.annotation.SaCheckSafe;
import cn.dev33.satoken.annotation.SaIgnore;
import cn.dev33.satoken.annotation.handler.SaAnnotationHandlerInterface;
import cn.dev33.satoken.annotation.handler.SaCheckDisableHandler;
import cn.dev33.satoken.annotation.handler.SaCheckHttpBasicHandler;
import cn.dev33.satoken.annotation.handler.SaCheckHttpDigestHandler;
import cn.dev33.satoken.annotation.handler.SaCheckLoginHandler;
import cn.dev33.satoken.annotation.handler.SaCheckOrHandler;
import cn.dev33.satoken.annotation.handler.SaCheckPermissionHandler;
import cn.dev33.satoken.annotation.handler.SaCheckRoleHandler;
import cn.dev33.satoken.annotation.handler.SaCheckSafeHandler;
import cn.dev33.satoken.annotation.handler.SaIgnoreHandler;
import cn.dev33.satoken.fun.strategy.SaCheckMethodAnnotationFunction;
import cn.dev33.satoken.fun.strategy.SaGetAnnotationFunction;
import cn.dev33.satoken.fun.strategy.SaIsAnnotationPresentFunction;
import cn.dev33.satoken.listener.SaTokenEventCenter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SaAnnotationStrategy {
    public static final SaAnnotationStrategy instance = new SaAnnotationStrategy();
    public Map<Class<?>, SaAnnotationHandlerInterface<?>> annotationHandlerMap = new LinkedHashMap();
    public SaCheckMethodAnnotationFunction checkMethodAnnotation = method -> {
        for (Map.Entry<Class<?>, SaAnnotationHandlerInterface<?>> entry : this.annotationHandlerMap.entrySet()) {
            Annotation methodTakeAnnotation;
            Annotation classTakeAnnotation = (Annotation)SaAnnotationStrategy.instance.getAnnotation.apply(method.getDeclaringClass(), entry.getKey());
            if (classTakeAnnotation != null) {
                entry.getValue().check(classTakeAnnotation, (Method)method);
            }
            if ((methodTakeAnnotation = (Annotation)SaAnnotationStrategy.instance.getAnnotation.apply(method, entry.getKey())) == null) continue;
            entry.getValue().check(methodTakeAnnotation, (Method)method);
        }
    };
    public SaGetAnnotationFunction getAnnotation = (element, annotationClass) -> element.getAnnotation(annotationClass);
    public SaIsAnnotationPresentFunction isAnnotationPresent = (method, annotationClass) -> SaAnnotationStrategy.instance.getAnnotation.apply(method, annotationClass) != null || SaAnnotationStrategy.instance.getAnnotation.apply(method.getDeclaringClass(), annotationClass) != null;

    private SaAnnotationStrategy() {
        this.registerDefaultAnnotationHandler();
    }

    public void registerDefaultAnnotationHandler() {
        this.annotationHandlerMap.put(SaIgnore.class, new SaIgnoreHandler());
        this.annotationHandlerMap.put(SaCheckLogin.class, new SaCheckLoginHandler());
        this.annotationHandlerMap.put(SaCheckRole.class, new SaCheckRoleHandler());
        this.annotationHandlerMap.put(SaCheckPermission.class, new SaCheckPermissionHandler());
        this.annotationHandlerMap.put(SaCheckSafe.class, new SaCheckSafeHandler());
        this.annotationHandlerMap.put(SaCheckDisable.class, new SaCheckDisableHandler());
        this.annotationHandlerMap.put(SaCheckHttpBasic.class, new SaCheckHttpBasicHandler());
        this.annotationHandlerMap.put(SaCheckHttpDigest.class, new SaCheckHttpDigestHandler());
        this.annotationHandlerMap.put(SaCheckOr.class, new SaCheckOrHandler());
    }

    public void registerAnnotationHandler(SaAnnotationHandlerInterface<?> handler) {
        this.annotationHandlerMap.put(handler.getHandlerAnnotationClass(), handler);
        SaTokenEventCenter.doRegisterAnnotationHandler(handler);
    }

    public void registerAnnotationHandlerToFirst(SaAnnotationHandlerInterface<?> handler) {
        LinkedHashMap newMap = new LinkedHashMap();
        newMap.put(handler.getHandlerAnnotationClass(), handler);
        newMap.putAll(this.annotationHandlerMap);
        this.annotationHandlerMap = newMap;
        SaTokenEventCenter.doRegisterAnnotationHandler(handler);
    }

    public void removeAnnotationHandler(Class<?> cls) {
        this.annotationHandlerMap.remove(cls);
    }
}

