/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.secure;

import cn.dev33.satoken.exception.SaTokenException;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class SaSecureUtil {
    private static final Base64.Encoder encoder = Base64.getEncoder();
    private static final Base64.Decoder decoder = Base64.getDecoder();
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";
    private static final String ALGORITHM = "RSA";
    private static final int KEY_SIZE = 1024;

    private SaSecureUtil() {
    }

    public static String md5(String str) {
        str = str == null ? "" : str;
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            byte[] btInput = str.getBytes();
            MessageDigest mdInst = MessageDigest.getInstance("MD5");
            mdInst.update(btInput);
            byte[] md = mdInst.digest();
            int j = md.length;
            char[] strA = new char[j * 2];
            int k = 0;
            for (byte byte0 : md) {
                strA[k++] = hexDigits[byte0 >>> 4 & 0xF];
                strA[k++] = hexDigits[byte0 & 0xF];
            }
            return new String(strA);
        }
        catch (Exception e) {
            throw new SaTokenException(e).setCode(12111);
        }
    }

    public static String sha1(String str) {
        try {
            str = str == null ? "" : str;
            MessageDigest md = MessageDigest.getInstance("SHA1");
            byte[] b = str.getBytes();
            md.update(b);
            byte[] b2 = md.digest();
            int len = b2.length;
            String strA = "0123456789abcdef";
            char[] ch = strA.toCharArray();
            char[] chs = new char[len * 2];
            int k = 0;
            for (int i = 0; i < len; ++i) {
                byte b3 = b2[i];
                chs[k++] = ch[b3 >>> 4 & 0xF];
                chs[k++] = ch[b3 & 0xF];
            }
            return new String(chs);
        }
        catch (Exception e) {
            throw new SaTokenException(e).setCode(12112);
        }
    }

    public static String sha256(String str) {
        try {
            str = str == null ? "" : str;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(str.getBytes(StandardCharsets.UTF_8));
            byte[] bytes = messageDigest.digest();
            StringBuilder builder = new StringBuilder();
            for (byte aByte : bytes) {
                String temp = Integer.toHexString(aByte & 0xFF);
                if (temp.length() == 1) {
                    builder.append("0");
                }
                builder.append(temp);
            }
            return builder.toString();
        }
        catch (Exception e) {
            throw new SaTokenException(e).setCode(12113);
        }
    }

    public static String md5BySalt(String str, String salt) {
        return SaSecureUtil.md5(SaSecureUtil.md5(str) + SaSecureUtil.md5(salt));
    }

    public static String aesEncrypt(String key, String text) {
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            byte[] byteContent = text.getBytes(StandardCharsets.UTF_8);
            cipher.init(1, SaSecureUtil.getSecretKey(key));
            byte[] result = cipher.doFinal(byteContent);
            return encoder.encodeToString(result);
        }
        catch (Exception e) {
            throw new SaTokenException(e).setCode(12114);
        }
    }

    public static String aesDecrypt(String key, String text) {
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            cipher.init(2, SaSecureUtil.getSecretKey(key));
            byte[] result = cipher.doFinal(decoder.decode(text));
            return new String(result, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new SaTokenException(e).setCode(12115);
        }
    }

    private static SecretKeySpec getSecretKey(String password) throws NoSuchAlgorithmException {
        KeyGenerator kg = KeyGenerator.getInstance("AES");
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        random.setSeed(password.getBytes());
        kg.init(128, random);
        SecretKey secretKey = kg.generateKey();
        return new SecretKeySpec(secretKey.getEncoded(), "AES");
    }

    public static HashMap<String, String> rsaGenerateKeyPair() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(ALGORITHM);
        keyPairGenerator.initialize(1024, new SecureRandom(UUID.randomUUID().toString().replaceAll("-", "").getBytes()));
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        RSAPublicKey rsaPublicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)keyPair.getPrivate();
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("private", encoder.encodeToString(rsaPrivateKey.getEncoded()));
        map.put("public", encoder.encodeToString(rsaPublicKey.getEncoded()));
        return map;
    }

    public static String rsaEncryptByPublic(String publicKeyString, String content) {
        try {
            PublicKey publicKey = SaSecureUtil.getPublicKeyFromString(publicKeyString);
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(1, publicKey);
            int splitLength = ((RSAPublicKey)publicKey).getModulus().bitLength() / 8 - 11;
            byte[][] arrays = SaSecureUtil.splitBytes(content.getBytes(), splitLength);
            StringBuilder stringBuilder = new StringBuilder();
            for (byte[] array : arrays) {
                stringBuilder.append(SaSecureUtil.bytesToHexString(cipher.doFinal(array)));
            }
            return stringBuilder.toString();
        }
        catch (Exception e) {
            throw new SaTokenException(e).setCode(12116);
        }
    }

    public static String rsaEncryptByPrivate(String privateKeyString, String content) {
        try {
            PrivateKey privateKey = SaSecureUtil.getPrivateKeyFromString(privateKeyString);
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(1, privateKey);
            int splitLength = ((RSAPrivateKey)privateKey).getModulus().bitLength() / 8 - 11;
            byte[][] arrays = SaSecureUtil.splitBytes(content.getBytes(), splitLength);
            StringBuilder stringBuilder = new StringBuilder();
            for (byte[] array : arrays) {
                stringBuilder.append(SaSecureUtil.bytesToHexString(cipher.doFinal(array)));
            }
            return stringBuilder.toString();
        }
        catch (Exception e) {
            throw new SaTokenException(e).setCode(12117);
        }
    }

    public static String rsaDecryptByPublic(String publicKeyString, String content) {
        try {
            PublicKey publicKey = SaSecureUtil.getPublicKeyFromString(publicKeyString);
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(2, publicKey);
            int splitLength = ((RSAPublicKey)publicKey).getModulus().bitLength() / 8;
            byte[] contentBytes = SaSecureUtil.hexStringToBytes(content);
            byte[][] arrays = SaSecureUtil.splitBytes(contentBytes, splitLength);
            StringBuilder stringBuilder = new StringBuilder();
            for (byte[] array : arrays) {
                stringBuilder.append(new String(cipher.doFinal(array)));
            }
            return stringBuilder.toString();
        }
        catch (Exception e) {
            throw new SaTokenException(e).setCode(12118);
        }
    }

    public static String rsaDecryptByPrivate(String privateKeyString, String content) {
        try {
            PrivateKey privateKey = SaSecureUtil.getPrivateKeyFromString(privateKeyString);
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(2, privateKey);
            int splitLength = ((RSAPrivateKey)privateKey).getModulus().bitLength() / 8;
            byte[] contentBytes = SaSecureUtil.hexStringToBytes(content);
            byte[][] arrays = SaSecureUtil.splitBytes(contentBytes, splitLength);
            StringBuilder stringBuilder = new StringBuilder();
            for (byte[] array : arrays) {
                stringBuilder.append(new String(cipher.doFinal(array)));
            }
            return stringBuilder.toString();
        }
        catch (Exception e) {
            throw new SaTokenException(e).setCode(12119);
        }
    }

    private static PublicKey getPublicKeyFromString(String key) throws NoSuchAlgorithmException, InvalidKeySpecException {
        key = key.replace("\r\n", "");
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(decoder.decode(key));
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
        return keyFactory.generatePublic(x509KeySpec);
    }

    private static PrivateKey getPrivateKeyFromString(String key) throws NoSuchAlgorithmException, InvalidKeySpecException {
        key = key.replace("\r\n", "");
        PKCS8EncodedKeySpec x509KeySpec = new PKCS8EncodedKeySpec(decoder.decode(key));
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
        return keyFactory.generatePrivate(x509KeySpec);
    }

    private static byte[][] splitBytes(byte[] bytes, int splitLength) {
        int remainder = bytes.length % splitLength;
        int quotient = remainder != 0 ? bytes.length / splitLength + 1 : bytes.length / splitLength;
        byte[][] arrays = new byte[quotient][];
        for (int i = 0; i < quotient; ++i) {
            byte[] array;
            if (i == quotient - 1 && remainder != 0) {
                array = new byte[remainder];
                System.arraycopy(bytes, i * splitLength, array, 0, remainder);
            } else {
                array = new byte[splitLength];
                System.arraycopy(bytes, i * splitLength, array, 0, splitLength);
            }
            arrays[i] = array;
        }
        return arrays;
    }

    private static String bytesToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length);
        for (byte aByte : bytes) {
            String temp = Integer.toHexString(0xFF & aByte);
            if (temp.length() < 2) {
                sb.append(0);
            }
            sb.append(temp);
        }
        return sb.toString();
    }

    private static byte[] hexStringToBytes(String hex) {
        int len = hex.length() / 2;
        hex = hex.toUpperCase();
        byte[] result = new byte[len];
        char[] chars = hex.toCharArray();
        for (int i = 0; i < len; ++i) {
            int pos = i * 2;
            result[i] = (byte)(SaSecureUtil.toByte(chars[pos]) << 4 | SaSecureUtil.toByte(chars[pos + 1]));
        }
        return result;
    }

    private static byte toByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }
}

