/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.sso;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.config.SaSsoConfig;
import cn.dev33.satoken.exception.SaTokenException;
import cn.dev33.satoken.session.SaSession;
import cn.dev33.satoken.sso.SaSsoConsts;
import cn.dev33.satoken.stp.StpLogic;
import cn.dev33.satoken.strategy.SaStrategy;
import cn.dev33.satoken.util.SaFoxUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SaSsoTemplate {
    public StpLogic stpLogic;

    public SaSsoTemplate(StpLogic stpLogic) {
        this.stpLogic = stpLogic;
    }

    public String createTicket(Object loginId) {
        String ticket = this.randomTicket(loginId);
        this.saveTicket(ticket, loginId);
        this.saveTicketIndex(ticket, loginId);
        return ticket;
    }

    public void saveTicket(String ticket, Object loginId) {
        long ticketTimeout = SaManager.getConfig().getSso().getTicketTimeout();
        SaManager.getSaTokenDao().set(this.splicingTicketSaveKey(ticket), String.valueOf(loginId), ticketTimeout);
    }

    public void saveTicketIndex(String ticket, Object loginId) {
        long ticketTimeout = SaManager.getConfig().getSso().getTicketTimeout();
        SaManager.getSaTokenDao().set(this.splicingTicketIndexKey(loginId), String.valueOf(ticket), ticketTimeout);
    }

    public void deleteTicket(String ticket) {
        if (ticket == null) {
            return;
        }
        SaManager.getSaTokenDao().delete(this.splicingTicketSaveKey(ticket));
    }

    public void deleteTicketIndex(Object loginId) {
        if (loginId == null) {
            return;
        }
        SaManager.getSaTokenDao().delete(this.splicingTicketIndexKey(loginId));
    }

    public Object getLoginId(String ticket) {
        if (SaFoxUtil.isEmpty(ticket)) {
            return null;
        }
        return SaManager.getSaTokenDao().get(this.splicingTicketSaveKey(ticket));
    }

    public <T> T getLoginId(String ticket, Class<T> cs) {
        return SaFoxUtil.getValueByType(this.getLoginId(ticket), cs);
    }

    public String getTicketValue(Object loginId) {
        if (loginId == null) {
            return null;
        }
        return SaManager.getSaTokenDao().get(this.splicingTicketIndexKey(loginId));
    }

    public Object checkTicket(String ticket) {
        Object loginId = this.getLoginId(ticket);
        if (loginId != null) {
            this.deleteTicket(ticket);
            this.deleteTicketIndex(loginId);
        }
        return loginId;
    }

    public String randomTicket(Object loginId) {
        return SaFoxUtil.getRandomString(64);
    }

    public String buildServerAuthUrl(String clientLoginUrl, String back) {
        String serverUrl = SaManager.getConfig().getSso().getAuthUrl();
        back = back == null ? "" : back;
        back = SaFoxUtil.encodeUrl(back);
        clientLoginUrl = SaFoxUtil.joinParam(clientLoginUrl, SaSsoConsts.ParamName.back, back);
        String serverAuthUrl = SaFoxUtil.joinParam(serverUrl, SaSsoConsts.ParamName.redirect, clientLoginUrl);
        return serverAuthUrl;
    }

    public String buildRedirectUrl(Object loginId, String redirect) {
        this.checkRedirectUrl(redirect);
        this.deleteTicket(this.getTicketValue(loginId));
        String ticket = this.createTicket(loginId);
        return SaFoxUtil.joinParam(this.encodeBackParam(redirect), SaSsoConsts.ParamName.ticket, ticket);
    }

    public void checkRedirectUrl(String url) {
        List<String> authUrlList;
        if (!SaFoxUtil.isUrl(url)) {
            throw new SaTokenException("\u65e0\u6548redirect\uff1a" + url);
        }
        int qIndex = url.indexOf("?");
        if (qIndex != -1) {
            url = url.substring(0, qIndex);
        }
        if (!SaStrategy.me.hasElement.apply(authUrlList = Arrays.asList(this.getAllowUrl().replaceAll(" ", "").split(",")), url).booleanValue()) {
            throw new SaTokenException("\u975e\u6cd5redirect\uff1a" + url);
        }
    }

    public String getAllowUrl() {
        return SaManager.getConfig().getSso().getAllowUrl();
    }

    public String encodeBackParam(String url) {
        int index = url.indexOf("?" + SaSsoConsts.ParamName.back + "=");
        if (index == -1 && (index = url.indexOf("&" + SaSsoConsts.ParamName.back + "=")) == -1) {
            return url;
        }
        int length = SaSsoConsts.ParamName.back.length() + 2;
        String back = url.substring(index + length);
        back = SaFoxUtil.encodeUrl(back);
        url = url.substring(0, index + length) + back;
        return url;
    }

    public String buildUserinfoUrl(Object loginId) {
        String userinfoUrl = SaManager.getConfig().getSso().getUserinfoUrl();
        userinfoUrl = SaFoxUtil.joinParam(userinfoUrl, SaSsoConsts.ParamName.loginId, loginId);
        userinfoUrl = SaFoxUtil.joinParam(userinfoUrl, SaSsoConsts.ParamName.secretkey, SaManager.getConfig().getSso().getSecretkey());
        return userinfoUrl;
    }

    public void checkSecretkey(String secretkey) {
        if (secretkey == null || secretkey.isEmpty() || !secretkey.equals(SaManager.getConfig().getSso().getSecretkey())) {
            throw new SaTokenException("\u65e0\u6548\u79d8\u94a5\uff1a" + secretkey);
        }
    }

    public String buildCheckTicketUrl(String ticket, String ssoLogoutCallUrl) {
        String url = SaManager.getConfig().getSso().getCheckTicketUrl();
        url = SaFoxUtil.joinParam(url, SaSsoConsts.ParamName.ticket, ticket);
        if (ssoLogoutCallUrl != null) {
            url = SaFoxUtil.joinParam(url, SaSsoConsts.ParamName.ssoLogoutCall, ssoLogoutCallUrl);
        }
        return url;
    }

    public void registerSloCallbackUrl(Object loginId, String sloCallbackUrl) {
        if (loginId == null || sloCallbackUrl == null || sloCallbackUrl.isEmpty()) {
            return;
        }
        SaSession session = this.stpLogic.getSessionByLoginId(loginId);
        Set urlSet = (Set)session.get("SLO_CALLBACK_SET_KEY_", () -> new HashSet());
        urlSet.add(sloCallbackUrl);
        session.set("SLO_CALLBACK_SET_KEY_", urlSet);
    }

    public void forEachSloUrl(Object loginId, CallSloUrlFunction fun) {
        SaSession session = this.stpLogic.getSessionByLoginId(loginId, false);
        if (session == null) {
            return;
        }
        String secretkey = SaManager.getConfig().getSso().getSecretkey();
        Set urlSet = (Set)session.get("SLO_CALLBACK_SET_KEY_", () -> new HashSet());
        for (String url : urlSet) {
            url = SaFoxUtil.joinParam(url, SaSsoConsts.ParamName.loginId, loginId);
            url = SaFoxUtil.joinParam(url, SaSsoConsts.ParamName.secretkey, secretkey);
            fun.run(url);
        }
    }

    public String buildSloUrl(Object loginId) {
        SaSsoConfig ssoConfig = SaManager.getConfig().getSso();
        String url = ssoConfig.getSloUrl();
        url = SaFoxUtil.joinParam(url, SaSsoConsts.ParamName.loginId, loginId);
        url = SaFoxUtil.joinParam(url, SaSsoConsts.ParamName.secretkey, ssoConfig.getSecretkey());
        return url;
    }

    public void singleLogout(String secretkey, Object loginId, CallSloUrlFunction fun) {
        this.checkSecretkey(secretkey);
        this.forEachSloUrl(loginId, fun);
        this.stpLogic.logoutByTokenValue(this.stpLogic.getTokenValueByLoginId(loginId));
    }

    public Object getUserinfo(Object loginId) {
        String url = this.buildUserinfoUrl(loginId);
        return SaManager.getConfig().getSso().sendHttp.apply(url);
    }

    public String splicingTicketSaveKey(String ticket) {
        return SaManager.getConfig().getTokenName() + ":ticket:" + ticket;
    }

    public String splicingTicketIndexKey(Object id) {
        return SaManager.getConfig().getTokenName() + ":id-ticket:" + id;
    }

    @FunctionalInterface
    public static interface CallSloUrlFunction {
        public void run(String var1);
    }
}

