/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.context.model;

import cn.dev33.satoken.exception.SaTokenException;
import cn.dev33.satoken.util.SaFoxUtil;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

public class SaCookie {
    public static final String HEADER_NAME = "Set-Cookie";
    private String name;
    private String value;
    private int maxAge = -1;
    private String domain;
    private String path;
    private Boolean secure = false;
    private Boolean httpOnly = false;
    private String sameSite;

    public SaCookie() {
    }

    public SaCookie(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public SaCookie setName(String name) {
        this.name = name;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public SaCookie setValue(String value) {
        this.value = value;
        return this;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public SaCookie setMaxAge(int maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    public String getDomain() {
        return this.domain;
    }

    public SaCookie setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public SaCookie setPath(String path) {
        this.path = path;
        return this;
    }

    public Boolean getSecure() {
        return this.secure;
    }

    public SaCookie setSecure(Boolean secure) {
        this.secure = secure;
        return this;
    }

    public Boolean getHttpOnly() {
        return this.httpOnly;
    }

    public SaCookie setHttpOnly(Boolean httpOnly) {
        this.httpOnly = httpOnly;
        return this;
    }

    public String getSameSite() {
        return this.sameSite;
    }

    public SaCookie setSameSite(String sameSite) {
        this.sameSite = sameSite;
        return this;
    }

    public String toString() {
        return "SaCookie [name=" + this.name + ", value=" + this.value + ", maxAge=" + this.maxAge + ", domain=" + this.domain + ", path=" + this.path + ", secure=" + this.secure + ", httpOnly=" + this.httpOnly + ", sameSite=" + this.sameSite + "]";
    }

    public void builde() {
        if (this.path == null) {
            this.path = "/";
        }
    }

    public String toHeaderValue() {
        this.builde();
        if (SaFoxUtil.isEmpty(this.name)) {
            throw new SaTokenException("name\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.value != null && this.value.indexOf(";") > -1) {
            throw new SaTokenException("\u65e0\u6548Value\uff1a" + this.value);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.name + "=" + this.value);
        if (this.maxAge >= 0) {
            sb.append("; Max-Age=" + this.maxAge);
            String expires = this.maxAge == 0 ? Instant.EPOCH.atOffset(ZoneOffset.UTC).format(DateTimeFormatter.RFC_1123_DATE_TIME) : OffsetDateTime.now().plusSeconds(this.maxAge).format(DateTimeFormatter.RFC_1123_DATE_TIME);
            sb.append("; Expires=" + expires);
        }
        if (!SaFoxUtil.isEmpty(this.domain)) {
            sb.append("; Domain=" + this.domain);
        }
        if (!SaFoxUtil.isEmpty(this.path)) {
            sb.append("; Path=" + this.path);
        }
        if (this.secure.booleanValue()) {
            sb.append("; Secure");
        }
        if (this.httpOnly.booleanValue()) {
            sb.append("; HttpOnly");
        }
        if (!SaFoxUtil.isEmpty(this.sameSite)) {
            sb.append("; sameSite=" + this.sameSite);
        }
        return sb.toString();
    }
}

