/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.client;

import com.yeepay.g3.sdk.yop.YopServiceException;
import com.yeepay.g3.sdk.yop.client.YopConstants;
import com.yeepay.g3.sdk.yop.config.AppSdkConfig;
import com.yeepay.g3.sdk.yop.config.AppSdkConfigProviderRegistry;
import com.yeepay.g3.sdk.yop.config.support.BackUpAppSdkConfigManager;
import com.yeepay.g3.sdk.yop.exception.YopClientException;
import com.yeepay.g3.sdk.yop.utils.Assert;
import com.yeepay.shade.com.google.common.collect.ArrayListMultimap;
import com.yeepay.shade.com.google.common.collect.Maps;
import com.yeepay.shade.com.google.common.collect.Multimap;
import com.yeepay.shade.org.apache.commons.lang3.StringUtils;
import com.yeepay.shade.org.apache.commons.lang3.Validate;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YopRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(YopRequest.class);
    private String locale = "zh_CN";
    private String signAlg = "SHA1";
    private Multimap<String, String> paramMap = ArrayListMultimap.create();
    private Map<String, Object> multipartFiles = Maps.newHashMap();
    private Map<String, String> headers = new HashMap<String, String>();
    private List<String> ignoreSignParams = new ArrayList<String>(Arrays.asList("sign"));
    private final AppSdkConfig appSdkConfig;
    private final String secretKey;

    public YopRequest() {
        this.appSdkConfig = AppSdkConfigProviderRegistry.getProvider().getDefaultConfig();
        if (this.appSdkConfig == null) {
            throw new YopServiceException("Default SDKConfig not found.");
        }
        this.secretKey = null;
        this.init();
    }

    public YopRequest(String appKey) {
        Validate.notBlank(appKey, "AppKey is blank.", new Object[0]);
        this.appSdkConfig = AppSdkConfigProviderRegistry.getProvider().getConfig(appKey);
        if (this.appSdkConfig == null) {
            throw new YopServiceException("SDKConfig for appKey:" + appKey + " not found.");
        }
        this.secretKey = null;
        this.init();
    }

    public YopRequest(String appKey, String secretKey) {
        Validate.notBlank(appKey, "AppKey is blank.", new Object[0]);
        Validate.notBlank(secretKey, "SecretKey is blank.", new Object[0]);
        this.appSdkConfig = new AppSdkConfig();
        this.appSdkConfig.setAppKey(appKey);
        AppSdkConfig appSdkConfig = AppSdkConfigProviderRegistry.getProvider().getConfigWithDefault(appKey);
        if (appSdkConfig == null) {
            appSdkConfig = BackUpAppSdkConfigManager.getBackUpConfig();
        }
        this.appSdkConfig.setServerRoot(appSdkConfig.getServerRoot());
        this.appSdkConfig.setYosServerRoot(appSdkConfig.getYosServerRoot());
        this.appSdkConfig.setDefaultYopPublicKey(appSdkConfig.getDefaultYopPublicKey());
        this.secretKey = secretKey;
        this.init();
    }

    private void init() {
        this.headers.put("x-yop-sdk-version", "3.1.1");
        this.headers.put("x-yop-sdk-langs", "java");
        this.headers.put("User-Agent", YopConstants.USER_AGENT);
        this.paramMap.put("appKey", this.appSdkConfig.getAppKey());
        this.paramMap.put("locale", this.locale);
        this.paramMap.put("ts", String.valueOf(System.currentTimeMillis()));
    }

    public YopRequest setParam(String paramName, Object paramValue) {
        this.removeParam(paramName);
        this.addParam(paramName, paramValue, false);
        return this;
    }

    public YopRequest addParam(String paramName, Object paramValue) {
        this.addParam(paramName, paramValue, false);
        return this;
    }

    public YopRequest addParam(String paramName, Object paramValue, boolean ignoreSign) {
        Assert.hasText(paramName, "\u53c2\u6570\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        if (paramValue == null || paramValue instanceof String && StringUtils.isBlank((String)paramValue) || paramValue instanceof Collection && ((Collection)paramValue).isEmpty()) {
            LOGGER.warn("param " + paramName + "is null or empty\uff0cignore it");
            return this;
        }
        if (StringUtils.equals("_file", paramName)) {
            this.addFile(paramValue);
            return this;
        }
        if (YopConstants.isProtectedKey(paramName)) {
            this.paramMap.put(paramName, paramValue.toString());
            return this;
        }
        if (paramValue instanceof Collection) {
            for (Object o : (Collection)paramValue) {
                if (o == null) continue;
                this.paramMap.put(paramName, o.toString());
            }
        } else if (paramValue.getClass().isArray()) {
            int len = Array.getLength(paramValue);
            for (int i = 0; i < len; ++i) {
                Object o = Array.get(paramValue, i);
                if (o == null) continue;
                this.paramMap.put(paramName, o.toString());
            }
        } else {
            this.paramMap.put(paramName, paramValue.toString());
        }
        if (ignoreSign) {
            this.ignoreSignParams.add(paramName);
        }
        return this;
    }

    public List<String> getParam(String key) {
        return (List)this.paramMap.get(key);
    }

    public String getParamValue(String key) {
        return StringUtils.join(this.paramMap.get(key), ",");
    }

    public String removeParam(String key) {
        return StringUtils.join(this.paramMap.removeAll(key), ",");
    }

    public Multimap<String, String> getParams() {
        return this.paramMap;
    }

    public YopRequest addFile(Object file) {
        this.addFile("_file", file);
        return this;
    }

    public YopRequest addFile(String paramName, Object file) {
        if (!(file instanceof String || file instanceof File || file instanceof InputStream)) {
            throw new YopClientException("Unsupported file object.");
        }
        this.multipartFiles.put(paramName, file);
        return this;
    }

    public Map<String, Object> getMultipartFiles() {
        return this.multipartFiles;
    }

    public boolean hasFiles() {
        return null != this.multipartFiles && this.multipartFiles.size() > 0;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public String getRequestId() {
        return this.headers.get("x-yop-request-id");
    }

    public void setRequestId(String requestId) {
        this.headers.put("x-yop-request-id", requestId);
    }

    public void setRequestSource(String source) {
        this.headers.put("x-yop-request-source", source);
    }

    public List<String> getIgnoreSignParams() {
        return this.ignoreSignParams;
    }

    public void setLocale(String locale) {
        this.locale = locale;
        this.paramMap.put("locale", this.locale);
    }

    public String getLocale() {
        return this.locale;
    }

    public String getSignAlg() {
        return this.signAlg;
    }

    public void setSignAlg(String signAlg) {
        this.signAlg = signAlg;
    }

    @Deprecated
    public void setEncrypt(boolean encrypt) {
    }

    @Deprecated
    public void setSignRet(boolean signRet) {
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getAesSecretKey() {
        return this.secretKey == null ? this.appSdkConfig.getAesSecretKey() : this.secretKey;
    }

    public AppSdkConfig getAppSdkConfig() {
        return this.appSdkConfig;
    }

    public String toQueryString() {
        StringBuilder builder = new StringBuilder();
        for (String key : this.paramMap.keySet()) {
            Collection<String> values = this.paramMap.get(key);
            for (String value : values) {
                builder.append(builder.length() == 0 ? "" : "&");
                builder.append(key);
                builder.append("=");
                builder.append(value);
            }
        }
        return builder.toString();
    }
}

