/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.client;

import com.yeepay.g3.sdk.yop.client.YopHttpRequestRetryHandler;
import com.yeepay.g3.sdk.yop.client.YopRequest;
import com.yeepay.g3.sdk.yop.client.YopResponse;
import com.yeepay.g3.sdk.yop.error.YopError;
import com.yeepay.g3.sdk.yop.exception.YopClientException;
import com.yeepay.g3.sdk.yop.http.YopHttpResponse;
import com.yeepay.g3.sdk.yop.model.YopErrorResponse;
import com.yeepay.g3.sdk.yop.unmarshaller.JacksonJsonMarshaller;
import com.yeepay.g3.sdk.yop.utils.Assert;
import com.yeepay.g3.sdk.yop.utils.InternalConfig;
import com.yeepay.shade.org.apache.commons.collections4.MapUtils;
import com.yeepay.shade.org.apache.commons.io.IOUtils;
import com.yeepay.shade.org.apache.commons.lang3.StringUtils;
import com.yeepay.shade.org.apache.http.HttpHost;
import com.yeepay.shade.org.apache.http.auth.AuthScope;
import com.yeepay.shade.org.apache.http.auth.NTCredentials;
import com.yeepay.shade.org.apache.http.client.CredentialsProvider;
import com.yeepay.shade.org.apache.http.client.config.RequestConfig;
import com.yeepay.shade.org.apache.http.client.methods.CloseableHttpResponse;
import com.yeepay.shade.org.apache.http.client.methods.HttpUriRequest;
import com.yeepay.shade.org.apache.http.client.protocol.HttpClientContext;
import com.yeepay.shade.org.apache.http.client.utils.HttpClientUtils;
import com.yeepay.shade.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import com.yeepay.shade.org.apache.http.conn.ssl.SSLContextBuilder;
import com.yeepay.shade.org.apache.http.conn.ssl.TrustStrategy;
import com.yeepay.shade.org.apache.http.impl.client.BasicCredentialsProvider;
import com.yeepay.shade.org.apache.http.impl.client.CloseableHttpClient;
import com.yeepay.shade.org.apache.http.impl.client.HttpClientBuilder;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractClient.class);
    private static final String[] API_URI_PREFIX = new String[]{"/rest/v", "/yos/v"};
    private static final String CONTENT_TYPE_JSON = "application/json";
    private static CloseableHttpClient httpClient;
    private static RequestConfig.Builder requestConfigBuilder;
    private static CredentialsProvider credentialsProvider;
    private static HttpHost proxyHttpHost;
    protected static final String SESSION_ID;

    public static void initApacheHttpClient() {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(InternalConfig.READ_TIMEOUT).setConnectTimeout(InternalConfig.CONNECT_TIMEOUT).build();
        httpClient = HttpClientBuilder.create().setMaxConnTotal(InternalConfig.MAX_CONN_TOTAL).setMaxConnPerRoute(InternalConfig.MAX_CONN_PER_ROUTE).setSSLSocketFactory(InternalConfig.TRUST_ALL_CERTS ? AbstractClient.getTrustedAllSSLConnectionSocketFactory() : null).setDefaultRequestConfig(requestConfig).evictExpiredConnections().evictIdleConnections(5000L, TimeUnit.MILLISECONDS).setRetryHandler(new YopHttpRequestRetryHandler()).build();
        requestConfigBuilder = RequestConfig.custom();
        requestConfigBuilder.setConnectTimeout(InternalConfig.CONNECT_TIMEOUT);
        requestConfigBuilder.setStaleConnectionCheckEnabled(true);
        if (InternalConfig.proxy != null) {
            String proxyHost = InternalConfig.proxy.getHost();
            int proxyPort = InternalConfig.proxy.getPort();
            if (proxyHost != null && proxyPort > 0) {
                proxyHttpHost = new HttpHost(proxyHost, proxyPort);
                requestConfigBuilder.setProxy(proxyHttpHost);
                credentialsProvider = new BasicCredentialsProvider();
                String proxyUsername = InternalConfig.proxy.getUsername();
                String proxyPassword = InternalConfig.proxy.getPassword();
                String proxyDomain = InternalConfig.proxy.getDomain();
                String proxyWorkstation = InternalConfig.proxy.getWorkstation();
                if (proxyUsername != null && proxyPassword != null) {
                    credentialsProvider.setCredentials(new AuthScope(proxyHost, proxyPort), new NTCredentials(proxyUsername, proxyPassword, proxyWorkstation, proxyDomain));
                }
            }
        }
    }

    public static void destroyApacheHttpClient() {
        try {
            httpClient.close();
        }
        catch (IOException e) {
            LOGGER.error("httpclient close fail", e);
        }
    }

    private static SSLConnectionSocketFactory getTrustedAllSSLConnectionSocketFactory() {
        LOGGER.warn("[yop-sdk]\u5df2\u8bbe\u7f6e\u4fe1\u4efb\u6240\u6709\u8bc1\u4e66\u3002\u4ec5\u4f9b\u5185\u6d4b\u4f7f\u7528\uff0c\u8bf7\u52ff\u5728\u751f\u4ea7\u73af\u5883\u914d\u7f6e\u3002");
        SSLConnectionSocketFactory sslConnectionSocketFactory = null;
        try {
            SSLContextBuilder builder = new SSLContextBuilder();
            builder.loadTrustMaterial(null, new TrustStrategy(){

                @Override
                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            });
            sslConnectionSocketFactory = new SSLConnectionSocketFactory(builder.build());
        }
        catch (Exception e) {
            LOGGER.error("error when get trust-all-certs request factory,will return normal request factory instead", e);
        }
        return sslConnectionSocketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static YopResponse fetchContentByApacheHttpClient(HttpUriRequest request) throws IOException {
        HttpClientContext httpContext = AbstractClient.createHttpContext();
        CloseableHttpResponse remoteResponse = null;
        try {
            remoteResponse = AbstractClient.getHttpClient().execute(request, httpContext);
            YopResponse yopResponse = AbstractClient.parseResponse(remoteResponse);
            return yopResponse;
        }
        finally {
            if (null != remoteResponse && AbstractClient.isJsonResponse(remoteResponse)) {
                HttpClientUtils.closeQuietly(remoteResponse);
            }
        }
    }

    protected static YopResponse parseResponse(CloseableHttpResponse response) throws IOException {
        YopHttpResponse httpResponse = new YopHttpResponse(response);
        if (httpResponse.getStatusCode() / 100 == 2) {
            YopResponse yopResponse = new YopResponse();
            yopResponse.setState("SUCCESS");
            yopResponse.setRequestId(httpResponse.getHeader("x-yop-request-id"));
            if (httpResponse.getContent() != null) {
                if (AbstractClient.isJsonResponse(response)) {
                    String result = IOUtils.toString(httpResponse.getContent(), "UTF-8");
                    JacksonJsonMarshaller.load(result, yopResponse);
                    if (yopResponse.getStringResult() != null) {
                        yopResponse.setResult(JacksonJsonMarshaller.unmarshal(yopResponse.getStringResult(), Object.class));
                    }
                } else {
                    yopResponse.setResult(response.getEntity().getContent());
                }
            }
            yopResponse.setValidSign(true);
            return yopResponse;
        }
        if (httpResponse.getStatusCode() >= 500) {
            if (httpResponse.getContent() != null) {
                YopResponse yopResponse = new YopResponse();
                yopResponse.setState("FAILURE");
                YopErrorResponse errorResponse = JacksonJsonMarshaller.unmarshal(httpResponse.getContent(), YopErrorResponse.class);
                yopResponse.setRequestId(errorResponse.getRequestId());
                yopResponse.setError(YopError.Builder.anYopError().withCode(errorResponse.getCode()).withSubCode(errorResponse.getSubCode()).withMessage(errorResponse.getMessage()).withSubMessage(errorResponse.getSubMessage()).build());
                yopResponse.setValidSign(true);
                return yopResponse;
            }
            throw new YopClientException("empty result with httpStatusCode:" + httpResponse.getStatusCode());
        }
        throw new YopClientException("unexpected httpStatusCode:" + httpResponse.getStatusCode());
    }

    private static boolean isJsonResponse(CloseableHttpResponse response) {
        return StringUtils.startsWith(response.getEntity().getContentType().getValue(), CONTENT_TYPE_JSON);
    }

    private static HttpClientContext createHttpContext() {
        HttpClientContext context = HttpClientContext.create();
        context.setRequestConfig(requestConfigBuilder.build());
        if (credentialsProvider != null) {
            context.setCredentialsProvider(credentialsProvider);
        }
        return context;
    }

    public static CloseableHttpClient getHttpClient() {
        return httpClient;
    }

    protected static String richRequest(String methodOrUri, YopRequest request) {
        String requestRoot;
        Assert.hasText(methodOrUri, "apiUri");
        String string = requestRoot = MapUtils.isNotEmpty(request.getMultipartFiles()) ? request.getAppSdkConfig().getYosServerRoot() : request.getAppSdkConfig().getServerRoot();
        if (StringUtils.endsWith(requestRoot, "/")) {
            requestRoot = StringUtils.substring(requestRoot, 0, requestRoot.length() - 1);
        }
        String path = methodOrUri;
        if (StringUtils.startsWith(methodOrUri, requestRoot)) {
            path = StringUtils.substringAfter(methodOrUri, requestRoot);
        }
        if (!StringUtils.startsWithAny(path, API_URI_PREFIX)) {
            throw new YopClientException("Unsupported apiUri.");
        }
        request.setParam("v", StringUtils.substringBefore(StringUtils.substringAfter(methodOrUri, "/v"), "/"));
        request.setParam("method", methodOrUri);
        return requestRoot + path;
    }

    protected static String getUUID() {
        return UUID.randomUUID().toString();
    }

    static {
        SESSION_ID = AbstractClient.getUUID();
        AbstractClient.initApacheHttpClient();
    }
}

