/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.config.support;

import com.yeepay.g3.sdk.yop.YopServiceException;
import com.yeepay.g3.sdk.yop.config.SDKConfig;
import com.yeepay.g3.sdk.yop.config.support.ConfigUtils;
import com.yeepay.g3.sdk.yop.utils.JsonUtils;
import com.yeepay.shade.org.apache.commons.lang3.StringUtils;
import java.io.IOException;
import java.io.InputStream;

public final class SDKConfigUtils {
    public static SDKConfig loadConfig(String configFile) {
        SDKConfig config;
        InputStream fis = null;
        try {
            fis = ConfigUtils.getInputStream(configFile);
            config = JsonUtils.loadFrom(fis, SDKConfig.class);
        }
        catch (Exception ex) {
            throw new YopServiceException(ex, "Errors occurred when loading SDK Config.");
        }
        finally {
            if (null != fis) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (StringUtils.endsWith(config.getServerRoot(), "/")) {
            config.setServerRoot(StringUtils.substring(config.getServerRoot(), 0, -1));
        }
        if (StringUtils.endsWith(config.getYosServerRoot(), "/")) {
            config.setYosServerRoot(StringUtils.substring(config.getYosServerRoot(), 0, -1));
        }
        return config;
    }

    public static SDKConfig loadConfig(InputStream in) {
        SDKConfig config;
        InputStream fis = null;
        try {
            config = JsonUtils.loadFrom(in, SDKConfig.class);
        }
        catch (Exception ex) {
            throw new YopServiceException(ex, "Errors occurred when loading SDK Config.");
        }
        finally {
            if (null != fis) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (StringUtils.endsWith(config.getServerRoot(), "/")) {
            config.setServerRoot(StringUtils.substring(config.getServerRoot(), 0, -1));
        }
        return config;
    }
}

