/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.client;

import com.yeepay.g3.sdk.yop.client.AbstractClient;
import com.yeepay.g3.sdk.yop.client.YopRequest;
import com.yeepay.g3.sdk.yop.client.YopResponse;
import com.yeepay.g3.sdk.yop.encrypt.AESEncrypter;
import com.yeepay.g3.sdk.yop.encrypt.Digests;
import com.yeepay.g3.sdk.yop.exception.YopClientException;
import com.yeepay.g3.sdk.yop.unmarshaller.JacksonJsonMarshaller;
import com.yeepay.g3.sdk.yop.utils.DateUtils;
import com.yeepay.g3.sdk.yop.utils.FileUtils;
import com.yeepay.g3.sdk.yop.utils.JsonUtils;
import com.yeepay.g3.sdk.yop.utils.checksum.CRC64Utils;
import com.yeepay.shade.com.google.common.base.Joiner;
import com.yeepay.shade.com.google.common.base.Preconditions;
import com.yeepay.shade.com.google.common.collect.Multimap;
import com.yeepay.shade.org.apache.commons.codec.binary.Base64;
import com.yeepay.shade.org.apache.commons.lang3.StringUtils;
import com.yeepay.shade.org.apache.http.client.methods.HttpUriRequest;
import com.yeepay.shade.org.apache.http.client.methods.RequestBuilder;
import com.yeepay.shade.org.apache.http.entity.ContentType;
import com.yeepay.shade.org.apache.http.entity.mime.MultipartEntityBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YopClient
extends AbstractClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(YopClient.class);
    private static final Joiner queryStringOldJoiner = Joiner.on("");

    public static YopResponse post(String apiUri, YopRequest request) throws IOException {
        String contentUrl = YopClient.richRequest(apiUri, request);
        YopClient.normalize(request);
        YopClient.sign(request);
        RequestBuilder requestBuilder = RequestBuilder.post().setUri(contentUrl);
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            requestBuilder.addHeader(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : request.getParams().entries()) {
            requestBuilder.addParameter(entry.getKey(), URLEncoder.encode(entry.getValue(), "UTF-8"));
        }
        HttpUriRequest httpPost = requestBuilder.build();
        YopResponse response = YopClient.fetchContentByApacheHttpClient(httpPost);
        YopClient.handleResult(request, response);
        return response;
    }

    public static YopResponse get(String apiUri, YopRequest request) throws IOException {
        String contentUrl = YopClient.richRequest(apiUri, request);
        YopClient.normalize(request);
        YopClient.sign(request);
        RequestBuilder requestBuilder = RequestBuilder.get().setUri(contentUrl);
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            requestBuilder.addHeader(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : request.getParams().entries()) {
            requestBuilder.addParameter(entry.getKey(), URLEncoder.encode(entry.getValue(), "UTF-8"));
        }
        HttpUriRequest httpGet = requestBuilder.build();
        YopResponse response = YopClient.fetchContentByApacheHttpClient(httpGet);
        YopClient.handleResult(request, response);
        return response;
    }

    public static YopResponse upload(String apiUri, YopRequest request) throws IOException, URISyntaxException {
        String contentUrl = YopClient.richRequest(apiUri, request);
        YopClient.normalize(request);
        YopClient.sign(request);
        RequestBuilder requestBuilder = RequestBuilder.post().setUri(contentUrl);
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            requestBuilder.addHeader(entry.getKey(), entry.getValue());
        }
        if (!request.hasFiles()) {
            for (Map.Entry<String, String> entry : request.getParams().entries()) {
                requestBuilder.addParameter(entry.getKey(), URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
        } else {
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
            for (Map.Entry<String, Object> entry : request.getMultipartFiles().entrySet()) {
                String paramName = entry.getKey();
                Object file = entry.getValue();
                if (file instanceof String) {
                    multipartEntityBuilder.addBinaryBody(paramName, new File((String)file));
                    continue;
                }
                if (file instanceof File) {
                    multipartEntityBuilder.addBinaryBody(paramName, (File)file);
                    continue;
                }
                if (file instanceof InputStream) {
                    String fileName = FileUtils.getFileName((InputStream)file);
                    multipartEntityBuilder.addBinaryBody(paramName, (InputStream)file, ContentType.DEFAULT_BINARY, fileName);
                    continue;
                }
                throw new YopClientException("\u4e0d\u652f\u6301\u7684\u4e0a\u4f20\u6587\u4ef6\u7c7b\u578b");
            }
            for (Map.Entry<String, String> entry : request.getParams().entries()) {
                multipartEntityBuilder.addTextBody(entry.getKey(), URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
            requestBuilder.setEntity(multipartEntityBuilder.build());
        }
        HttpUriRequest httpPost = requestBuilder.build();
        YopResponse yopResponse = YopClient.fetchContentByApacheHttpClient(httpPost);
        YopClient.handleResult(request, yopResponse);
        return yopResponse;
    }

    public static String getCanonicalQueryString(YopRequest request, boolean forSignature) {
        Multimap<String, String> parameters = request.getParams();
        if (parameters.isEmpty()) {
            return "";
        }
        TreeMap<String, String> signParams = new TreeMap<String, String>();
        for (Map.Entry<String, Collection<String>> entry : parameters.asMap().entrySet()) {
            if (forSignature && ("Authorization".equalsIgnoreCase(entry.getKey()) || request.getIgnoreSignParams().contains(entry.getKey()))) continue;
            String key = entry.getKey();
            Preconditions.checkNotNull(key, "parameter key should not be null");
            ArrayList<String> list = new ArrayList<String>(entry.getValue());
            Collections.sort(list);
            signParams.put(key, StringUtils.join(list, ","));
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : signParams.entrySet()) {
            sb.append((String)entry.getKey()).append((String)entry.getValue());
        }
        return sb.toString();
    }

    private static void normalize(YopRequest request) {
        request.addHeader("x-yop-session-id", SESSION_ID);
        if (!request.getHeaders().containsKey("x-yop-request-id")) {
            request.addHeader("x-yop-request-id", YopClient.getUUID());
        }
        String timestamp = DateUtils.formatCompressedIso8601Timestamp(System.currentTimeMillis());
        request.addHeader("x-yop-date", timestamp);
    }

    private static void sign(YopRequest request) {
        if (request.getHeaders().containsKey("Authorization")) {
            return;
        }
        if (request.hasFiles()) {
            try {
                request.addHeader("x-yop-hash-crc64ecma", CRC64Utils.calculateMultiPartFileCrc64ecma(request.getMultipartFiles()));
            }
            catch (IOException ex) {
                LOGGER.error("IOException occurred when generate crc64ecma.", ex);
                throw new YopClientException("IOException occurred when generate crc64ecma.", ex);
            }
        }
        String canonicalQueryString = YopClient.getCanonicalQueryString(request, true);
        String secret = request.getAesSecretKey();
        String algName = request.getSignAlg();
        algName = StringUtils.isBlank(algName) ? "SHA1" : algName;
        String sb = secret + canonicalQueryString + secret;
        String signature = Digests.digest2Hex(sb, algName);
        if (32 == Base64.decodeBase64(secret).length) {
            request.addHeader("Authorization", "YOP-HMAC-AES256 " + signature);
        } else {
            request.addHeader("Authorization", "YOP-HMAC-AES128 " + signature);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("========\ncanonicalQueryString:" + canonicalQueryString + "\nmd5(secret):" + Digests.digest2Hex(secret, "md5") + "\nsignature:" + signature);
        }
    }

    private static void handleResult(YopRequest request, YopResponse response) {
        String stringResult = response.getStringResult();
        if (StringUtils.isNotBlank(stringResult)) {
            response.setResult(JacksonJsonMarshaller.unmarshal(stringResult, Object.class));
        }
        YopClient.verifySignature(request, response);
    }

    private static void verifySignature(YopRequest request, YopResponse response) {
        String expectedSign = response.getSign();
        if (StringUtils.isBlank(expectedSign) || null == response.getStringResult()) {
            return;
        }
        String trimmedBizResult = response.getStringResult().replaceAll("[ \t\n]", "");
        StringBuilder sb = new StringBuilder(request.getAesSecretKey()).append(StringUtils.trimToEmpty(response.getState() + trimmedBizResult + response.getTs())).append(request.getAesSecretKey());
        String calculatedSign = Digests.digest2Hex(sb.toString(), StringUtils.isBlank(request.getSignAlg()) ? "SHA1" : request.getSignAlg());
        boolean valid = StringUtils.equalsIgnoreCase(expectedSign, calculatedSign);
        response.setValidSign(valid);
    }

    public static String acceptNotificationAsJson(String key, String response) {
        return YopClient.validateAndDecryptNotification(key, response);
    }

    public static Map acceptNotificationAsMap(String key, String response) {
        String s = YopClient.acceptNotificationAsJson(key, response);
        return s == null ? null : JsonUtils.fromJsonString(YopClient.acceptNotificationAsJson(key, response), Map.class);
    }

    private static String validateAndDecryptNotification(String key, String response) {
        String localSignature;
        Map map = JsonUtils.fromJsonString(response, Map.class);
        boolean doEncryption = Boolean.valueOf(map.get("doEncryption").toString());
        String encryption = map.get("encryption").toString();
        String signature = map.get("signature").toString();
        String signatureAlg = map.get("signatureAlg").toString();
        if (doEncryption) {
            encryption = AESEncrypter.decrypt(encryption, key);
        }
        if (!(localSignature = Digests.digest2Hex(key + encryption + key, signatureAlg)).equals(signature)) {
            return null;
        }
        return encryption;
    }
}

