/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.trade.service.impl;

import com.alipay.api.AlipayRequest;
import com.alipay.api.AlipayResponse;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipayTradePayRequest;
import com.alipay.api.response.AlipayTradePayResponse;
import com.alipay.api.response.AlipayTradeQueryResponse;
import com.alipay.trade.config.Configs;
import com.alipay.trade.model.TradeStatus;
import com.alipay.trade.model.builder.AlipayTradePayRequestBuilder;
import com.alipay.trade.model.builder.AlipayTradeQueryRequestBuilder;
import com.alipay.trade.model.result.AlipayF2FPayResult;
import com.alipay.trade.service.impl.AbsAlipayTradeService;
import org.apache.commons.lang.StringUtils;

public class AlipayTradeServiceImpl
extends AbsAlipayTradeService {
    public AlipayTradeServiceImpl(ClientBuilder builder) {
        if (StringUtils.isEmpty((String)builder.getGatewayUrl())) {
            throw new NullPointerException("gatewayUrl should not be NULL!");
        }
        if (StringUtils.isEmpty((String)builder.getAppid())) {
            throw new NullPointerException("appid should not be NULL!");
        }
        if (StringUtils.isEmpty((String)builder.getPrivateKey())) {
            throw new NullPointerException("privateKey should not be NULL!");
        }
        if (StringUtils.isEmpty((String)builder.getFormat())) {
            throw new NullPointerException("format should not be NULL!");
        }
        if (StringUtils.isEmpty((String)builder.getCharset())) {
            throw new NullPointerException("charset should not be NULL!");
        }
        if (StringUtils.isEmpty((String)builder.getAlipayPublicKey())) {
            throw new NullPointerException("alipayPublicKey should not be NULL!");
        }
        this.client = new DefaultAlipayClient(builder.getGatewayUrl(), builder.getAppid(), builder.getPrivateKey(), builder.getFormat(), builder.getCharset(), builder.getAlipayPublicKey());
    }

    @Override
    public AlipayF2FPayResult tradePay(AlipayTradePayRequestBuilder builder) {
        this.validateBuilder(builder);
        String outTradeNo = builder.getOutTradeNo();
        AlipayTradePayRequest request = new AlipayTradePayRequest();
        request.setNotifyUrl(builder.getNotifyUrl());
        String appAuthToken = builder.getAppAuthToken();
        request.putOtherTextParam("app_auth_token", builder.getAppAuthToken());
        request.setBizContent(builder.toJsonString());
        this.log.info((Object)("trade.pay bizContent:" + request.getBizContent()));
        AlipayTradePayResponse response = (AlipayTradePayResponse)this.getResponse(this.client, (AlipayRequest)request);
        AlipayF2FPayResult result = new AlipayF2FPayResult(response);
        if (response != null && "10000".equals(response.getCode())) {
            result.setTradeStatus(TradeStatus.SUCCESS);
        } else {
            if (response != null && "10003".equals(response.getCode())) {
                AlipayTradeQueryRequestBuilder queryBuiler = new AlipayTradeQueryRequestBuilder().setAppAuthToken(appAuthToken).setOutTradeNo(outTradeNo);
                AlipayTradeQueryResponse loopQueryResponse = this.loopQueryResult(queryBuiler);
                return this.checkQueryAndCancel(outTradeNo, appAuthToken, result, loopQueryResponse);
            }
            if (this.tradeError((AlipayResponse)response)) {
                AlipayTradeQueryRequestBuilder queryBuiler = new AlipayTradeQueryRequestBuilder().setAppAuthToken(appAuthToken).setOutTradeNo(outTradeNo);
                AlipayTradeQueryResponse queryResponse = this.tradeQuery(queryBuiler);
                return this.checkQueryAndCancel(outTradeNo, appAuthToken, result, queryResponse);
            }
            result.setTradeStatus(TradeStatus.FAILED);
        }
        return result;
    }

    public static class ClientBuilder {
        private String gatewayUrl;
        private String appid;
        private String privateKey;
        private String format;
        private String charset;
        private String alipayPublicKey;

        public AlipayTradeServiceImpl build() {
            if (StringUtils.isEmpty((String)this.gatewayUrl)) {
                this.gatewayUrl = Configs.getOpenApiDomain();
            }
            if (StringUtils.isEmpty((String)this.appid)) {
                this.appid = Configs.getAppid();
            }
            if (StringUtils.isEmpty((String)this.privateKey)) {
                this.privateKey = Configs.getPrivateKey();
            }
            if (StringUtils.isEmpty((String)this.format)) {
                this.format = "json";
            }
            if (StringUtils.isEmpty((String)this.charset)) {
                this.charset = "utf-8";
            }
            if (StringUtils.isEmpty((String)this.alipayPublicKey)) {
                this.alipayPublicKey = Configs.getAlipayPublicKey();
            }
            return new AlipayTradeServiceImpl(this);
        }

        public ClientBuilder setAlipayPublicKey(String alipayPublicKey) {
            this.alipayPublicKey = alipayPublicKey;
            return this;
        }

        public ClientBuilder setAppid(String appid) {
            this.appid = appid;
            return this;
        }

        public ClientBuilder setCharset(String charset) {
            this.charset = charset;
            return this;
        }

        public ClientBuilder setFormat(String format) {
            this.format = format;
            return this;
        }

        public ClientBuilder setGatewayUrl(String gatewayUrl) {
            this.gatewayUrl = gatewayUrl;
            return this;
        }

        public ClientBuilder setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public String getAlipayPublicKey() {
            return this.alipayPublicKey;
        }

        public String getAppid() {
            return this.appid;
        }

        public String getCharset() {
            return this.charset;
        }

        public String getFormat() {
            return this.format;
        }

        public String getGatewayUrl() {
            return this.gatewayUrl;
        }

        public String getPrivateKey() {
            return this.privateKey;
        }
    }
}

