/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.trade.config;

import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Configs {
    private static Log log = LogFactory.getLog(Configs.class);
    private static Configuration configs;
    private static String openApiDomain;
    private static String mcloudApiDomain;
    private static String pid;
    private static String appid;
    private static String privateKey;
    private static String publicKey;
    private static String alipayPublicKey;
    private static int maxQueryRetry;
    private static long queryDuration;
    private static int maxCancelRetry;
    private static long cancelDuration;
    private static long heartbeatDelay;
    private static long heartbeatDuration;

    private Configs() {
    }

    public static synchronized void init(String filePath) {
        if (configs != null) {
            return;
        }
        try {
            configs = new PropertiesConfiguration(filePath);
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        if (configs == null) {
            throw new IllegalStateException("can`t find file by path:" + filePath);
        }
        openApiDomain = configs.getString("open_api_domain");
        mcloudApiDomain = configs.getString("mcloud_api_domain");
        pid = configs.getString("pid");
        appid = configs.getString("appid");
        privateKey = configs.getString("private_key");
        publicKey = configs.getString("public_key");
        alipayPublicKey = configs.getString("alipay_public_key");
        maxQueryRetry = configs.getInt("max_query_retry");
        queryDuration = configs.getLong("query_duration");
        maxCancelRetry = configs.getInt("max_cancel_retry");
        cancelDuration = configs.getLong("cancel_duration");
        heartbeatDelay = configs.getLong("heartbeat_delay");
        heartbeatDuration = configs.getLong("heartbeat_duration");
        log.info((Object)("\u914d\u7f6e\u6587\u4ef6\u540d: " + filePath));
        log.info((Object)Configs.description());
    }

    public static String description() {
        StringBuilder sb = new StringBuilder("Configs{");
        sb.append("\u652f\u4ed8\u5b9dopenapi\u7f51\u5173: ").append(openApiDomain).append("\n");
        if (StringUtils.isNotEmpty((String)mcloudApiDomain)) {
            sb.append(", \u652f\u4ed8\u5b9dmcloudapi\u7f51\u5173\u57df\u540d: ").append(mcloudApiDomain).append("\n");
        }
        if (StringUtils.isNotEmpty((String)pid)) {
            sb.append(", pid: ").append(pid).append("\n");
        }
        sb.append(", appid: ").append(appid).append("\n");
        sb.append(", \u5546\u6237RSA\u79c1\u94a5: ").append(Configs.getKeyDescription(privateKey)).append("\n");
        sb.append(", \u5546\u6237RSA\u516c\u94a5: ").append(Configs.getKeyDescription(publicKey)).append("\n");
        sb.append(", \u652f\u4ed8\u5b9dRSA\u516c\u94a5: ").append(Configs.getKeyDescription(alipayPublicKey)).append("\n");
        sb.append(", \u67e5\u8be2\u91cd\u8bd5\u6b21\u6570: ").append(maxQueryRetry).append("\n");
        sb.append(", \u67e5\u8be2\u95f4\u9694(\u6beb\u79d2): ").append(queryDuration).append("\n");
        sb.append(", \u64a4\u9500\u5c1d\u8bd5\u6b21\u6570: ").append(maxCancelRetry).append("\n");
        sb.append(", \u64a4\u9500\u91cd\u8bd5\u95f4\u9694(\u6beb\u79d2): ").append(cancelDuration).append("\n");
        sb.append(", \u4ea4\u6613\u4fdd\u969c\u8c03\u5ea6\u5ef6\u8fdf(\u79d2): ").append(heartbeatDelay).append("\n");
        sb.append(", \u4ea4\u6613\u4fdd\u969c\u8c03\u5ea6\u95f4\u9694(\u79d2): ").append(heartbeatDuration).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private static String getKeyDescription(String key) {
        int showLength = 6;
        if (StringUtils.isNotEmpty((String)key) && key.length() > showLength) {
            return key.substring(0, showLength) + "******" + key.substring(key.length() - showLength);
        }
        return null;
    }

    public static Configuration getConfigs() {
        return configs;
    }

    public static String getOpenApiDomain() {
        return openApiDomain;
    }

    public static String getMcloudApiDomain() {
        return mcloudApiDomain;
    }

    public static void setMcloudApiDomain(String mcloudApiDomain) {
        Configs.mcloudApiDomain = mcloudApiDomain;
    }

    public static String getPid() {
        return pid;
    }

    public static String getAppid() {
        return appid;
    }

    public static String getPrivateKey() {
        return privateKey;
    }

    public static String getPublicKey() {
        return publicKey;
    }

    public static String getAlipayPublicKey() {
        return alipayPublicKey;
    }

    public static int getMaxQueryRetry() {
        return maxQueryRetry;
    }

    public static long getQueryDuration() {
        return queryDuration;
    }

    public static int getMaxCancelRetry() {
        return maxCancelRetry;
    }

    public static long getCancelDuration() {
        return cancelDuration;
    }

    public static void setConfigs(Configuration configs) {
        Configs.configs = configs;
    }

    public static void setOpenApiDomain(String openApiDomain) {
        Configs.openApiDomain = openApiDomain;
    }

    public static void setPid(String pid) {
        Configs.pid = pid;
    }

    public static void setAppid(String appid) {
        Configs.appid = appid;
    }

    public static void setPrivateKey(String privateKey) {
        Configs.privateKey = privateKey;
    }

    public static void setPublicKey(String publicKey) {
        Configs.publicKey = publicKey;
    }

    public static void setAlipayPublicKey(String alipayPublicKey) {
        Configs.alipayPublicKey = alipayPublicKey;
    }

    public static void setMaxQueryRetry(int maxQueryRetry) {
        Configs.maxQueryRetry = maxQueryRetry;
    }

    public static void setQueryDuration(long queryDuration) {
        Configs.queryDuration = queryDuration;
    }

    public static void setMaxCancelRetry(int maxCancelRetry) {
        Configs.maxCancelRetry = maxCancelRetry;
    }

    public static void setCancelDuration(long cancelDuration) {
        Configs.cancelDuration = cancelDuration;
    }

    public static long getHeartbeatDelay() {
        return heartbeatDelay;
    }

    public static void setHeartbeatDelay(long heartbeatDelay) {
        Configs.heartbeatDelay = heartbeatDelay;
    }

    public static long getHeartbeatDuration() {
        return heartbeatDuration;
    }

    public static void setHeartbeatDuration(long heartbeatDuration) {
        Configs.heartbeatDuration = heartbeatDuration;
    }
}

