/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oasis.biz.service.impl.gateway.zookeeper.watcher.frame;

import com.alibaba.fastjson.JSONObject;
import com.alipay.oasis.biz.service.impl.gateway.data.refresh.CacheRefreshDispatcher;
import com.alipay.oasis.biz.service.impl.gateway.zookeeper.watcher.frame.Watchable;
import com.alipay.oasis.common.util.logger.AppLogger;
import com.alipay.oasis.common.util.logger.AppLoggerFactory;

public class WatcherFrame {
    static final AppLogger LOGGER = AppLoggerFactory.getLogger(WatcherFrame.class);
    private final IocLogger logger;

    public WatcherFrame() {
        this.logger = new IocLogger();
    }

    public WatcherFrame(IocLogger logger) {
        this.logger = logger;
    }

    public static WatcherFrame newInstance() {
        return new WatcherFrame();
    }

    public static WatcherFrame newInstance(IocLogger logger) {
        return new WatcherFrame(logger);
    }

    public <REQ> void run(REQ request, CacheRefreshDispatcher cacheRefreshDispatcher, Watchable<REQ> watchable) {
        try {
            watchable.call(request, cacheRefreshDispatcher);
        }
        catch (Throwable e) {
            try {
                String msgString = JSONObject.toJSONString(request);
                this.logger.errorLogger(LOGGER, request.getClass().getSimpleName(), e, msgString);
            }
            catch (Throwable err) {
                this.logger.errorLogger(LOGGER, request.getClass().getSimpleName(), err, null);
            }
        }
    }

    public static class IocLogger {
        public void errorLogger(AppLogger logger, String msgName, Throwable e, String msgString) {
            logger.error(false, "system", null, msgName, e, new Object[]{msgString});
        }
    }
}

