/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oasis.biz.service.impl.gateway.zookeeper.watcher;

import com.alipay.oasis.biz.service.impl.gateway.data.refresh.CacheRefreshDispatcher;
import com.alipay.oasis.biz.service.impl.gateway.data.refresh.session.MsgRefreshSession;
import com.alipay.oasis.biz.service.impl.gateway.zookeeper.watcher.frame.WatcherFrame;
import com.alipay.oasis.common.util.logger.AppLogger;
import com.alipay.oasis.common.util.logger.AppLoggerFactory;
import com.alipay.oasis.common.util.zookeeper.BaseChildrenWatcher;
import com.alipay.oasis.proto.ZkNotification;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.springframework.beans.factory.annotation.Autowired;

public class SessionCacheWatcher
extends BaseChildrenWatcher {
    static final AppLogger LOGGER = AppLoggerFactory.getLogger(SessionCacheWatcher.class);
    @Autowired
    private CacheRefreshDispatcher cacheRefreshDispatcher;

    public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) {
        try {
            ChildData childData = event.getData();
            ZkNotification.ZkNotificationGatewayReloadData zkNotificationGatewayReloadData = ZkNotification.ZkNotificationGatewayReloadData.parseFrom((byte[])childData.getData());
            String sessionId = zkNotificationGatewayReloadData.getId();
            ZkNotification.ZkNotificationGatewayReloadData.ReloadDataBehavior reloadDataBehavior = null;
            switch (event.getType()) {
                case CHILD_ADDED: {
                    reloadDataBehavior = ZkNotification.ZkNotificationGatewayReloadData.ReloadDataBehavior.CREATE;
                    break;
                }
                case CHILD_REMOVED: {
                    reloadDataBehavior = ZkNotification.ZkNotificationGatewayReloadData.ReloadDataBehavior.DELETE;
                    break;
                }
                case CHILD_UPDATED: {
                    reloadDataBehavior = ZkNotification.ZkNotificationGatewayReloadData.ReloadDataBehavior.UPDATE;
                    break;
                }
            }
            if (reloadDataBehavior == null) {
                return;
            }
            ZkNotification.ZkNotificationGatewayReloadData.ReloadDataBehavior reloadDataBehaviorForMsg = reloadDataBehavior;
            WatcherFrame.newInstance().run(childData, this.cacheRefreshDispatcher, (childData1, cacheRefreshDispatcher) -> {
                MsgRefreshSession msgRefreshSession = new MsgRefreshSession(sessionId, reloadDataBehaviorForMsg);
                cacheRefreshDispatcher.dispatch(msgRefreshSession);
            });
        }
        catch (Exception e) {
            LOGGER.error(false, "system", null, ((Object)((Object)this)).getClass().getSimpleName(), (Throwable)e, new Object[0]);
        }
    }

    public void setCacheRefreshDispatcher(CacheRefreshDispatcher cacheRefreshDispatcher) {
        this.cacheRefreshDispatcher = cacheRefreshDispatcher;
    }
}

