/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oasis.biz.service.impl.gateway.starter;

import com.alipay.oasis.biz.service.impl.gateway.zookeeper.watcher.EnclaveCacheWatcher;
import com.alipay.oasis.biz.service.impl.gateway.zookeeper.watcher.SessionCacheWatcher;
import com.alipay.oasis.biz.shared.zookeeper.ZooKeeperPath;
import com.alipay.oasis.common.util.zookeeper.BaseChildrenWatcher;
import com.alipay.oasis.common.util.zookeeper.ZooKeeperClient;
import org.springframework.beans.factory.annotation.Autowired;

public class GatewayStarter {
    @Autowired
    ZooKeeperClient zooKeeperClient;
    @Autowired
    ZooKeeperPath zooKeeperPath;
    @Autowired
    private EnclaveCacheWatcher enclaveCacheWatcher;
    @Autowired
    private SessionCacheWatcher sessionCacheWatcher;

    public void start() {
        this.initZooKeeperNode();
        this.watchZooKeeperNode();
    }

    void initZooKeeperNode() {
        this.zooKeeperClient.createNodeGuaranteed(this.zooKeeperPath.getCacheNotificationEnclaveClusterBasePath());
        this.zooKeeperClient.createNodeGuaranteed(this.zooKeeperPath.getCacheNotificationSessionBasePath());
    }

    void watchZooKeeperNode() {
        this.zooKeeperClient.registerChildrenNodesWatcher(this.zooKeeperPath.getCacheNotificationEnclaveClusterBasePath(), (BaseChildrenWatcher)this.enclaveCacheWatcher);
        this.zooKeeperClient.registerChildrenNodesWatcher(this.zooKeeperPath.getCacheNotificationSessionBasePath(), (BaseChildrenWatcher)this.sessionCacheWatcher);
    }

    public void setZooKeeperClient(ZooKeeperClient zooKeeperClient) {
        this.zooKeeperClient = zooKeeperClient;
    }

    public void setEnclaveCacheWatcher(EnclaveCacheWatcher enclaveCacheWatcher) {
        this.enclaveCacheWatcher = enclaveCacheWatcher;
    }

    public void setSessionCacheWatcher(SessionCacheWatcher sessionCacheWatcher) {
        this.sessionCacheWatcher = sessionCacheWatcher;
    }

    public void setZooKeeperPath(ZooKeeperPath zooKeeperPath) {
        this.zooKeeperPath = zooKeeperPath;
    }
}

