/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oasis.biz.service.impl.gateway.service.servable;

import com.alipay.oasis.biz.service.impl.gateway.service.servable.ServableCommon;
import com.alipay.oasis.biz.shared.rpc.RpcInvokeContextHelper;
import com.alipay.oasis.common.dal.mysql.daointerface.ClusterManagerInfoDAO;
import com.alipay.oasis.common.dal.mysql.daointerface.EnclaveConfigDAO;
import com.alipay.oasis.common.dal.mysql.daointerface.SceneDAO;
import com.alipay.oasis.common.dal.mysql.dataobject.EnclaveConfigDO;
import com.alipay.oasis.common.service.facade.cluster.manager.ForGatewayTrService;
import com.alipay.oasis.common.util.config.OasisAppConfiguration;
import com.alipay.oasis.common.util.exception.UnexpectException;
import com.alipay.oasis.common.util.header.Header;
import com.alipay.oasis.common.util.service.Servable;
import com.alipay.oasis.proto.Common;
import com.alipay.oasis.proto.gateway.Gateway;
import java.util.List;
import java.util.Map;

public class ServableSetEnclaveConfigFlowRatioImpl
implements Servable<Gateway.GatewaySetEnclaveConfigFlowRatioRequest, Gateway.GatewaySetEnclaveConfigFlowRatioResponse> {
    private static final int EXPECTED_GRAY_RELEASE_PERCENT_COUNT = 100;
    private final ForGatewayTrService forGatewayTrService;
    private final ClusterManagerInfoDAO clusterManagerInfoDAO;
    private final SceneDAO sceneDAO;
    private final EnclaveConfigDAO enclaveConfigDAO;
    private final OasisAppConfiguration oasisAppConfiguration;
    private final RpcInvokeContextHelper rpcInvokeContextHelper;

    public ServableSetEnclaveConfigFlowRatioImpl(ForGatewayTrService forGatewayTrService, ClusterManagerInfoDAO clusterManagerInfoDAO, SceneDAO sceneDAO, EnclaveConfigDAO enclaveConfigDAO, OasisAppConfiguration oasisAppConfiguration, RpcInvokeContextHelper rpcInvokeContextHelper) {
        this.forGatewayTrService = forGatewayTrService;
        this.clusterManagerInfoDAO = clusterManagerInfoDAO;
        this.sceneDAO = sceneDAO;
        this.enclaveConfigDAO = enclaveConfigDAO;
        this.oasisAppConfiguration = oasisAppConfiguration;
        this.rpcInvokeContextHelper = rpcInvokeContextHelper;
    }

    public Gateway.GatewaySetEnclaveConfigFlowRatioResponse call(Gateway.GatewaySetEnclaveConfigFlowRatioRequest request, Header header, Map<String, Object> context) throws Exception {
        ServableCommon.validateSceneAndTopic(this.sceneDAO, request.getScene(), request.getTopicId());
        List enclaveConfigGrayReleaseList = request.getConfigFlowRatioListList();
        int totalPercent = 0;
        for (Gateway.GatewaySetEnclaveConfigFlowRatioRequest.EnclaveConfigFlowRatio enclaveConfigGrayRelease : enclaveConfigGrayReleaseList) {
            Common.EnclaveConfigMetaInfo enclaveConfigMetaInfo = enclaveConfigGrayRelease.getConfigMetaInfo();
            EnclaveConfigDO enclaveConfigDO = ServableCommon.validateEnclaveConfigMetaInfo(enclaveConfigMetaInfo, this.enclaveConfigDAO);
            if (Common.EnclaveConfigStatus.valueOf((String)enclaveConfigDO.getConfigStatus()) != Common.EnclaveConfigStatus.ONLINE) {
                throw new UnexpectException("Enclave config [" + enclaveConfigDO.getConfigId() + "] is not online!");
            }
            totalPercent += enclaveConfigGrayRelease.getGrayPercent();
        }
        if (totalPercent != 100) {
            throw new UnexpectException("The total flow ratios is not 100%");
        }
        String cmHost = ServableCommon.getZoneCmHost(this.clusterManagerInfoDAO, this.oasisAppConfiguration.getZoneName());
        this.rpcInvokeContextHelper.setTargetUrl(cmHost);
        return this.forGatewayTrService.setEnclaveConfigFlowRatio(request);
    }
}

