/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oasis.biz.service.impl.gateway.service.servable;

import com.alipay.oasis.biz.service.impl.gateway.data.container.DataContainer;
import com.alipay.oasis.biz.service.impl.gateway.data.strategy.DataStrategy;
import com.alipay.oasis.biz.service.impl.gateway.oasiscall.enclaveservice.EnclaveParam;
import com.alipay.oasis.biz.service.impl.gateway.oasiscall.enclaveservice.EnclaveServiceClient;
import com.alipay.oasis.biz.service.impl.gateway.oasiscall.remotegateway.RemoteGatewayManager;
import com.alipay.oasis.biz.service.impl.gateway.service.servable.ServableCommon;
import com.alipay.oasis.common.dal.mysql.dataobject.EnclaveNodeDO;
import com.alipay.oasis.common.dal.mysql.dataobject.SessionNodeClusterDO;
import com.alipay.oasis.common.dal.mysql.doinfo.EnclaveNodeInfo;
import com.alipay.oasis.common.util.config.OasisAppConfiguration;
import com.alipay.oasis.common.util.header.Header;
import com.alipay.oasis.common.util.service.Servable;
import com.alipay.oasis.proto.gateway.Gateway;
import java.util.Map;

public class ServableRaSetSessionBizKeyImpl
implements Servable<Gateway.GatewayRaSetSessionBizKeyRequest, Gateway.GatewayRaSetSessionBizKeyResponse> {
    private final DataContainer dataContainer;
    private final RemoteGatewayManager remoteGatewayManager;
    private final OasisAppConfiguration oasisAppConfiguration;

    public ServableRaSetSessionBizKeyImpl(DataContainer dataContainer, RemoteGatewayManager remoteGatewayManager, OasisAppConfiguration oasisAppConfiguration) {
        this.dataContainer = dataContainer;
        this.remoteGatewayManager = remoteGatewayManager;
        this.oasisAppConfiguration = oasisAppConfiguration;
    }

    public Gateway.GatewayRaSetSessionBizKeyResponse call(Gateway.GatewayRaSetSessionBizKeyRequest request, Header header, Map<String, Object> context) throws Exception {
        String sessionId = request.getSessionId();
        SessionNodeClusterDO sessionNodeClusterDO = ServableCommon.getSessionNodeClusterDO(sessionId, this.dataContainer);
        ServableCommon.checkSessionExpired(sessionNodeClusterDO);
        EnclaveNodeDO enclaveForUpdateBizKey = DataStrategy.getAnEnclaveForSetBizKey(sessionId, this.dataContainer, this.oasisAppConfiguration.getZoneName());
        if (enclaveForUpdateBizKey == null) {
            String errMsg = "Can not get an enclave in session [" + sessionId + "] for set session biz key";
            throw new Exception(errMsg);
        }
        EnclaveNodeInfo enclaveNodeInfo = enclaveForUpdateBizKey.fetchStructInfoCopy();
        String zone = enclaveNodeInfo.getZone();
        if (!this.oasisAppConfiguration.isSelfZone(zone)) {
            return this.remoteGatewayManager.getGatewayTrServiceByZoneName(zone).raSetSessionBizKey(request);
        }
        String topic = request.getTopicId();
        EnclaveParam enclaveParam = new EnclaveParam(enclaveNodeInfo.getHost(), topic, enclaveForUpdateBizKey.getEnclaveNodeId());
        return EnclaveServiceClient.raSetSessionBizKey(enclaveParam, request, header);
    }
}

