/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oasis.biz.service.impl.gateway.service.servable;

import com.alipay.oasis.biz.service.impl.gateway.data.container.DataContainer;
import com.alipay.oasis.biz.service.impl.gateway.oasiscall.enclaveservice.EnclaveParam;
import com.alipay.oasis.biz.service.impl.gateway.oasiscall.enclaveservice.EnclaveServiceClient;
import com.alipay.oasis.biz.service.impl.gateway.oasiscall.remotegateway.RemoteGatewayManager;
import com.alipay.oasis.biz.service.impl.gateway.service.servable.ServableCommon;
import com.alipay.oasis.common.dal.mysql.dataobject.EnclaveNodeDO;
import com.alipay.oasis.common.dal.mysql.dataobject.SessionNodeClusterDO;
import com.alipay.oasis.common.dal.mysql.doinfo.EnclaveNodeInfo;
import com.alipay.oasis.common.util.config.OasisAppConfiguration;
import com.alipay.oasis.common.util.header.Header;
import com.alipay.oasis.common.util.service.Servable;
import com.alipay.oasis.proto.gateway.Gateway;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Map;

public class ServableRaFetchMsg3Impl
implements Servable<Gateway.GatewayRaFetchMsg3Request, Gateway.GatewayRaFetchMsg3Response> {
    private final DataContainer dataContainer;
    private final RemoteGatewayManager remoteGatewayManager;
    private final OasisAppConfiguration oasisAppConfiguration;

    public ServableRaFetchMsg3Impl(DataContainer dataContainer, RemoteGatewayManager remoteGatewayManager, OasisAppConfiguration oasisAppConfiguration) {
        this.dataContainer = dataContainer;
        this.remoteGatewayManager = remoteGatewayManager;
        this.oasisAppConfiguration = oasisAppConfiguration;
    }

    public Gateway.GatewayRaFetchMsg3Response call(Gateway.GatewayRaFetchMsg3Request request, Header header, Map<String, Object> context) throws Exception {
        String sessionId = request.getSessionId();
        SessionNodeClusterDO sessionNodeClusterDO = ServableCommon.getSessionNodeClusterDO(sessionId, this.dataContainer);
        ServableCommon.checkSessionExpired(sessionNodeClusterDO);
        EnclaveNodeDO leaderEnclave = this.dataContainer.getLeaderEnclave(sessionId);
        if (leaderEnclave == null) {
            throw new Exception("No leader for session [" + sessionId + "]. Can not get enclave for fetching msg3");
        }
        EnclaveNodeInfo enclaveNodeInfo = leaderEnclave.fetchStructInfoCopy();
        String zone = enclaveNodeInfo.getZone();
        if (!this.oasisAppConfiguration.isSelfZone(zone)) {
            return this.remoteGatewayManager.getGatewayTrServiceByZoneName(zone).raFetchMsg3(request);
        }
        String topic = request.getTopicId();
        EnclaveParam enclaveParam = new EnclaveParam(enclaveNodeInfo.getHost(), topic, leaderEnclave.getEnclaveNodeId());
        return this.raFetchMsg3Inner(enclaveParam, request, header);
    }

    Gateway.GatewayRaFetchMsg3Response raFetchMsg3Inner(EnclaveParam enclaveParam, Gateway.GatewayRaFetchMsg3Request request, Header header) throws InvalidProtocolBufferException {
        return EnclaveServiceClient.raFetchMsg3(enclaveParam, request, header);
    }
}

